/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsapi.world.util.BoundingBoxHelper;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1701;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_39;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;

public class BigTunnel
extends BetterMineshaftPiece {
    private final List<class_2338> smallShaftLeftEntrances = Lists.newLinkedList();
    private final List<class_2338> smallShaftRightEntrances = Lists.newLinkedList();
    private final List<class_3341> sideRoomEntrances = Lists.newLinkedList();
    private final List<Integer> bigSupports = Lists.newLinkedList();
    private final List<Integer> smallSupports = Lists.newLinkedList();
    private final List<Pair<Integer, Integer>> gravelDeposits = Lists.newLinkedList();
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 8;
    private static final int MAIN_AXIS_LEN = 24;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 7;
    private static final int LOCAL_Z_END = 23;

    public BigTunnel(class_2487 compoundTag) {
        super(StructurePieceTypeModule.BIG_TUNNEL, compoundTag);
        int i;
        class_2499 listTag1 = compoundTag.method_10554("SmallShaftLeftEntrances", 11);
        class_2499 listTag2 = compoundTag.method_10554("SmallShaftRightEntrances", 11);
        class_2499 listTag3 = compoundTag.method_10554("SideRoomEntrances", 11);
        class_2499 listTag4 = compoundTag.method_10554("BigSupports", 3);
        class_2499 listTag5 = compoundTag.method_10554("SmallSupports", 3);
        class_2499 listTag6 = compoundTag.method_10554("GravelDeposits", 11);
        for (i = 0; i < listTag1.size(); ++i) {
            this.smallShaftLeftEntrances.add(new class_2338(listTag1.method_36111(i)[0], listTag1.method_36111(i)[1], listTag1.method_36111(i)[2]));
        }
        for (i = 0; i < listTag2.size(); ++i) {
            this.smallShaftRightEntrances.add(new class_2338(listTag2.method_36111(i)[0], listTag2.method_36111(i)[1], listTag2.method_36111(i)[2]));
        }
        for (i = 0; i < listTag3.size(); ++i) {
            this.sideRoomEntrances.add(new class_3341(listTag3.method_36111(i)[0], listTag3.method_36111(i)[1], listTag3.method_36111(i)[2], listTag3.method_36111(i)[3], listTag3.method_36111(i)[4], listTag3.method_36111(i)[5]));
        }
        for (i = 0; i < listTag4.size(); ++i) {
            this.bigSupports.add(listTag4.method_10600(i));
        }
        for (i = 0; i < listTag5.size(); ++i) {
            this.smallSupports.add(listTag5.method_10600(i));
        }
        for (i = 0; i < listTag6.size(); ++i) {
            this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)listTag6.method_36111(i)[0], (Object)listTag6.method_36111(i)[1]));
        }
    }

    public BigTunnel(int chainLength, class_3341 blockBox, class_2350 direction, BetterMineshaftConfiguration config) {
        super(StructurePieceTypeModule.BIG_TUNNEL, chainLength, config, blockBox);
        this.method_14926(direction);
    }

    @Override
    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        super.method_14943(structurePieceSerializationContext, compoundTag);
        class_2499 listTag1 = new class_2499();
        class_2499 listTag2 = new class_2499();
        class_2499 listTag3 = new class_2499();
        class_2499 listTag4 = new class_2499();
        class_2499 listTag5 = new class_2499();
        class_2499 listTag6 = new class_2499();
        this.smallShaftLeftEntrances.forEach(pos -> listTag1.add((Object)new class_2495(new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()})));
        this.smallShaftRightEntrances.forEach(pos -> listTag2.add((Object)new class_2495(new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()})));
        this.sideRoomEntrances.forEach(blockBox -> listTag3.add((Object)new class_2495(new int[]{blockBox.method_35415(), blockBox.method_35416(), blockBox.method_35417(), blockBox.method_35418(), blockBox.method_35419(), blockBox.method_35420()})));
        this.bigSupports.forEach(z -> listTag4.add((Object)class_2497.method_23247((int)z)));
        this.smallSupports.forEach(z -> listTag5.add((Object)class_2497.method_23247((int)z)));
        this.gravelDeposits.forEach(pair -> listTag6.add((Object)new class_2495(new int[]{(Integer)pair.getFirst(), (Integer)pair.getSecond()})));
        compoundTag.method_10566("SmallShaftLeftEntrances", (class_2520)listTag1);
        compoundTag.method_10566("SmallShaftRightEntrances", (class_2520)listTag2);
        compoundTag.method_10566("SideRoomEntrances", (class_2520)listTag3);
        compoundTag.method_10566("BigSupports", (class_2520)listTag4);
        compoundTag.method_10566("SmallSupports", (class_2520)listTag5);
        compoundTag.method_10566("GravelDeposits", (class_2520)listTag6);
    }

    public static class_3341 determineBoxPosition(int x, int y, int z, class_2350 direction) {
        return BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)9, (int)8, (int)24, (class_2350)direction);
    }

    @Override
    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource) {
        class_2350 direction = this.method_14934();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415(), this.field_15315.method_35416(), this.field_15315.method_35417() - 1, direction, this.field_15316);
                break;
            }
            case field_11035: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418(), this.field_15315.method_35416(), this.field_15315.method_35420() + 1, direction, this.field_15316);
                break;
            }
            case field_11039: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35420(), direction, this.field_15316);
                break;
            }
            case field_11034: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417(), direction, this.field_15316);
            }
        }
        int pieceLen = this.method_14934().method_10166() == class_2350.class_2351.field_11051 ? this.field_15315.method_14663() : this.field_15315.method_35414();
        this.buildSideRoomsLeft(structurePiece, structurePieceAccessor, randomSource, direction, pieceLen);
        this.buildSideRoomsRight(structurePiece, structurePieceAccessor, randomSource, direction, pieceLen);
        this.buildSmallShaftsLeft(structurePiece, structurePieceAccessor, randomSource, direction, pieceLen);
        this.buildSmallShaftsRight(structurePiece, structurePieceAccessor, randomSource, direction, pieceLen);
        this.buildSupports(randomSource);
        this.buildGravelDeposits(randomSource);
    }

    public void method_14931(class_5281 world, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        this.chanceReplaceNonAir(world, box, randomSource, this.config.replacementRate, 0, 0, 0, 8, 7, 23, this.config.blockStateRandomizers.mainRandomizer);
        this.chanceReplaceNonAir(world, box, randomSource, this.config.replacementRate, 0, 0, 0, 8, 0, 23, this.config.blockStateRandomizers.floorRandomizer);
        this.fill(world, box, 1, 1, 0, 7, 4, 23, AIR);
        this.fill(world, box, 2, 4, 0, 6, 5, 23, AIR);
        this.fill(world, box, 3, 6, 0, 5, 6, 23, AIR);
        this.replaceAirOrChains(world, box, 1, 0, 0, 7, 0, 23, this.config.blockStates.mainBlockState);
        this.generateSmallShaftEntrances(world, box, randomSource);
        this.generateSideRoomOpenings(world, box, randomSource);
        this.generateLegs(world, box, randomSource);
        this.generateBigSupports(world, box, randomSource);
        this.generateSmallSupports(world, box, randomSource);
        this.generateChestCarts(world, box, randomSource);
        this.generateTntCarts(world, box, randomSource);
        this.generateGravelDeposits(world, box, randomSource);
        this.addBiomeDecorations(world, box, randomSource, 0, 0, 0, 8, 6, 23);
        this.addVines(world, box, randomSource, this.config.decorationChances.vineChance, 1, 0, 1, 7, 7, 22);
        this.generateLanterns(world, box, randomSource);
        this.generateRails(world, box, randomSource);
    }

    private void generateSmallShaftEntrances(class_5281 world, class_3341 box, class_5819 randomSource) {
        class_2680 blockState;
        int j;
        int i;
        int numCovered;
        int z;
        int y;
        int x;
        for (class_2338 entrancePos : this.smallShaftLeftEntrances) {
            x = entrancePos.method_10263();
            y = entrancePos.method_10264();
            z = entrancePos.method_10260();
            numCovered = 0;
            for (i = z; i <= z + 2; ++i) {
                for (j = x; j <= x + 1; ++j) {
                    blockState = this.method_14929((class_1922)world, j, y + 3, i, box);
                    if (blockState.method_26215() || blockState.method_27852(class_2246.field_23985)) continue;
                    ++numCovered;
                }
            }
            this.fill(world, box, x, y, z, x + 1, y + 2, z + 2, AIR);
            this.replaceAirOrChains(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.config.blockStates.mainBlockState);
            if (numCovered < 2) continue;
            this.method_14917(world, this.config.blockStates.supportBlockState, x, y + 1, z, box);
            this.method_14917(world, this.config.blockStates.supportBlockState, x, y + 1, z + 2, box);
            this.fill(world, box, x + 1, y, z, x + 1, y + 1, z, this.config.blockStates.supportBlockState);
            this.fill(world, box, x + 1, y, z + 2, x + 1, y + 1, z + 2, this.config.blockStates.supportBlockState);
            this.chanceFill(world, box, randomSource, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.config.blockStates.mainBlockState);
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, AIR);
        }
        for (class_2338 entrancePos : this.smallShaftRightEntrances) {
            x = entrancePos.method_10263();
            y = entrancePos.method_10264();
            z = entrancePos.method_10260();
            numCovered = 0;
            for (i = z; i <= z + 2; ++i) {
                for (j = x; j <= x + 1; ++j) {
                    blockState = this.method_14929((class_1922)world, j, y + 3, i, box);
                    if (blockState.method_26215() || blockState.method_27852(class_2246.field_23985)) continue;
                    ++numCovered;
                }
            }
            this.fill(world, box, x, y, z, x + 1, y + 2, z + 2, AIR);
            this.replaceAirOrChains(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.config.blockStates.mainBlockState);
            if (numCovered < 2) continue;
            this.method_14917(world, this.config.blockStates.supportBlockState, x + 1, y + 1, z, box);
            this.method_14917(world, this.config.blockStates.supportBlockState, x + 1, y + 1, z + 2, box);
            this.fill(world, box, x, y, z, x, y + 1, z, this.config.blockStates.supportBlockState);
            this.fill(world, box, x, y, z + 2, x, y + 1, z + 2, this.config.blockStates.supportBlockState);
            this.chanceFill(world, box, randomSource, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.config.blockStates.mainBlockState);
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, AIR);
        }
    }

    private void generateLegs(class_5281 world, class_3341 box, class_5819 randomSource) {
        if (this.config.legVariant == BetterMineshaftConfiguration.LegVariant.EDGE) {
            this.generateLegsVariant1(world, box, randomSource);
        } else {
            this.generateLegsVariant2(world, box, randomSource);
        }
    }

    private void generateLegsVariant1(class_5281 world, class_3341 box, class_5819 randomSource) {
        BlockStateRandomizer legSelector;
        boolean generatedLeg;
        class_2680 supportBlock = this.config.blockStates.supportBlockState;
        if (supportBlock.method_28501().contains(class_2741.field_22175) && supportBlock.method_28501().contains(class_2741.field_22176)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_22175, (Comparable)class_4778.field_22180)).method_11657((class_2769)class_2741.field_22176, (Comparable)class_4778.field_22180);
        } else if (supportBlock.method_28501().contains(class_2741.field_12489) && supportBlock.method_28501().contains(class_2741.field_12540)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true));
        }
        if (supportBlock.method_28501().contains(class_2741.field_12519)) {
            supportBlock = (class_2680)supportBlock.method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(false));
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 1, 0, legSelector = this.config.blockStateRandomizers.legRandomizer)) {
            this.replaceAirOrChains(world, box, 1, -1, 1, 1, -1, 5, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 1, 1, -2, 3, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 1, 1, -3, 2, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 1, 1, -4, 1, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 1, 11, legSelector)) {
            this.replaceAirOrChains(world, box, 1, -1, 6, 1, -1, 10, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 8, 1, -2, 10, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 9, 1, -3, 10, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 10, 1, -4, 10, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 1, 12, legSelector)) {
            this.replaceAirOrChains(world, box, 1, -1, 13, 1, -1, 17, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 13, 1, -2, 15, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 13, 1, -3, 14, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 13, 1, -4, 13, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 1, 23, legSelector)) {
            this.replaceAirOrChains(world, box, 1, -1, 18, 1, -1, 22, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 20, 1, -2, 22, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 21, 1, -3, 22, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 22, 1, -4, 22, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 7, 0, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 1, 7, -1, 5, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 1, 7, -2, 3, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 1, 7, -3, 2, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 1, 7, -4, 1, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 7, 11, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 6, 7, -1, 10, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 8, 7, -2, 10, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 9, 7, -3, 10, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 10, 7, -4, 10, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 7, 12, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 13, 7, -1, 17, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 13, 7, -2, 15, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 13, 7, -3, 14, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 13, 7, -4, 13, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, randomSource, box, 7, 23, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 18, 7, -1, 22, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 20, 7, -2, 22, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 21, 7, -3, 22, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 22, 7, -4, 22, supportBlock);
        }
    }

    private void generateLegsVariant2(class_5281 world, class_3341 box, class_5819 randomSource) {
        BlockStateRandomizer legSelector = this.config.blockStateRandomizers.legRandomizer;
        for (int z = 0; z <= 23; z += 7) {
            this.generateLeg(world, randomSource, box, 2, z + 1, legSelector);
            this.generateLeg(world, randomSource, box, 6, z + 1, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 1, -1, z, 7, -1, z + 2, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 2, -1, z + 3, 2, -1, z + 3, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 6, -1, z + 3, 6, -1, z + 3, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 3, -1, z + 3, 5, -1, z + 6, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 2, -1, z + 6, 2, -1, z + 6, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 6, -1, z + 6, 6, -1, z + 6, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 2, -2, z, 2, -2, z, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 6, -2, z, 6, -2, z, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 2, -2, z + 2, 2, -2, z + 2, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 6, -2, z + 2, 6, -2, z + 2, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 1, -2, z + 1, 1, -2, z + 1, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 7, -2, z + 1, 7, -2, z + 1, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 3, -2, z + 1, 3, -2, z + 1, legSelector);
            this.replaceAirOrChains(world, box, randomSource, 5, -2, z + 1, 5, -2, z + 1, legSelector);
        }
    }

    private void generateGravelDeposits(class_5281 world, class_3341 box, class_5819 randomSource) {
        this.gravelDeposits.forEach(pair -> {
            int z = (Integer)pair.getFirst();
            int side = (Integer)pair.getSecond();
            switch (side) {
                default: {
                    this.replaceAirOrChains(world, box, 1, 1, z, 1, 2, z + 2, this.config.blockStates.gravelBlockState);
                    this.replaceAirOrChains(world, box, 1, 3, z + 1, 1, 3 + randomSource.method_43048(2), z + 1, this.config.blockStates.gravelBlockState);
                    this.chanceReplaceAir(world, box, randomSource, 0.5f, 1, 3, z, 1, 3, z + 2, this.config.blockStates.gravelBlockState);
                    this.replaceAirOrChains(world, box, 2, 1, z + 1, 2, 2 + randomSource.method_43048(2), z + 1, this.config.blockStates.gravelBlockState);
                    this.replaceAirOrChains(world, box, 2, 1, z, 2, 1 + randomSource.method_43048(2), z + 2, this.config.blockStates.gravelBlockState);
                    this.chanceReplaceAir(world, box, randomSource, 0.5f, 3, 1, z, 3, 1, z + 2, this.config.blockStates.gravelBlockState);
                    break;
                }
                case 1: {
                    this.replaceAirOrChains(world, box, 7, 1, z, 7, 2, z + 2, this.config.blockStates.gravelBlockState);
                    this.replaceAirOrChains(world, box, 7, 3, z + 1, 7, 3 + randomSource.method_43048(2), z + 1, this.config.blockStates.gravelBlockState);
                    this.chanceReplaceAir(world, box, randomSource, 0.5f, 7, 3, z, 7, 3, z + 2, this.config.blockStates.gravelBlockState);
                    this.replaceAirOrChains(world, box, 6, 1, z + 1, 6, 2 + randomSource.method_43048(2), z + 1, this.config.blockStates.gravelBlockState);
                    this.replaceAirOrChains(world, box, 6, 1, z, 6, 1 + randomSource.method_43048(2), z + 2, this.config.blockStates.gravelBlockState);
                    this.chanceReplaceAir(world, box, randomSource, 0.5f, 5, 1, z, 5, 1, z + 2, this.config.blockStates.gravelBlockState);
                }
            }
        });
    }

    private void generateChestCarts(class_5281 world, class_3341 box, class_5819 randomSource) {
        for (int z = 0; z <= 23; ++z) {
            class_2338.class_2339 blockPos;
            if (!((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.mainShaftChestMinecartSpawnRate) || !box.method_14662((class_2382)(blockPos = this.method_33781(4, 1, z))) || world.method_8320(blockPos.method_10074()).method_26215()) continue;
            class_1694 chestMinecartEntity = new class_1694((class_1937)world.method_8410(), (double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.5f), (double)((float)blockPos.method_10260() + 0.5f));
            chestMinecartEntity.method_7562(class_39.field_472, randomSource.method_43055());
            world.method_8649((class_1297)chestMinecartEntity);
        }
    }

    private void generateTntCarts(class_5281 world, class_3341 box, class_5819 randomSource) {
        for (int z = 0; z <= 23; ++z) {
            class_2338.class_2339 blockPos;
            if (!((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.mainShaftTntMinecartSpawnRate) || !box.method_14662((class_2382)(blockPos = this.method_33781(4, 1, z))) || world.method_8320(blockPos.method_10074()).method_26215()) continue;
            class_1701 tntMinecartEntity = new class_1701((class_1937)world.method_8410(), (double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.5f), (double)((float)blockPos.method_10260() + 0.5f));
            world.method_8649((class_1297)tntMinecartEntity);
        }
    }

    private void generateBigSupports(class_5281 world, class_3341 box, class_5819 randomSource) {
        float cobwebChance = (float)BetterMineshaftsCommon.CONFIG.spawnRates.cobwebSpawnRate;
        class_2680 supportBlock = this.config.blockStates.supportBlockState;
        if (supportBlock.method_28501().contains(class_2741.field_22174) && supportBlock.method_28501().contains(class_2741.field_22177)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_22174, (Comparable)class_4778.field_22180)).method_11657((class_2769)class_2741.field_22177, (Comparable)class_4778.field_22180);
        } else if (supportBlock.method_28501().contains(class_2741.field_12487) && supportBlock.method_28501().contains(class_2741.field_12527)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.bigSupports) {
            int numCovered = 0;
            for (int x = 2; x <= 6; ++x) {
                class_2680 blockState = this.method_14929((class_1922)world, x, 7, z, box);
                if (blockState.method_26215() || blockState.method_27852(class_2246.field_23985)) continue;
                ++numCovered;
            }
            if (numCovered < 2) continue;
            this.chanceFill(world, box, randomSource, 0.6f, 1, 1, z, 2, 1, z + 2, this.config.blockStates.slabBlockState);
            this.chanceFill(world, box, randomSource, 0.6f, 6, 1, z, 7, 1, z + 2, this.config.blockStates.slabBlockState);
            this.method_14917(world, this.config.blockStates.mainBlockState, 1, 1, z + 1, box);
            this.method_14917(world, this.config.blockStates.mainBlockState, 7, 1, z + 1, box);
            this.method_14917(world, this.config.blockStates.mainBlockState, 1, 4, z + 1, box);
            this.method_14917(world, this.config.blockStates.mainBlockState, 7, 4, z + 1, box);
            this.fill(world, box, 2, 5, z + 1, 6, 5, z + 1, this.config.blockStates.mainBlockState);
            this.fill(world, box, 1, 2, z + 1, 1, 3, z + 1, this.config.blockStates.supportBlockState);
            this.fill(world, box, 7, 2, z + 1, 7, 3, z + 1, this.config.blockStates.supportBlockState);
            this.chanceReplaceNonAir(world, box, randomSource, 0.4f, 2, 5, z + 1, 6, 5, z + 1, supportBlock);
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 1, 1, z, 1, 4, z + 2, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 7, 1, z, 7, 4, z + 2, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 2, 5, z, 6, 5, z + 2, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 2, 4, z + 1, 6, 4, z + 1, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 3, 6, z + 1, 5, 6, z + 1, class_2246.field_10343.method_9564());
        }
    }

    private void generateSmallSupports(class_5281 world, class_3341 box, class_5819 randomSource) {
        float cobwebChance = (float)BetterMineshaftsCommon.CONFIG.spawnRates.cobwebSpawnRate;
        class_2680 supportBlock = this.config.blockStates.supportBlockState;
        if (supportBlock.method_28501().contains(class_2741.field_22174) && supportBlock.method_28501().contains(class_2741.field_22177)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_22174, (Comparable)class_4778.field_22180)).method_11657((class_2769)class_2741.field_22177, (Comparable)class_4778.field_22180);
        } else if (supportBlock.method_28501().contains(class_2741.field_12487) && supportBlock.method_28501().contains(class_2741.field_12527)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.smallSupports) {
            int numCovered = 0;
            for (int x = 2; x <= 6; ++x) {
                class_2680 blockState = this.method_14929((class_1922)world, x, 7, z, box);
                if (blockState.method_26215() || blockState.method_27852(class_2246.field_23985)) continue;
                ++numCovered;
            }
            if (numCovered < 2) continue;
            this.method_14917(world, this.config.blockStates.mainBlockState, 2, 1, z, box);
            this.method_14917(world, this.config.blockStates.mainBlockState, 6, 1, z, box);
            this.method_14917(world, this.config.blockStates.supportBlockState, 2, 2, z, box);
            this.method_14917(world, this.config.blockStates.supportBlockState, 6, 2, z, box);
            this.method_14917(world, this.config.blockStates.mainBlockState, 2, 3, z, box);
            this.method_14917(world, this.config.blockStates.mainBlockState, 6, 3, z, box);
            this.fill(world, box, 3, 4, z, 5, 4, z, this.config.blockStates.mainBlockState);
            this.chanceReplaceNonAir(world, box, randomSource, 0.5f, 3, 4, z, 5, 4, z, supportBlock);
            this.chanceFill(world, box, randomSource, 0.4f, 2, 3, z, 6, 3, z, supportBlock);
            this.method_14917(world, supportBlock, 3, 3, z, box);
            this.method_14917(world, supportBlock, 5, 3, z, box);
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 2, 3, z - 1, 6, 4, z + 1, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, randomSource, cobwebChance, 3, 5, z, 5, 5, z, class_2246.field_10343.method_9564());
        }
    }

    private void generateLanterns(class_5281 world, class_3341 box, class_5819 randomSource) {
        class_2680 LANTERN = (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(true));
        for (int z = 0; z <= 23; ++z) {
            for (int x = 3; x <= 5; ++x) {
                if (!((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.lanternSpawnRate) || !LANTERN.method_26184((class_4538)world, (class_2338)this.method_33781(x, 6, z))) continue;
                this.method_14917(world, LANTERN, x, 6, z, box);
                z += 20;
            }
        }
    }

    private void generateRails(class_5281 world, class_3341 box, class_5819 randomSource) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int z = 0; z <= 23; ++z) {
            mutable.method_10103(this.method_14928(4, z), this.method_14924(1), this.method_14941(4, z));
            if (!(randomSource.method_43057() < 0.5f) || !this.method_14929((class_1922)world, 4, 1, z, box).method_27852(class_2246.field_10124) && !this.method_14929((class_1922)world, 4, 1, z, box).method_27852(class_2246.field_10543) || !class_2246.field_10167.method_9558(AIR, (class_4538)world, (class_2338)mutable)) continue;
            this.method_14917(world, class_2246.field_10167.method_9564(), 4, 1, z, box);
        }
        int blocksSinceLastRail = 0;
        for (int n = 0; n <= 23; ++n) {
            if (randomSource.method_43048(20) != 0 && ++blocksSinceLastRail <= 25 || this.method_14929((class_1922)world, 4, 1, n, box).method_26204() != class_2246.field_10167) continue;
            this.method_14917(world, (class_2680)class_2246.field_10425.method_9564().method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true)), 4, 1, n, box);
            blocksSinceLastRail = 0;
        }
    }

    private void generateSideRoomOpenings(class_5281 world, class_3341 chunkBox, class_5819 randomSource) {
        this.sideRoomEntrances.forEach(entranceBox -> {
            this.replaceAirOrChains(world, chunkBox, randomSource, entranceBox.method_35415(), 0, entranceBox.method_35417(), entranceBox.method_35418(), 0, entranceBox.method_35420(), this.config.blockStateRandomizers.brickRandomizer);
            switch (randomSource.method_43048(3)) {
                case 0: {
                    this.fill(world, chunkBox, entranceBox.method_35415(), entranceBox.method_35416(), entranceBox.method_35417() + 2, entranceBox.method_35418(), entranceBox.method_35419(), entranceBox.method_35420() - 2, AIR);
                    return;
                }
                case 1: {
                    this.fill(world, chunkBox, entranceBox.method_35415(), entranceBox.method_35416(), entranceBox.method_35417() + 2, entranceBox.method_35418(), entranceBox.method_35419() - 1, entranceBox.method_35417() + 2, AIR);
                    this.fill(world, chunkBox, entranceBox.method_35415(), entranceBox.method_35416(), entranceBox.method_35417() + 4, entranceBox.method_35418(), entranceBox.method_35419() - 1, entranceBox.method_35417() + 5, AIR);
                    this.fill(world, chunkBox, entranceBox.method_35415(), entranceBox.method_35416(), entranceBox.method_35417() + 7, entranceBox.method_35418(), entranceBox.method_35419() - 1, entranceBox.method_35417() + 7, AIR);
                    return;
                }
            }
        });
    }

    private void buildGravelDeposits(class_5819 random) {
        for (int z = 0; z <= 21; ++z) {
            float r = random.method_43057();
            int currPos = z;
            if (r < this.config.decorationChances.gravelPileChance / 2.0f) {
                this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)currPos, (Object)0));
                z += 2;
                continue;
            }
            if (!(r < this.config.decorationChances.gravelPileChance)) continue;
            this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)currPos, (Object)1));
            z += 2;
        }
    }

    private void buildSupports(class_5819 randomSource) {
        int counter = 0;
        int MAX_COUNT = 10;
        for (int z = 0; z <= 21; ++z) {
            ++counter;
            boolean blockingEntrance = false;
            for (class_2338 entrancePos : this.smallShaftLeftEntrances) {
                if (entrancePos.method_10260() > z + 2 || z > entrancePos.method_10260() + 2) continue;
                blockingEntrance = true;
                break;
            }
            for (class_2338 entrancePos : this.smallShaftRightEntrances) {
                if (entrancePos.method_10260() > z + 2 || z > entrancePos.method_10260() + 2) continue;
                blockingEntrance = true;
                break;
            }
            if (blockingEntrance) continue;
            int r = randomSource.method_43048(8);
            if (r == 0 || counter >= 10) {
                this.bigSupports.add(z);
                counter = 0;
                z += 3;
                continue;
            }
            if (r != 1) continue;
            this.smallSupports.add(z);
            counter = 0;
            z += 3;
        }
    }

    private void buildSideRoomsLeft(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, class_2350 direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.workstationSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() - 5, this.field_15315.method_35416(), this.field_15315.method_35420() - n - 9, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() + 5, this.field_15315.method_35416(), this.field_15315.method_35417() + n + 9, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() - n - 9, this.field_15315.method_35416(), this.field_15315.method_35420() + 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() + n + 9, this.field_15315.method_35416(), this.field_15315.method_35417() - 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSideRoomsRight(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, class_2350 direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.workstationSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() + 5, this.field_15315.method_35416(), this.field_15315.method_35420() - n, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() - 5, this.field_15315.method_35416(), this.field_15315.method_35417() + n, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() - n, this.field_15315.method_35416(), this.field_15315.method_35417() - 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() + n, this.field_15315.method_35416(), this.field_15315.method_35420() + 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSmallShaftsLeft(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, class_2350 direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 4; ++n) {
            if (!((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35420() - n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n + 1));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417() + n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n + 1));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() - n, this.field_15315.method_35416(), this.field_15315.method_35420() + 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n + 1));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() + n, this.field_15315.method_35416(), this.field_15315.method_35417() - 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n + 1));
                }
            }
            n += randomSource.method_43048(7) + 5;
        }
    }

    private void buildSmallShaftsRight(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource, class_2350 direction, int pieceLen) {
        for (int n = 5; n < pieceLen; ++n) {
            if (!((double)randomSource.method_43057() < BetterMineshaftsCommon.CONFIG.spawnRates.smallShaftSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35420() - n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n - 3));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35417() + n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n - 3));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() - n, this.field_15315.method_35416(), this.field_15315.method_35417() - 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n - 3));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    BetterMineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() + n, this.field_15315.method_35416(), this.field_15315.method_35420() + 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n - 3));
                }
            }
            n += randomSource.method_43048(7) + 5;
        }
    }
}

