/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.SpikeCacheLoader;
import com.yungnickyoung.minecraft.betterendisland.world.processor.BlockReplaceProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1511;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3310;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3666;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class BetterSpikeFeature {
    private static final LoadingCache<Long, List<class_3310.class_3181>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());
    private static final List<class_3491> PROCESSORS = List.of(new BlockReplaceProcessor(class_2246.field_10184.method_9564(), new BlockStateRandomizer(class_2246.field_10540.method_9564()).addBlock(class_2246.field_22423.method_9564(), 0.3f), false, false, false, false), new BlockReplaceProcessor(class_2246.field_10015.method_9564(), new BlockStateRandomizer(class_2246.field_10124.method_9564()).addBlock(class_2246.field_22423.method_9564(), 0.1f).addBlock(class_2246.field_10540.method_9564(), 0.1f), false, false, false, false), new BlockReplaceProcessor(class_2246.field_10206.method_9564(), new BlockStateRandomizer(class_2246.field_10540.method_9564()), false, false, false, false), new DragonEggProcessor());

    public static List<class_3310.class_3181> getSpikesForLevel(class_5281 level) {
        class_5819 randomSource = class_5819.method_43049((long)level.method_8412());
        long seed = randomSource.method_43055() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)seed);
    }

    public static void placeSpike(class_5425 level, class_5819 randomSource, class_3666 config, class_3310.class_3181 spike, boolean isInitialSpawn) {
        class_3218 serverLevel;
        Pair<class_2960, class_2960> templates = BetterSpikeFeature.chooseTemplates(spike, isInitialSpawn, randomSource.method_43057() < 0.2f);
        long seed = 0L;
        if (level instanceof class_5281) {
            seed = ((class_5281)level).method_8412();
        }
        class_5819 rand = class_5819.method_43049((long)(seed ^ (long)spike.method_13966() ^ (long)spike.method_13967()));
        class_2470 rotation = class_2470.method_16548((class_5819)rand);
        int numberTimesDragonKilled = 0;
        if (level instanceof class_3218 && (serverLevel = (class_3218)level).method_29198() != null) {
            numberTimesDragonKilled = ((IDragonFight)serverLevel.method_29198()).betterendisland$numTimesDragonKilled();
        }
        int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
        class_2338 centerPos = new class_2338(spike.method_13966(), topY, spike.method_13967());
        if (!BetterSpikeFeature.placeTemplate(level, randomSource, centerPos, rotation, (class_2960)templates.getFirst(), numberTimesDragonKilled)) {
            BetterEndIslandCommon.LOGGER.error("Unable to place top spike at {}. This shouldn't happen!", (Object)centerPos);
            return;
        }
        if (!BetterSpikeFeature.placeTemplate(level, randomSource, centerPos = centerPos.method_10087(67), rotation, (class_2960)templates.getSecond(), numberTimesDragonKilled)) {
            BetterEndIslandCommon.LOGGER.error("Unable to place bottom spike at {}. This shouldn't happen!", (Object)centerPos);
            return;
        }
        if (!isInitialSpawn) {
            class_1511 endCrystal = (class_1511)class_1299.field_6110.method_5883((class_1937)level.method_8410());
            endCrystal.method_6837(config.method_15884());
            endCrystal.method_5684(config.method_15883());
            int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset();
            endCrystal.method_5808((double)spike.method_13966() + 0.5, (double)crystalY, (double)spike.method_13967() + 0.5, randomSource.method_43057() * 360.0f, 0.0f);
            level.method_8649((class_1297)endCrystal);
            level.method_8652(new class_2338(spike.method_13966(), crystalY - 1, spike.method_13967()), class_2246.field_9987.method_9564(), 3);
        }
    }

    private static Pair<class_2960, class_2960> chooseTemplates(class_3310.class_3181 spike, boolean isInitialSpawn, boolean isGuarded) {
        String pillarType = isInitialSpawn ? "initial" : (isGuarded ? "guarded" : "broken");
        int pillarHeight = (spike.method_13964() - 73) / 3;
        if (pillarHeight == 10) {
            pillarHeight = 9;
        }
        String topName = "pillar_" + pillarType + "_" + pillarHeight;
        String bottomName = "pillar_bottom_" + pillarHeight;
        ((IEndSpike)spike).betterendisland$setCrystalYOffsetFromPillarHeight(pillarHeight);
        return new Pair((Object)new class_2960("betterendisland", topName), (Object)new class_2960("betterendisland", bottomName));
    }

    private static boolean placeTemplate(class_5425 level, class_5819 randomSource, class_2338 centerPos, class_2470 rotation, class_2960 id, int numberTimesDragonKilled) {
        Optional templateOptional = level.method_8410().method_14183().method_15094(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        class_3499 template = (class_3499)templateOptional.get();
        class_2338 cornerPos = centerPos.method_10069(-template.method_15160().method_10263() / 2, 0, -template.method_15160().method_10260() / 2);
        class_3492 structurePlaceSettings = new class_3492();
        PROCESSORS.forEach(arg_0 -> ((class_3492)structurePlaceSettings).method_16184(arg_0));
        structurePlaceSettings.method_16184((class_3491)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.method_15123(rotation);
        structurePlaceSettings.method_15119(new class_2338(9, 0, 9));
        template.method_15172(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

