/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public abstract class ControllerWidget<T extends Controller<?>>
extends AbstractWidget {
    protected final T control;
    protected class_5489 wrappedTooltip;
    protected final YACLScreen screen;
    protected boolean focused = false;
    protected boolean hovered = false;
    protected final class_2561 modifiedOptionName;
    protected final String optionNameString;

    public ControllerWidget(T control, YACLScreen screen, Dimension<Integer> dim) {
        super(dim);
        this.control = control;
        this.screen = screen;
        control.option().addListener((opt, pending) -> this.updateTooltip());
        this.updateTooltip();
        this.modifiedOptionName = control.option().name().method_27661().method_27692(class_124.field_1056);
        this.optionNameString = control.option().name().getString().toLowerCase();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.hovered = this.method_25405(mouseX, mouseY);
        class_2561 name = this.control.option().changed() ? this.modifiedOptionName : this.control.option().name();
        class_5250 shortenedName = class_2561.method_43470((String)GuiUtils.shortenString(name.getString(), this.textRenderer, this.getDimension().width() - this.getControlWidth() - this.getXPadding() - 7, "...")).method_10862(name.method_10866());
        this.drawButtonRect(graphics, this.getDimension().x(), this.getDimension().y(), this.getDimension().xLimit(), this.getDimension().yLimit(), this.hovered || this.focused, this.isAvailable());
        graphics.method_51439(this.textRenderer, (class_2561)shortenedName, this.getDimension().x() + this.getXPadding(), this.getTextY(), this.getValueColor(), true);
        this.drawValueText(graphics, mouseX, mouseY, delta);
        if (this.isHovered()) {
            this.drawHoveredControl(graphics, mouseX, mouseY, delta);
        }
    }

    protected void drawHoveredControl(class_332 graphics, int mouseX, int mouseY, float delta) {
    }

    protected void drawValueText(class_332 graphics, int mouseX, int mouseY, float delta) {
        class_2561 valueText = this.getValueText();
        graphics.method_51439(this.textRenderer, valueText, this.getDimension().xLimit() - this.textRenderer.method_27525((class_5348)valueText) - this.getXPadding(), this.getTextY(), this.getValueColor(), true);
    }

    private void updateTooltip() {
        this.wrappedTooltip = class_5489.method_30890((class_327)this.textRenderer, (class_5348)this.control.option().tooltip(), (int)(this.screen.field_22789 / 3 * 2 - 10));
    }

    protected int getControlWidth() {
        return this.isHovered() ? this.getHoveredControlWidth() : this.getUnhoveredControlWidth();
    }

    public boolean isHovered() {
        return this.isAvailable() && (this.hovered || this.focused);
    }

    protected abstract int getHoveredControlWidth();

    protected int getUnhoveredControlWidth() {
        return this.textRenderer.method_27525((class_5348)this.getValueText());
    }

    protected int getXPadding() {
        return 5;
    }

    protected int getYPadding() {
        return 2;
    }

    protected class_2561 getValueText() {
        return this.control.formatValue();
    }

    protected boolean isAvailable() {
        return this.control.option().available();
    }

    protected int getValueColor() {
        return this.isAvailable() ? -1 : -6250336;
    }

    @Override
    public boolean canReset() {
        return true;
    }

    protected int getTextY() {
        float f = (float)this.getDimension().y().intValue() + (float)this.getDimension().height().intValue() / 2.0f;
        Objects.requireNonNull(this.textRenderer);
        return (int)(f - 9.0f / 2.0f);
    }

    @Nullable
    public class_8016 method_48205(class_8023 focusNavigationEvent) {
        return !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    @Override
    public void unfocus() {
        this.focused = false;
    }

    @Override
    public boolean matchesSearch(String query) {
        return this.optionNameString.contains(query.toLowerCase());
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return this.focused ? class_6379.class_6380.field_33786 : (this.isHovered() ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784);
    }

    @Override
    public void method_37020(class_6382 builder2) {
        builder2.method_37034(class_6381.field_33788, this.control.option().name());
        builder2.method_37034(class_6381.field_33790, this.control.option().tooltip());
    }
}

