/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.event.v1.entity.player.BonemealCallback;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.BonemealHandler;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.DirtBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.FruitStemBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.MyceliumBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.NetherWartBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PodzolBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PopResourceBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleGrowingPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleSpreadBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.VineBehavior;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalBoneMeal
implements ModConstructor {
    public static final String MOD_ID = "universalbonemeal";
    public static final String MOD_NAME = "Universal Bone Meal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Universal Bone Meal");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"universalbonemeal").server(ServerConfig.class);

    public void onConstructMod() {
        CONFIG.getHolder(ServerConfig.class).accept(BonemealHandler::invalidate);
        UniversalBoneMeal.registerHandlers();
    }

    private static void registerHandlers() {
        BonemealCallback.EVENT.register(BonemealHandler::onBonemeal);
    }

    public void onCommonSetup(ModLifecycleContext context) {
        UniversalBoneMeal.registerBonemealBehaviors();
    }

    private static void registerBonemealBehaviors() {
        BonemealHandler.registerBehavior(class_2246.field_10029, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCactus);
        BonemealHandler.registerBehavior(class_2246.field_10424, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSugarCane);
        BonemealHandler.registerBehavior(class_2246.field_10597, VineBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowVines);
        BonemealHandler.registerBehavior(class_2246.field_9974, NetherWartBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowNetherWart);
        BonemealHandler.registerBehavior(Set.of(class_2246.field_10168, class_2246.field_9984), FruitStemBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowFruitStems);
        BonemealHandler.registerBehavior(class_2246.field_10588, () -> new SimpleSpreadBehavior(4, 3), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowLilyPad);
        BonemealHandler.registerBehavior(class_2246.field_10428, () -> new SimpleSpreadBehavior(4, 2), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDeadBush);
        BonemealHandler.registerBehavior(Set.of(class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548), () -> new SimpleSpreadBehavior(3, 1), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSmallFlowers);
        BonemealHandler.registerBehavior((class_6862<class_2248>)class_3481.field_15483, CoralBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCorals);
        BonemealHandler.registerBehavior(class_2246.field_10528, ChorusFlowerBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(class_2246.field_10021, ChorusPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(class_2246.field_10402, MyceliumBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowMycelium);
        BonemealHandler.registerBehavior(Set.of(class_2246.field_10566, class_2246.field_10253, class_2246.field_10194), DirtBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDirt);
        BonemealHandler.registerBehavior(class_2246.field_10520, PodzolBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowPodzol);
        BonemealHandler.registerBehavior(class_2246.field_28677, () -> new PopResourceBehavior(class_2350.field_11033), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSporeBlossom);
    }
}

