/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block.entity;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import toughasnails.api.blockentity.TANBlockEntityTypes;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.block.ThermoregulatorBlock;
import toughasnails.container.ThermoregulatorContainer;
import toughasnails.init.ModTags;
import toughasnails.temperature.AreaFill;

public class ThermoregulatorBlockEntity
extends class_2624
implements class_1278 {
    public static final int INFORM_PLAYER_RADIUS = 20;
    private static final int SPREAD_RADIUS = 16;
    public static final int CONSUMABLE_DURATION = 1600;
    public static final int SLOT_COOLING = 0;
    public static final int SLOT_HEATING = 1;
    private class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private int coolingTimeRemaining;
    private int heatingTimeRemaining;
    private int fillTimer = 0;
    private Set<class_2338> filledBlocks = new HashSet<class_2338>();
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return ThermoregulatorBlockEntity.this.coolingTimeRemaining;
                }
                case 1: {
                    return ThermoregulatorBlockEntity.this.heatingTimeRemaining;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    ThermoregulatorBlockEntity.this.coolingTimeRemaining = value;
                    break;
                }
                case 1: {
                    ThermoregulatorBlockEntity.this.heatingTimeRemaining = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public ThermoregulatorBlockEntity(class_2338 pos, class_2680 state) {
        super(TANBlockEntityTypes.THERMOREGULATOR, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.items);
        this.coolingTimeRemaining = nbt.method_10550("CoolingTimeRemaining");
        this.heatingTimeRemaining = nbt.method_10550("HeatingTimeRemaining");
        this.fillTimer = nbt.method_10550("FillTimer");
        class_2499 list = nbt.method_10554("FilledBlocks", 10);
        this.filledBlocks = list.stream().map(tag -> class_2512.method_10691((class_2487)((class_2487)tag))).collect(Collectors.toCollection(HashSet::new));
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("CoolingTimeRemaining", this.coolingTimeRemaining);
        nbt.method_10569("HeatingTimeRemaining", this.heatingTimeRemaining);
        nbt.method_10569("FillTimer", this.fillTimer);
        class_2499 list = new class_2499();
        this.filledBlocks.stream().map(class_2512::method_10692).forEach(arg_0 -> list.add(arg_0));
        nbt.method_10566("FilledBlocks", (class_2520)list);
        class_1262.method_5426((class_2487)nbt, this.items);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, final ThermoregulatorBlockEntity blockEntity) {
        class_1792 remainingItem;
        class_1792 fuelItem;
        Object fuel;
        boolean previouslyCooling = blockEntity.isCooling();
        boolean previouslyHeating = blockEntity.isHeating();
        boolean changed = false;
        if (!((Boolean)state.method_11654((class_2769)ThermoregulatorBlock.ENABLED)).booleanValue()) {
            blockEntity.filledBlocks.clear();
            if (((Boolean)state.method_11654((class_2769)ThermoregulatorBlock.COOLING)).booleanValue() || ((Boolean)state.method_11654((class_2769)ThermoregulatorBlock.HEATING)).booleanValue()) {
                state = (class_2680)((class_2680)state.method_11657((class_2769)ThermoregulatorBlock.COOLING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ThermoregulatorBlock.HEATING, (Comparable)Boolean.valueOf(false));
                level.method_8652(pos, state, 3);
                ThermoregulatorBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
            }
            return;
        }
        if (blockEntity.isCooling()) {
            --blockEntity.coolingTimeRemaining;
        }
        if (blockEntity.isHeating()) {
            --blockEntity.heatingTimeRemaining;
        }
        if (!blockEntity.isCooling() && !(fuel = (class_1799)blockEntity.items.get(0)).method_7960()) {
            fuelItem = fuel.method_7909();
            blockEntity.coolingTimeRemaining = 1600;
            changed = true;
            fuel.method_7934(1);
            if (fuel.method_7960()) {
                remainingItem = fuelItem.method_7858();
                blockEntity.items.set(0, (Object)(remainingItem == null ? class_1799.field_8037 : new class_1799((class_1935)remainingItem)));
            }
        }
        if (!blockEntity.isHeating() && !(fuel = (class_1799)blockEntity.items.get(1)).method_7960()) {
            fuelItem = fuel.method_7909();
            blockEntity.heatingTimeRemaining = 1600;
            changed = true;
            fuel.method_7934(1);
            if (fuel.method_7960()) {
                remainingItem = fuelItem.method_7858();
                blockEntity.items.set(1, (Object)(remainingItem == null ? class_1799.field_8037 : new class_1799((class_1935)remainingItem)));
            }
        }
        if (((Boolean)state.method_11654((class_2769)ThermoregulatorBlock.COOLING)).booleanValue() != blockEntity.isCooling()) {
            changed = true;
            state = (class_2680)state.method_11657((class_2769)ThermoregulatorBlock.COOLING, (Comparable)Boolean.valueOf(blockEntity.isCooling()));
            level.method_8652(pos, state, 3);
        }
        if (((Boolean)state.method_11654((class_2769)ThermoregulatorBlock.HEATING)).booleanValue() != blockEntity.isHeating()) {
            changed = true;
            state = (class_2680)state.method_11657((class_2769)ThermoregulatorBlock.HEATING, (Comparable)Boolean.valueOf(blockEntity.isHeating()));
            level.method_8652(pos, state, 3);
        }
        if (!blockEntity.isHeating() && !blockEntity.isCooling()) {
            blockEntity.filledBlocks.clear();
        }
        if ((blockEntity.isCooling() || blockEntity.isHeating()) && blockEntity.fillTimer % 20 == 0) {
            for (class_3222 player : level.method_18467(class_3222.class, new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)pos.method_10263(), (double)(pos.method_10264() - 4), (double)pos.method_10260()).method_1009(20.0, 10.0, 20.0))) {
                ITemperature temperature = TemperatureHelper.getTemperatureData((class_1657)player);
                temperature.getNearbyThermoregulators().add(pos);
            }
            class_2338 fillStart = pos.method_10093((class_2350)state.method_11654((class_2769)ThermoregulatorBlock.FACING));
            blockEntity.filledBlocks.clear();
            AreaFill.fill(level, fillStart, new AreaFill.PositionChecker(){

                @Override
                public void onSolid(class_1937 level, AreaFill.FillPos pos) {
                }

                @Override
                public void onPassable(class_1937 level, AreaFill.FillPos pos) {
                    blockEntity.filledBlocks.add(pos.pos());
                }

                @Override
                public boolean isPassable(class_1937 level, AreaFill.FillPos pos) {
                    class_2680 state = level.method_8320(pos.pos());
                    return this.isConfined(level, pos.pos()) && (state.method_26215() || state.method_26164(ModTags.Blocks.PASSABLE_BLOCKS) || !this.isFlowBlocking(level, pos, state));
                }
            }, 16);
            changed = true;
        }
        ++blockEntity.fillTimer;
        if (changed) {
            ThermoregulatorBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
            level.method_8413(pos, state, state, 3);
        }
    }

    public Effect getEffectAtPos(class_2338 pos) {
        if (this.filledBlocks.contains(pos)) {
            return this.getEffect();
        }
        return Effect.NONE;
    }

    public ImmutableSet<class_2338> getFilledBlocks() {
        return ImmutableSet.copyOf(this.filledBlocks);
    }

    public Effect getEffect() {
        boolean cooling = this.isCooling();
        boolean heating = this.isHeating();
        if (cooling && heating) {
            return Effect.NEUTRALIZING;
        }
        if (cooling) {
            return Effect.COOLING;
        }
        if (heating) {
            return Effect.HEATING;
        }
        return Effect.NONE;
    }

    public boolean isCooling() {
        return this.coolingTimeRemaining > 0;
    }

    public boolean isHeating() {
        return this.heatingTimeRemaining > 0;
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    protected class_1703 method_5465(int id, class_1661 player) {
        return new ThermoregulatorContainer(id, player, (class_1263)this, this.dataAccess);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.toughasnails.thermoregulator");
    }

    public int[] method_5494(class_2350 direction) {
        if (direction == class_2350.field_11036) {
            return new int[]{0, 1};
        }
        class_2680 state = this.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)ThermoregulatorBlock.FACING);
        if (facing.method_10170() == direction) {
            return new int[]{0};
        }
        if (facing.method_10160() == direction) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0) {
            return ThermoregulatorBlockEntity.isCoolingFuel(stack);
        }
        if (index == 1) {
            return ThermoregulatorBlockEntity.isHeatingFuel(stack);
        }
        return false;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return false;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.items) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.items, (int)index, (int)count);
    }

    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.items, (int)index);
    }

    public void method_5447(int index, class_1799 stack) {
        class_1799 currentStack = (class_1799)this.items.get(index);
        boolean sameItem = !stack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)currentStack);
        this.items.set(index, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (!sameItem) {
            this.method_5431();
        }
    }

    public void method_5448() {
        this.items.clear();
    }

    public static boolean isCoolingFuel(class_1799 stack) {
        return stack.method_31573(ModTags.Items.THERMOREGULATOR_COOLING_FUEL);
    }

    public static boolean isHeatingFuel(class_1799 stack) {
        return stack.method_31573(ModTags.Items.THERMOREGULATOR_HEATING_FUEL);
    }

    public static enum Effect {
        COOLING,
        HEATING,
        NEUTRALIZING,
        NONE;

    }
}

