/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.TwilightForestMod;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.renderer.TFWeatherRenderer;

public class StructureProtectionPacket {
    private final BoundingBox sbb;

    public StructureProtectionPacket(BoundingBox sbb) {
        this.sbb = sbb;
    }

    public StructureProtectionPacket(FriendlyByteBuf buf) {
        this.sbb = new BoundingBox(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.sbb.m_162395_());
        buf.writeInt(this.sbb.m_162396_());
        buf.writeInt(this.sbb.m_162398_());
        buf.writeInt(this.sbb.m_162399_());
        buf.writeInt(this.sbb.m_162400_());
        buf.writeInt(this.sbb.m_162401_());
    }

    public static class Handler {
        public static boolean onMessage(StructureProtectionPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                DimensionSpecialEffects info = DimensionSpecialEffectsManager.getForType((ResourceLocation)TwilightForestMod.prefix("renderer"));
                if (info instanceof TwilightForestRenderInfo) {
                    TFWeatherRenderer.setProtectedBox(message.sbb);
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

