/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.TFPart;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.entity.boss.HydraMortar;
import twilightforest.entity.boss.HydraNeck;
import twilightforest.entity.boss.HydraPart;
import twilightforest.entity.boss.HydraSmallPart;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.WorldUtil;

public class Hydra
extends Mob
implements Enemy,
EnforcedHomePoint {
    private static final int TICKS_BEFORE_HEALING = 1000;
    private static final int HEAD_RESPAWN_TICKS = 100;
    private static final int HEAD_MAX_DAMAGE = 120;
    private static final float ARMOR_MULTIPLIER = 8.0f;
    private static final int MAX_HEALTH = 360;
    private static float HEADS_ACTIVITY_FACTOR = 0.3f;
    private static final int SECONDARY_FLAME_CHANCE = 10;
    private static final int SECONDARY_MORTAR_CHANCE = 16;
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POINT = SynchedEntityData.m_135353_(Hydra.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);
    private final HydraPart[] partArray;
    public final int numHeads = 7;
    public final HydraHeadContainer[] hc = new HydraHeadContainer[7];
    public final HydraSmallPart body;
    private final HydraSmallPart leftLeg;
    private final HydraSmallPart rightLeg;
    private final HydraSmallPart tail;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private float randomYawVelocity = 0.0f;
    private int ticksSinceDamaged = 0;
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();
    public boolean renderFakeHeads = true;
    private int numTicksToChaseTarget;

    public Hydra(EntityType<? extends Hydra> type, Level world) {
        super(type, world);
        ArrayList<HydraPart> parts = new ArrayList<HydraPart>();
        this.body = new HydraSmallPart(this, 6.0f, 6.0f);
        this.leftLeg = new HydraSmallPart(this, 2.0f, 3.0f);
        this.rightLeg = new HydraSmallPart(this, 2.0f, 3.0f);
        this.tail = new HydraSmallPart(this, 6.0f, 2.0f);
        parts.add(this.body);
        parts.add(this.leftLeg);
        parts.add(this.rightLeg);
        parts.add(this.tail);
        for (int i = 0; i < this.numHeads; ++i) {
            this.hc[i] = new HydraHeadContainer(this, i, i < 3);
            parts.add(this.hc[i].headEntity);
            Collections.addAll(parts, this.hc[i].getNeckArray());
        }
        this.partArray = parts.toArray(new HydraPart[0]);
        this.f_19811_ = true;
        this.f_21364_ = 511;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HOME_POINT, Optional.empty());
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 360.0).m_22268_(Attributes.f_22279_, 0.28);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_9236_().m_46597_(this.m_20183_().m_7918_(0, 1, 0), ((Block)TFBlocks.HYDRA_BOSS_SPAWNER.get()).m_49966_());
            this.m_146870_();
            for (HydraHeadContainer container : this.hc) {
                if (container.headEntity == null) continue;
                container.headEntity.m_146870_();
            }
        } else {
            super.m_6043_();
        }
    }

    protected float m_5632_(float p_110146_1_, float p_110146_2_) {
        boolean flag;
        float f = Mth.m_14177_((float)(p_110146_1_ - this.f_20883_));
        this.f_20883_ += f * 0.3f;
        float f1 = Mth.m_14177_((float)(this.m_146908_() - this.f_20883_));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.f_20883_ = this.m_146908_() - f1;
        if (f1 * f1 > 2500.0f) {
            this.f_20883_ += f1 * 0.2f;
        }
        if (flag) {
            p_110146_2_ *= -1.0f;
        }
        return p_110146_2_;
    }

    public void m_8107_() {
        int i;
        if (this.renderFakeHeads) {
            this.renderFakeHeads = false;
        }
        this.m_20095_();
        this.body.m_8119_();
        this.leftLeg.m_8119_();
        this.rightLeg.m_8119_();
        for (i = 0; i < this.numHeads; ++i) {
            this.hc[i].tick();
        }
        if (this.f_20916_ > 0) {
            for (i = 0; i < this.numHeads; ++i) {
                this.hc[i].setHurtTime(this.f_20916_);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.m_9236_().m_5776_() && this.ticksSinceDamaged > 1000 && this.ticksSinceDamaged % 5 == 0) {
            this.m_5634_(1.0f);
        }
        this.setDifficultyVariables();
        super.m_8107_();
        float angle = (this.f_20883_ + 180.0f) * (float)Math.PI / 180.0f;
        double dx = this.m_20185_() - (double)Mth.m_14031_((float)angle) * 3.0;
        double dy = this.m_20186_() + 0.1;
        double dz = this.m_20189_() + (double)Mth.m_14089_((float)angle) * 3.0;
        this.body.m_6034_(dx, dy, dz);
        dx = this.m_20185_() - (double)Mth.m_14031_((float)angle) * 10.5;
        dy = this.m_20186_() + 0.1;
        dz = this.m_20189_() + (double)Mth.m_14089_((float)angle) * 10.5;
        this.tail.m_6034_(dx, dy, dz);
        if (this.f_20916_ == 0) {
            this.collideWithEntities(this.m_9236_().m_45933_((Entity)this, this.body.m_20191_()), (Entity)this.body);
            this.collideWithEntities(this.m_9236_().m_45933_((Entity)this, this.tail.m_20191_()), (Entity)this.tail);
        }
        if (!this.m_9236_().m_5776_()) {
            this.destroyBlocksInAABB(this.body.m_20191_());
            this.destroyBlocksInAABB(this.tail.m_20191_());
            for (int i2 = 0; i2 < this.numHeads; ++i2) {
                if (this.hc[i2].headEntity == null || !this.hc[i2].isActive()) continue;
                this.destroyBlocksInAABB(this.hc[i2].headEntity.m_20191_());
            }
            if (this.f_19797_ % 20 == 0 && this.isUnsteadySurfaceBeneath()) {
                this.destroyBlocksInAABB(this.m_20191_().m_82386_(0.0, -1.0, 0.0));
            }
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public void m_7380_(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        compound.m_128344_("NumHeads", (byte)this.countActiveHeads());
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadHomePointFromNbt(compound);
        this.activateNumberOfHeads(compound.m_128445_("NumHeads"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    protected void m_8024_() {
        int i;
        this.f_20900_ = 0.0f;
        this.f_20902_ = 0.0f;
        float f = 48.0f;
        for (i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].isActive() || this.hc[i].getDamageTaken() <= 120) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.DYING);
            this.hc[i].endCurrentAction();
            this.hc[i].setRespawnCounter(100);
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].setRespawnCounter(100);
        }
        if (this.m_217043_().m_188501_() < 0.7f) {
            Player entityplayer1 = this.m_9236_().m_45930_((Entity)this, (double)f);
            if (entityplayer1 != null && !entityplayer1.m_7500_()) {
                this.m_6710_((LivingEntity)entityplayer1);
                this.numTicksToChaseTarget = 100 + this.m_217043_().m_188503_(20);
            } else {
                this.randomYawVelocity = (this.m_217043_().m_188501_() - 0.5f) * 20.0f;
            }
        }
        if (this.m_5448_() != null) {
            this.m_21391_((Entity)this.m_5448_(), 10.0f, this.m_8132_());
            for (i = 0; i < this.numHeads; ++i) {
                if (this.hc[i].isAttacking() || this.hc[i].isSecondaryAttacking) continue;
                this.hc[i].setTargetEntity((Entity)this.m_5448_());
            }
            if (this.m_5448_().m_6084_()) {
                float distance = this.m_5448_().m_20270_((Entity)this);
                if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                    this.attackEntity((Entity)this.m_5448_(), distance);
                }
            }
            if (this.numTicksToChaseTarget-- <= 0 || !this.m_5448_().m_6084_() || this.m_5448_().m_20280_((Entity)this) > (double)(f * f)) {
                this.m_6710_(null);
            }
        } else {
            if (this.m_217043_().m_188501_() < 0.05f) {
                this.randomYawVelocity = (this.m_217043_().m_188501_() - 0.5f) * 20.0f;
            }
            this.m_146922_(this.m_146908_() + this.randomYawVelocity);
            this.m_146926_(0.0f);
            for (i = 0; i < this.numHeads; ++i) {
                if (!this.hc[i].isIdle()) continue;
                this.hc[i].setTargetEntity(null);
            }
        }
        this.secondaryAttacks();
    }

    private void setDifficultyVariables() {
        HEADS_ACTIVITY_FACTOR = this.m_9236_().m_46791_() != Difficulty.HARD ? 0.3f : 0.5f;
    }

    private int getRandomDeadHead() {
        ArrayList<Integer> headIDs = new ArrayList<Integer>();
        for (int i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].canRespawn()) continue;
            headIDs.add(i);
        }
        return headIDs.isEmpty() ? -1 : (Integer)headIDs.get(this.f_19796_.m_188503_(headIDs.size()));
    }

    private void activateNumberOfHeads(int howMany) {
        int moreHeads = howMany - this.countActiveHeads();
        for (int i = 0; i < moreHeads; ++i) {
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].setNextState(HydraHeadContainer.State.IDLE);
            this.hc[otherHead].endCurrentAction();
        }
    }

    private void attackEntity(Entity target, float distance) {
        int i;
        int BITE_CHANCE = 10;
        int FLAME_CHANCE = 100;
        int MORTAR_CHANCE = 160;
        boolean targetAbove = target.m_20191_().f_82289_ > this.m_20191_().f_82292_;
        for (i = 0; i < 3; ++i) {
            if (!this.hc[i].isIdle() || this.areTooManyHeadsAttacking(i)) continue;
            if (distance > 4.0f && distance < 10.0f && this.m_217043_().m_188503_(BITE_CHANCE) == 0 && this.countActiveHeads() > 2 && !this.areOtherHeadsBiting(i)) {
                this.hc[i].setNextState(HydraHeadContainer.State.BITE_BEGINNING);
                continue;
            }
            if (distance > 0.0f && distance < 20.0f && this.m_217043_().m_188503_(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.m_217043_().m_188503_(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
        }
        for (i = 3; i < 7; ++i) {
            if (!this.hc[i].isIdle() || this.areTooManyHeadsAttacking(i)) continue;
            if (distance > 0.0f && distance < 20.0f && this.m_217043_().m_188503_(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.m_217043_().m_188503_(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
        }
    }

    private boolean areTooManyHeadsAttacking(int testHead) {
        int otherAttacks = 0;
        for (int i = 0; i < this.numHeads; ++i) {
            if (i == testHead || !this.hc[i].isAttacking()) continue;
            ++otherAttacks;
            if (!this.hc[i].isBiting()) continue;
            otherAttacks += 2;
        }
        return (float)otherAttacks >= 1.0f + (float)this.countActiveHeads() * HEADS_ACTIVITY_FACTOR;
    }

    private int countActiveHeads() {
        int count = 0;
        for (int i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].isActive()) continue;
            ++count;
        }
        return count;
    }

    private boolean areOtherHeadsBiting(int testHead) {
        for (int i = 0; i < this.numHeads; ++i) {
            if (i == testHead || !this.hc[i].isBiting()) continue;
            return true;
        }
        return false;
    }

    private void secondaryAttacks() {
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].headEntity != null) continue;
            return;
        }
        LivingEntity secondaryTarget = this.findSecondaryTarget(20.0);
        if (secondaryTarget != null) {
            float distance = secondaryTarget.m_20270_((Entity)this);
            for (int i = 1; i < this.numHeads; ++i) {
                if (!this.hc[i].isActive() || !this.hc[i].isIdle() || !this.isTargetOnThisSide(i, (Entity)secondaryTarget)) continue;
                if (distance > 0.0f && distance < 20.0f && this.m_217043_().m_188503_(10) == 0) {
                    this.hc[i].setTargetEntity((Entity)secondaryTarget);
                    this.hc[i].isSecondaryAttacking = true;
                    this.hc[i].setNextState(HydraHeadContainer.State.FLAME_BEGINNING);
                    continue;
                }
                if (!(distance > 8.0f) || !(distance < 32.0f) || this.m_217043_().m_188503_(16) != 0) continue;
                this.hc[i].setTargetEntity((Entity)secondaryTarget);
                this.hc[i].isSecondaryAttacking = true;
                this.hc[i].setNextState(HydraHeadContainer.State.MORTAR_BEGINNING);
            }
        }
    }

    private boolean isTargetOnThisSide(int headNum, Entity target) {
        double middleDist;
        double headDist = this.distanceSqXZ((Entity)this.hc[headNum].headEntity, target);
        return headDist < (middleDist = this.distanceSqXZ((Entity)this, target));
    }

    private double distanceSqXZ(Entity headEntity, Entity target) {
        double distX = headEntity.m_20185_() - target.m_20185_();
        double distZ = headEntity.m_20189_() - target.m_20189_();
        return distX * distX + distZ * distZ;
    }

    @Nullable
    private LivingEntity findSecondaryTarget(double range) {
        return this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82377_(range, range, range)).stream().filter(e -> !(e instanceof Hydra)).filter(e -> e != this.m_5448_() && !this.isAnyHeadTargeting((Entity)e) && this.m_21574_().m_148306_((Entity)e) && EntitySelector.f_20406_.test(e)).min(Comparator.comparingDouble(arg_0 -> ((Hydra)this).m_20280_(arg_0))).orElse(null);
    }

    private boolean isAnyHeadTargeting(Entity targetEntity) {
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].targetEntity == null || !this.hc[i].targetEntity.equals((Object)targetEntity)) continue;
            return true;
        }
        return false;
    }

    private void collideWithEntities(List<Entity> entities, Entity part) {
        double d0 = (part.m_20191_().f_82288_ + part.m_20191_().f_82291_) / 2.0;
        double d1 = (part.m_20191_().f_82290_ + part.m_20191_().f_82293_) / 2.0;
        for (Entity entity : entities) {
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_7500_() || !(entity instanceof LivingEntity)) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 8.0, 0.2, d3 / d4 * 8.0);
        }
    }

    private boolean isUnsteadySurfaceBeneath() {
        int minX = Mth.m_14107_((double)this.m_20191_().f_82288_);
        int minZ = Mth.m_14107_((double)this.m_20191_().f_82290_);
        int maxX = Mth.m_14107_((double)this.m_20191_().f_82291_);
        int maxZ = Mth.m_14107_((double)this.m_20191_().f_82293_);
        int minY = Mth.m_14107_((double)this.m_20191_().f_82289_);
        int solid = 0;
        int total = 0;
        int dy = minY - 1;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                ++total;
                if (!this.m_9236_().m_8055_(new BlockPos(dx, dy, dz)).m_280296_()) continue;
                ++solid;
            }
        }
        return (float)solid / (float)total < 0.6f;
    }

    private void destroyBlocksInAABB(AABB box) {
        if (this.f_20919_ <= 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            for (BlockPos pos : WorldUtil.getAllInBB(box)) {
                if (!EntityUtil.canDestroyBlock(this.m_9236_(), pos, (Entity)this)) continue;
                this.m_9236_().m_46961_(pos, false);
            }
        }
    }

    public int m_8132_() {
        return 500;
    }

    public boolean attackEntityFromPart(HydraPart part, DamageSource source, float damage) {
        boolean tookDamage;
        if (!this.m_9236_().m_5776_() && source.m_276093_(DamageTypes.f_268612_)) {
            this.destroyBlocksInAABB(part.m_20191_());
        }
        if (source.m_7639_() == this || source.m_7640_() == this) {
            return false;
        }
        if (this.getParts() != null) {
            for (PartEntity<?> partEntity : this.getParts()) {
                if (partEntity != source.m_7639_() && partEntity != source.m_7640_()) continue;
                return false;
            }
        }
        HydraHeadContainer headCon = null;
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].headEntity == part) {
                headCon = this.hc[i];
                continue;
            }
            if (!(part instanceof HydraNeck)) continue;
            HydraNeck neck = (HydraNeck)part;
            if (this.hc[i].headEntity != neck.head || this.hc[i].isActive()) continue;
            return false;
        }
        double range = this.calculateRange(source);
        int n = source.m_7640_() instanceof HydraMortar ? 200 : 0;
        if (range > (double)(400 + n)) {
            return false;
        }
        if (headCon != null && !headCon.isActive()) {
            return false;
        }
        if (headCon != null && (double)headCon.getCurrentMouthOpen() > 0.5) {
            tookDamage = super.m_6469_(source, damage);
            headCon.addDamage(damage);
        } else {
            int armoredDamage = Math.round(damage / 8.0f);
            tookDamage = super.m_6469_(source, (float)armoredDamage);
            if (headCon != null) {
                headCon.addDamage(armoredDamage);
            }
        }
        if (tookDamage) {
            this.ticksSinceDamaged = 0;
        }
        return tookDamage;
    }

    private double calculateRange(DamageSource damagesource) {
        return damagesource.m_7639_() != null ? this.m_20280_(damagesource.m_7639_()) : -1.0;
    }

    public boolean m_6469_(DamageSource src, float damage) {
        ServerPlayer player;
        Entity entity = src.m_7639_();
        if (entity instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        return src.m_269533_(DamageTypeTags.f_268738_) && super.m_6469_(src, damage);
    }

    public boolean m_6673_(DamageSource source) {
        return !source.m_276093_(TFDamageTypes.HYDRA_MORTAR) && super.m_6673_(source);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.partArray;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        TFPart.assignPartIDs((Entity)this);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.HYDRA_GROWL.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.HYDRA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.HYDRA_DEATH.get();
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(0.0f);
            LandmarkUtil.markStructureConquered(this.m_9236_(), this, TFStructures.HYDRA_LAIR, true);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            TFLootTables.entityDropsIntoContainer((LivingEntity)this, cause, ((TFChestBlock)((Object)TFBlocks.MANGROVE_CHEST.get())).m_49966_(), EntityUtil.bossChestLocation(this));
        }
    }

    protected boolean m_6125_() {
        return (Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get() == false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_6153_() {
        int headToDie;
        int i;
        ++this.f_20919_;
        if (this.f_20919_ == 1) {
            for (i = 0; i < this.numHeads; ++i) {
                this.hc[i].setRespawnCounter(-1);
                if (!this.hc[i].isActive()) continue;
                this.hc[i].setNextState(HydraHeadContainer.State.IDLE);
                this.hc[i].endCurrentAction();
                this.hc[i].setHurtTime(200);
            }
        }
        if (this.f_20919_ <= 140 && this.f_20919_ % 20 == 0 && this.hc[headToDie = this.f_20919_ / 20 - 1].isActive()) {
            this.hc[headToDie].setNextState(HydraHeadContainer.State.DYING);
            this.hc[headToDie].endCurrentAction();
        }
        if (this.f_20919_ == 200) {
            if (this.m_9236_() instanceof ServerLevel && !this.m_217046_() && (this.m_6124_() || this.f_20889_ > 0 && this.m_6149_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_))) {
                int reward = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.f_20888_, (int)this.m_213860_());
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)reward);
            }
            this.m_146870_();
        }
        for (i = 0; i < 10; ++i) {
            double vx = this.m_217043_().m_188583_() * 0.02;
            double vy = this.m_217043_().m_188583_() * 0.02;
            double vz = this.m_217043_().m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)(this.m_217043_().m_188503_(2) == 0 ? ParticleTypes.f_123813_ : ParticleTypes.f_123759_), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.body.m_20205_() * 2.0f) - (double)this.body.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.body.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.body.m_20205_() * 2.0f) - (double)this.body.m_20205_(), vx, vy, vz);
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    @Override
    @Nullable
    public GlobalPos getRestrictionPoint() {
        return ((Optional)this.m_20088_().m_135370_(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 20;
    }
}

