/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.stronghold;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_3443;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import twilightforest.world.components.structures.stronghold.StrongholdAtriumComponent;
import twilightforest.world.components.structures.stronghold.StrongholdBalconyRoomComponent;
import twilightforest.world.components.structures.stronghold.StrongholdBossRoomComponent;
import twilightforest.world.components.structures.stronghold.StrongholdCrossingComponent;
import twilightforest.world.components.structures.stronghold.StrongholdDeadEndComponent;
import twilightforest.world.components.structures.stronghold.StrongholdFoundryComponent;
import twilightforest.world.components.structures.stronghold.StrongholdLeftTurnComponent;
import twilightforest.world.components.structures.stronghold.StrongholdPieceWeight;
import twilightforest.world.components.structures.stronghold.StrongholdRightTurnComponent;
import twilightforest.world.components.structures.stronghold.StrongholdSmallHallwayComponent;
import twilightforest.world.components.structures.stronghold.StrongholdSmallStairsComponent;
import twilightforest.world.components.structures.stronghold.StrongholdTrainingRoomComponent;
import twilightforest.world.components.structures.stronghold.StrongholdTreasureCorridorComponent;
import twilightforest.world.components.structures.stronghold.StrongholdTreasureRoomComponent;
import twilightforest.world.components.structures.stronghold.StructureTFStrongholdComponent;

public class StrongholdPieces {
    private static final StrongholdPieceWeight[] pieceWeightArray = new StrongholdPieceWeight[]{new StrongholdPieceWeight(StrongholdSmallHallwayComponent::new, 40, 0), new StrongholdPieceWeight(StrongholdLeftTurnComponent::new, 20, 0), new StrongholdPieceWeight(StrongholdCrossingComponent::new, 10, 4), new StrongholdPieceWeight(StrongholdRightTurnComponent::new, 20, 0), new StrongholdPieceWeight(StrongholdDeadEndComponent::new, 5, 0), new StrongholdPieceWeight(StrongholdBalconyRoomComponent::new, 10, 3, 2), new StrongholdPieceWeight(StrongholdTrainingRoomComponent::new, 10, 2), new StrongholdPieceWeight(StrongholdSmallStairsComponent::new, 10, 0), new StrongholdPieceWeight(StrongholdTreasureCorridorComponent::new, 5, 0), new StrongholdPieceWeight(StrongholdAtriumComponent::new, 5, 2, 3), new StrongholdPieceWeight(StrongholdFoundryComponent::new, 5, 1, 4), new StrongholdPieceWeight(StrongholdTreasureRoomComponent::new, 5, 1, 4), new StrongholdPieceWeight(StrongholdBossRoomComponent::new, 15, 1, 4)};
    private List<StrongholdPieceWeight> pieceList;
    static int totalWeight = 0;
    private static StrongholdPieceWeight lastPieceMade;

    public void prepareStructurePieces() {
        this.pieceList = new ArrayList<StrongholdPieceWeight>();
        for (StrongholdPieceWeight piece : pieceWeightArray) {
            piece.instancesSpawned = 0;
            this.pieceList.add(piece);
        }
    }

    public void markBossRoomUsed() {
        this.pieceList.remove(this.pieceList.size() - 1);
    }

    private boolean hasMoreLimitedPieces() {
        boolean flag = false;
        totalWeight = 0;
        for (StrongholdPieceWeight piece : this.pieceList) {
            totalWeight += piece.pieceWeight;
            if (piece.instancesLimit <= 0 || piece.instancesSpawned >= piece.instancesLimit) continue;
            flag = true;
        }
        return flag;
    }

    public StructureTFStrongholdComponent getNextComponent(class_3443 parent, class_6130 list, class_5819 random, int index, class_2350 facing, int x, int y, int z) {
        if (!this.hasMoreLimitedPieces()) {
            return null;
        }
        block0: for (int i = 0; i < 5; ++i) {
            int counter = random.method_43048(totalWeight);
            for (StrongholdPieceWeight piece : this.pieceList) {
                if ((counter -= piece.pieceWeight) >= 0) continue;
                if (!piece.isDeepEnough(index) || piece == lastPieceMade) continue block0;
                StructureTFStrongholdComponent component = piece.factory.newInstance(index, facing, x, y, z);
                if (list.method_35461(component.method_14935()) != null) continue;
                ++piece.instancesSpawned;
                if (!piece.canSpawnMoreStructures()) {
                    this.pieceList.remove(piece);
                }
                lastPieceMade = piece;
                return component;
            }
        }
        StrongholdDeadEndComponent deadEnd = new StrongholdDeadEndComponent(index, facing, x, y, z);
        if (list.method_35461(deadEnd.method_14935()) == null) {
            return deadEnd;
        }
        return null;
    }
}

