/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.util.Codecs;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.components.layer.vanillalegacy.traits.CastleTransformer;

public record SeamLayer(class_5321<class_1959> partitioningBiome, List<class_5321<class_1959>> excludedBiomeNeighbors, List<Pair<class_5321<class_1959>, class_5321<class_1959>>> excludedBiomeIntersections) implements CastleTransformer
{
    @Override
    public class_5321<class_1959> apply(Context context, class_5321<class_1959> up, class_5321<class_1959> left, class_5321<class_1959> down, class_5321<class_1959> right, class_5321<class_1959> mid) {
        if (this.shouldPartition(mid, left) || this.shouldPartition(mid, right) || this.shouldPartition(mid, down) || this.shouldPartition(mid, up)) {
            return this.partitioningBiome;
        }
        return mid;
    }

    private boolean shouldPartition(class_5321<class_1959> biome1, class_5321<class_1959> biome2) {
        if (biome1 == biome2) {
            return false;
        }
        for (class_5321<class_1959> class_53212 : this.excludedBiomeNeighbors) {
            if (!SeamLayer.testEitherBiome(biome1, biome2, class_53212)) continue;
            return false;
        }
        for (Pair pair : this.excludedBiomeIntersections) {
            if (!SeamLayer.testEitherBiomeAND(biome1, biome2, (class_5321<class_1959>)((class_5321)pair.getFirst()), (class_5321<class_1959>)((class_5321)pair.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private static boolean testEitherBiomeAND(class_5321<class_1959> test1, class_5321<class_1959> test2, class_5321<class_1959> predicate1, class_5321<class_1959> predicate2) {
        return test1 == predicate1 && test2 == predicate2 || test2 == predicate1 && test1 == predicate2;
    }

    private static boolean testEitherBiome(class_5321<class_1959> test1, class_5321<class_1959> test2, class_5321<class_1959> predicate) {
        return test1 == predicate || test2 == predicate;
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final Codec<Factory> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)class_5321.method_39154((class_5321)class_7924.field_41236).fieldOf("dividing_biome").forGetter(Factory::partitioningBiome), (App)class_5321.method_39154((class_5321)class_7924.field_41236).listOf().fieldOf("excluded_neighbor_biomes").forGetter(Factory::excludedBiomeNeighbors), (App)class_5321.method_39154((class_5321)class_7924.field_41236).listOf().comapFlatMap(Codecs::arrayToPair, p -> List.of((class_5321)p.getFirst(), (class_5321)p.getSecond())).listOf().fieldOf("excluded_biome_intersections").forGetter(Factory::excludedBiomeIntersections), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("parent").forGetter(Factory::parent)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final class_5321<class_1959> partitioningBiome;
        private final List<class_5321<class_1959>> excludedBiomeNeighbors;
        private final List<Pair<class_5321<class_1959>, class_5321<class_1959>>> excludedBiomeIntersections;
        private final class_6880<BiomeLayerFactory> parent;
        private final SeamLayer instance;

        public Factory(long salt, class_5321<class_1959> partitioningBiome, List<class_5321<class_1959>> excludedBiomeNeighbors, List<Pair<class_5321<class_1959>, class_5321<class_1959>>> excludedBiomeIntersections, class_6880<BiomeLayerFactory> parent) {
            this.salt = salt;
            this.partitioningBiome = partitioningBiome;
            this.excludedBiomeNeighbors = excludedBiomeNeighbors;
            this.excludedBiomeIntersections = excludedBiomeIntersections;
            this.parent = parent;
            this.instance = new SeamLayer(partitioningBiome, excludedBiomeNeighbors, excludedBiomeIntersections);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return this.instance.run(contextFactory.apply(this.salt), ((BiomeLayerFactory)this.parent.comp_349()).build(contextFactory));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.SEAM.get();
        }

        public long salt() {
            return this.salt;
        }

        public class_5321<class_1959> partitioningBiome() {
            return this.partitioningBiome;
        }

        public List<class_5321<class_1959>> excludedBiomeNeighbors() {
            return this.excludedBiomeNeighbors;
        }

        public List<Pair<class_5321<class_1959>, class_5321<class_1959>>> excludedBiomeIntersections() {
            return this.excludedBiomeIntersections;
        }

        public class_6880<BiomeLayerFactory> parent() {
            return this.parent;
        }
    }
}

