/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import twilightforest.block.FallenLeavesBlock;
import twilightforest.init.TFBlocks;

public class FallenLeavesFeature
extends class_3031<class_3111> {
    private final class_2680 state = ((class_2248)TFBlocks.FALLEN_LEAVES.get()).method_9564();

    public FallenLeavesFeature(Codec<class_3111> config) {
        super(config);
    }

    public boolean method_13151(class_5821<class_3111> ctx) {
        class_5281 level = ctx.method_33652();
        class_2338 position = level.method_8598(class_2902.class_2903.field_13194, ctx.method_33655());
        class_5819 rand = ctx.method_33654();
        if (this.canPlace(position, level)) {
            if (!level.method_8316(position.method_10074()).method_15769()) {
                return this.generateFlatPileOnWater(level, position, rand);
            }
            int startHeight = rand.method_43048(6) + 1;
            level.method_8652(position, (class_2680)this.state.method_11657((class_2769)FallenLeavesBlock.LAYERS, (Comparable)Integer.valueOf(startHeight)), 18);
            for (int i = 0; i < startHeight; ++i) {
                this.generateCircleOfLeaves(level, position, rand, i, startHeight - i - 1);
                if (rand.method_43048(3) != 0) continue;
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean generateFlatPileOnWater(class_5281 level, class_2338 pos, class_5819 random) {
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                class_2338 finalPos;
                if (random.method_43048(3) != 0) continue;
                boolean flag = false;
                int y = 2;
                do {
                    if (!this.canPlace(pos.method_10069(x, y, z), level)) continue;
                    flag = true;
                    break;
                } while (--y >= -2);
                if (!flag || !this.state.method_26184((class_4538)level, finalPos = pos.method_10069(x, y, z))) continue;
                level.method_8652(finalPos, this.state, 18);
            }
        }
        return true;
    }

    private void generateCircleOfLeaves(class_5281 level, class_2338 origin, class_5819 random, int radius, int height) {
        for (int i1 = origin.method_10263() - radius; i1 <= origin.method_10263() + radius; ++i1) {
            for (int j1 = origin.method_10260() - radius; j1 <= origin.method_10260() + radius; ++j1) {
                int l1;
                int k1 = i1 - origin.method_10263();
                if (k1 * k1 + (l1 = j1 - origin.method_10260()) * l1 > radius * radius) continue;
                class_2338 newPos = new class_2338(i1, origin.method_10264(), j1);
                int trueHeight = height - random.method_43048(3);
                if (trueHeight <= 0) continue;
                this.checkAndGenerateLeafPile(level, newPos, trueHeight);
            }
        }
    }

    private void checkAndGenerateLeafPile(class_5281 level, class_2338 pos, int pileLayer) {
        boolean flag = false;
        int y = 0;
        do {
            if (!this.canPlace(pos.method_10069(0, y, 0), level)) continue;
            flag = true;
            break;
        } while (--y >= -2);
        if (!flag) {
            return;
        }
        class_2338 finalPos = pos.method_10069(0, y, 0);
        if (this.state.method_26204().method_9558(this.state, (class_4538)level, finalPos)) {
            level.method_8652(finalPos, (class_2680)this.state.method_11657((class_2769)FallenLeavesBlock.LAYERS, (Comparable)Integer.valueOf(pileLayer)), 18);
        }
    }

    private boolean canPlace(class_2338 pos, class_5281 level) {
        class_2680 state = level.method_8320(pos.method_10074());
        return !(level.method_8320(pos).method_27852(this.state.method_26204()) || !level.method_22347(pos) && !level.method_8320(pos).method_27852((class_2248)TFBlocks.MAYAPPLE.get()) && !level.method_8320(pos).method_45474() || !state.method_26164(class_3481.field_29822) && !level.method_8316(pos.method_10074()).method_39360((class_3611)class_3612.field_15910));
    }
}

