/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import io.github.fabricators_of_create.porting_lib.block.HarvestableBlock;
import io.github.fabricators_of_create.porting_lib.item.ContinueUsingItem;
import io.github.fabricators_of_create.porting_lib.item.ReequipAnimationItem;
import io.github.fabricators_of_create.porting_lib.item.UsingTickItem;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3956;
import twilightforest.init.TFRecipes;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.util.WorldUtil;

public class CrumbleHornItem
extends class_1792
implements ReequipAnimationItem,
ContinueUsingItem,
UsingTickItem {
    private static final int CHANCE_HARVEST = 20;
    private static final int CHANCE_CRUMBLE = 5;

    public CrumbleHornItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        player.method_6019(hand);
        player.method_5783((class_3414)TFSounds.QUEST_RAM_AMBIENT.get(), 1.0f, 0.8f);
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    public void method_7852(class_1937 level, class_1309 living, class_1799 stack, int count) {
        if (count > 10 && count % 5 == 0 && !living.method_37908().method_8608()) {
            int crumbled = this.doCrumble(living.method_37908(), living);
            if (crumbled > 0) {
                stack.method_7956(crumbled, living, user -> user.method_20236(living.method_6058()));
            }
            living.method_37908().method_43128(null, living.method_23317(), living.method_23318(), living.method_23321(), (class_3414)TFSounds.QUEST_RAM_AMBIENT.get(), living.method_5634(), 1.0f, 0.8f);
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public boolean canContinueUsing(class_1799 oldStack, class_1799 newStack) {
        return oldStack.method_7909() == newStack.method_7909();
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return slotChanged || newStack.method_7909() != oldStack.method_7909();
    }

    private int doCrumble(class_1937 world, class_1309 living) {
        double range = 3.0;
        double radius = 2.0;
        class_243 srcVec = new class_243(living.method_23317(), living.method_23318() + (double)living.method_5751(), living.method_23321());
        class_243 lookVec = living.method_5720().method_1021(3.0);
        class_243 destVec = srcVec.method_1019(lookVec);
        class_238 crumbleBox = new class_238(destVec.method_10216() - 2.0, destVec.method_10214() - 2.0, destVec.method_10215() - 2.0, destVec.method_10216() + 2.0, destVec.method_10214() + 2.0, destVec.method_10215() + 2.0);
        return this.crumbleBlocksInAABB(world, living, crumbleBox);
    }

    private int crumbleBlocksInAABB(class_1937 world, class_1309 living, class_238 box) {
        int crumbled = 0;
        for (class_2338 pos : WorldUtil.getAllInBB(box)) {
            class_1657 player;
            if (!this.crumbleBlock(world, living, pos)) continue;
            ++crumbled;
            if (!(living instanceof class_1657) || !((player = (class_1657)living) instanceof class_3222)) continue;
            player.method_7281((class_2960)TFStats.BLOCKS_CRUMBLED.get());
        }
        return crumbled;
    }

    private boolean crumbleBlock(class_1937 world, class_1309 living, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        AtomicBoolean flag = new AtomicBoolean(false);
        if (state.method_26215()) {
            return false;
        }
        if (living instanceof class_1657 && !((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(world, (class_1657)living, pos, state, null)) {
            return false;
        }
        if (world instanceof class_3218) {
            class_3218 level = (class_3218)world;
            level.method_8433().method_30027((class_3956)TFRecipes.CRUMBLE_RECIPE.get()).forEach(recipe -> {
                if (flag.get()) {
                    return;
                }
                if (recipe.result().method_27852(class_2246.field_10124)) {
                    if (recipe.input().method_27852(block) && world.method_8409().method_43048(20) == 0 && !flag.get()) {
                        if (living instanceof class_1657) {
                            HarvestableBlock harvestableBlock;
                            if (block instanceof HarvestableBlock && (harvestableBlock = (HarvestableBlock)block).canHarvestBlock(state, (class_1922)world, pos, (class_1657)living) || ((class_1657)living).method_7305(state)) {
                                world.method_8650(pos, false);
                                block.method_9556(world, (class_1657)living, pos, state, world.method_8321(pos), class_1799.field_8037);
                                world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                                this.postTrigger(living);
                                flag.set(true);
                            }
                        } else if (world.method_8450().method_8355(class_1928.field_19388)) {
                            world.method_22352(pos, true);
                            this.postTrigger(living);
                            flag.set(true);
                        }
                    }
                } else if (recipe.input().method_27852(block) && world.method_8409().method_43048(5) == 0 && !flag.get()) {
                    world.method_8652(pos, recipe.result().method_26204().method_34725(state), 3);
                    world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
                    this.postTrigger(living);
                    flag.set(true);
                }
            });
        }
        return flag.get();
    }

    private void postTrigger(class_1309 living) {
        if (living instanceof class_3222) {
            class_3222 player = (class_3222)living;
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
    }
}

