/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import io.github.fabricators_of_create.porting_lib.item.ShieldBlockItem;
import io.github.fabricators_of_create.porting_lib.util.TierSortingRegistry;
import java.util.UUID;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1839;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.ChainBlock;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class ChainBlockItem
extends class_1792
implements CustomEnchantingBehaviorItem,
ShieldBlockItem,
FabricItem {
    private static final String THROWN_UUID_KEY = "chainEntity";

    public ChainBlockItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        return this.canApplyEnchantment(class_1890.method_8222((class_1799)stack).keySet().toArray(new class_1887[0])) || super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return this.canApplyEnchantment(enchantment) || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private boolean canApplyEnchantment(class_1887 ... enchantments) {
        for (class_1887 enchantment : enchantments) {
            if (enchantment.field_9083 != class_1886.field_9069 && !enchantment.method_8192(class_1802.field_8475.method_7854())) continue;
            return true;
        }
        return false;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 holder, int slot, boolean isSelected) {
        if (!level.method_8608() && ChainBlockItem.getThrownUuid(stack) != null && this.getThrownEntity(level, stack) == null) {
            stack.method_7969().method_10551(THROWN_UUID_KEY);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (ChainBlockItem.getThrownUuid(stack) != null) {
            return new class_1271(class_1269.field_5811, (Object)stack);
        }
        player.method_5783((class_3414)TFSounds.BLOCK_AND_CHAIN_FIRED.get(), 0.5f, 1.0f / (level.method_8409().method_43057() * 0.4f + 1.2f));
        if (!level.method_8608()) {
            ChainBlock launchedBlock = new ChainBlock((class_1299<? extends ChainBlock>)((class_1299)TFEntities.CHAIN_BLOCK.get()), level, (class_1309)player, hand, stack);
            level.method_8649((class_1297)launchedBlock);
            this.setThrownEntity(stack, launchedBlock);
        }
        player.method_6019(hand);
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    @Nullable
    public static UUID getThrownUuid(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_25928(THROWN_UUID_KEY)) {
            return stack.method_7969().method_25926(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private ChainBlock getThrownEntity(class_1937 level, class_1799 stack) {
        if (level instanceof class_3218) {
            class_1297 e;
            class_3218 server = (class_3218)level;
            UUID id = ChainBlockItem.getThrownUuid(stack);
            if (id != null && (e = server.method_14190(id)) instanceof ChainBlock) {
                return (ChainBlock)e;
            }
        }
        return null;
    }

    private void setThrownEntity(class_1799 stack, ChainBlock cube) {
        stack.method_7948().method_25927(THROWN_UUID_KEY, cube.method_5667());
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    public boolean method_7878(class_1799 stack, class_1799 repairItem) {
        return repairItem.method_31573(ItemTagGenerator.KNIGHTMETAL_INGOTS);
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        if (stack.method_7969() == null || !stack.method_7969().method_10545(THROWN_UUID_KEY)) {
            return false;
        }
        if (class_1890.method_8225((class_1887)((class_1887)TFEnchantments.DESTRUCTION.get()), (class_1799)stack) > 0 && (state.method_26164(class_3481.field_33715) || state.method_26164(class_3481.field_33714) || state.method_26164(class_3481.field_33716) || state.method_26164(class_3481.field_33713))) {
            return TierSortingRegistry.isCorrectTierForDrops((class_1832)this.getHarvestLevel(stack), (class_2680)state);
        }
        return false;
    }

    public class_1832 getHarvestLevel(class_1799 stack) {
        int enchantLevel = class_1890.method_8225((class_1887)((class_1887)TFEnchantments.DESTRUCTION.get()), (class_1799)stack);
        if (enchantLevel == 2) {
            return class_1834.field_8927;
        }
        if (enchantLevel >= 3) {
            return class_1834.field_8923;
        }
        return class_1834.field_8922;
    }
}

