/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.templates.model;

import io.github.cottonmc.templates.TemplatesClient;
import io.github.cottonmc.templates.model.TemplateAppearance;
import io.github.cottonmc.templates.util.TattletaleRandom;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class TemplateAppearanceManager {
    @ApiStatus.Internal
    public static final class_4730 DEFAULT_SPRITE_ID = new class_4730(class_1723.field_21668, new class_2960("minecraft:block/scaffolding_top"));
    private static final class_4730 BARRIER_SPRITE_ID = new class_4730(class_1723.field_21668, new class_2960("minecraft:item/barrier"));
    private final TemplateAppearance defaultAppearance;
    private final TemplateAppearance barrierItemAppearance;
    private final ConcurrentHashMap<class_2680, TemplateAppearance> appearanceCache = new ConcurrentHashMap();
    private final AtomicInteger serialNumber = new AtomicInteger(0);
    private final EnumMap<BlendMode, RenderMaterial> materialsWithAo = new EnumMap(BlendMode.class);
    private final EnumMap<BlendMode, RenderMaterial> materialsWithoutAo = new EnumMap(BlendMode.class);

    public TemplateAppearanceManager(Function<class_4730, class_1058> spriteLookup) {
        MaterialFinder finder = TemplatesClient.getFabricRenderer().materialFinder();
        for (BlendMode blend : BlendMode.values()) {
            finder.clear().disableDiffuse(false).blendMode(blend);
            this.materialsWithoutAo.put(blend, finder.ambientOcclusion(TriState.FALSE).find());
            this.materialsWithAo.put(blend, finder.ambientOcclusion(TriState.DEFAULT).find());
        }
        class_1058 defaultSprite = spriteLookup.apply(DEFAULT_SPRITE_ID);
        if (defaultSprite == null) {
            throw new IllegalStateException("Couldn't locate " + DEFAULT_SPRITE_ID + " !");
        }
        this.defaultAppearance = new SingleSpriteAppearance(defaultSprite, this.materialsWithoutAo.get(BlendMode.CUTOUT), this.serialNumber.getAndIncrement());
        class_1058 barrier = spriteLookup.apply(BARRIER_SPRITE_ID);
        if (barrier == null) {
            barrier = defaultSprite;
        }
        this.barrierItemAppearance = new SingleSpriteAppearance(barrier, this.materialsWithoutAo.get(BlendMode.CUTOUT), this.serialNumber.getAndIncrement());
    }

    public TemplateAppearance getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public TemplateAppearance getAppearance(class_2680 state) {
        return this.appearanceCache.computeIfAbsent(state, this::computeAppearance);
    }

    public RenderMaterial getCachedMaterial(class_2680 state, boolean ao) {
        EnumMap<BlendMode, RenderMaterial> m = ao ? this.materialsWithAo : this.materialsWithoutAo;
        return (RenderMaterial)m.get(BlendMode.fromRenderLayer((class_1921)class_4696.method_23679((class_2680)state)));
    }

    private TemplateAppearance computeAppearance(class_2680 state) {
        if (state.method_26204() == class_2246.field_10499) {
            return this.barrierItemAppearance;
        }
        TattletaleRandom rand = new TattletaleRandom(class_5819.method_43047());
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        QuadEmitter emitter = TemplatesClient.getFabricRenderer().meshBuilder().getEmitter();
        RenderMaterial defaultMat = TemplatesClient.getFabricRenderer().materialFinder().clear().find();
        class_1058[] sprites = new class_1058[7];
        int[] bakeFlags = new int[6];
        byte hasColorMask = 0;
        for (class_2350 dir : class_2350.values()) {
            class_1058 sprite;
            class_777 arbitraryQuad;
            List sideQuads = model.method_4707(null, dir, (class_5819)rand);
            if (sideQuads.isEmpty() || (arbitraryQuad = (class_777)sideQuads.get(0)) == null) continue;
            if (arbitraryQuad.method_3360()) {
                hasColorMask = (byte)(hasColorMask | 1 << dir.ordinal());
            }
            if ((sprite = arbitraryQuad.method_35788()) == null) continue;
            sprites[dir.ordinal()] = sprite;
            emitter.fromVanilla(arbitraryQuad, defaultMat, dir);
            int lowHighSignature = 0;
            for (int i = 0; i < 4; ++i) {
                float diffMaxU;
                float diffMinU = Math.abs(emitter.u(i) - sprite.method_4594());
                boolean minU = diffMinU < (diffMaxU = Math.abs(emitter.u(i) - sprite.method_4577()));
                float diffMinV = Math.abs(emitter.v(i) - sprite.method_4593());
                float diffMaxV = Math.abs(emitter.v(i) - sprite.method_4575());
                boolean minV = diffMinV < diffMaxV;
                lowHighSignature <<= 2;
                lowHighSignature |= (minU ? 2 : 0) | (minV ? 1 : 0);
            }
            if (lowHighSignature == 225) {
                bakeFlags[dir.ordinal()] = 0;
                continue;
            }
            if (lowHighSignature == 135) {
                bakeFlags[dir.ordinal()] = 1;
                continue;
            }
            if (lowHighSignature == 30) {
                bakeFlags[dir.ordinal()] = 2;
                continue;
            }
            if (lowHighSignature != 120) continue;
            bakeFlags[dir.ordinal()] = 3;
        }
        sprites[6] = model.method_4711();
        for (int i = 0; i < sprites.length; ++i) {
            if (sprites[i] != null) continue;
            sprites[i] = this.defaultAppearance.getParticleSprite();
        }
        if (rand.wasUsed) {
            // empty if block
        }
        return new ComputedApperance(sprites, bakeFlags, hasColorMask, this.getCachedMaterial(state, true), this.getCachedMaterial(state, false), this.serialNumber.getAndIncrement());
    }

    private static final class SingleSpriteAppearance
    implements TemplateAppearance {
        @NotNull
        private final class_1058 defaultSprite;
        private final RenderMaterial mat;
        private final int id;

        private SingleSpriteAppearance(@NotNull class_1058 defaultSprite, RenderMaterial mat, int id) {
            this.defaultSprite = defaultSprite;
            this.mat = mat;
            this.id = id;
        }

        @Override
        @NotNull
        public class_1058 getParticleSprite() {
            return this.defaultSprite;
        }

        @Override
        @NotNull
        public RenderMaterial getRenderMaterial(boolean ao) {
            return this.mat;
        }

        @Override
        @NotNull
        public class_1058 getSprite(class_2350 dir) {
            return this.defaultSprite;
        }

        @Override
        public int getBakeFlags(class_2350 dir) {
            return 0;
        }

        @Override
        public boolean hasColor(class_2350 dir) {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleSpriteAppearance that = (SingleSpriteAppearance)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "SingleSpriteAppearance[defaultSprite=%s, mat=%s, id=%d]".formatted(this.defaultSprite, this.mat, this.id);
        }
    }

    private static final class ComputedApperance
    implements TemplateAppearance {
        private final class_1058 @NotNull [] sprites;
        private final int @NotNull [] bakeFlags;
        private final byte hasColorMask;
        private final int id;
        private final RenderMaterial matWithAo;
        private final RenderMaterial matWithoutAo;

        private ComputedApperance(@NotNull @NotNull class_1058 @NotNull [] sprites, int @NotNull [] bakeFlags, byte hasColorMask, RenderMaterial withAo, RenderMaterial withoutAo, int id) {
            this.sprites = sprites;
            this.bakeFlags = bakeFlags;
            this.hasColorMask = hasColorMask;
            this.id = id;
            this.matWithAo = withAo;
            this.matWithoutAo = withoutAo;
        }

        @Override
        @NotNull
        public class_1058 getParticleSprite() {
            return this.sprites[6];
        }

        @Override
        @NotNull
        public RenderMaterial getRenderMaterial(boolean ao) {
            return ao ? this.matWithAo : this.matWithoutAo;
        }

        @Override
        @NotNull
        public class_1058 getSprite(class_2350 dir) {
            return this.sprites[dir.ordinal()];
        }

        @Override
        public int getBakeFlags(class_2350 dir) {
            return this.bakeFlags[dir.ordinal()];
        }

        @Override
        public boolean hasColor(class_2350 dir) {
            return (this.hasColorMask & 1 << dir.ordinal()) != 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComputedApperance that = (ComputedApperance)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "ComputedApperance{sprites=%s, bakeFlags=%s, hasColorMask=%s, matWithoutAo=%s, matWithAo=%s, id=%d}".formatted(Arrays.toString(this.sprites), Arrays.toString(this.bakeFlags), this.hasColorMask, this.matWithoutAo, this.matWithAo, this.id);
        }
    }
}

