/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.DimensionSupport;
import folk.sisby.surveyor.util.RegistryPalette;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_7924;

public class RegionSummary {
    public static final int REGION_POWER = 5;
    public static final int REGION_SIZE = 32;
    public static final int BITSET_SIZE = 1024;
    public static final String KEY_BIOMES = "biomes";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_BIOME_WATER = "biomeWater";
    public static final String KEY_BIOME_FOLIAGE = "biomeFoliage";
    public static final String KEY_BIOME_GRASS = "biomeGrass";
    public static final String KEY_BLOCK_COLORS = "blockColors";
    public static final String KEY_CHUNKS = "chunks";
    protected final RegistryPalette<class_1959> biomePalette;
    protected final RegistryPalette<class_2248> blockPalette;
    protected final ChunkSummary[][] chunks = new ChunkSummary[32][32];
    protected boolean dirty = false;

    public RegionSummary(class_5455 manager) {
        this.biomePalette = new RegistryPalette(manager.method_30530(class_7924.field_41236));
        this.blockPalette = new RegistryPalette(manager.method_30530(class_7924.field_41254));
    }

    public static <T, O> List<O> mapIterable(Iterable<T> palette, Function<T, O> mapper) {
        ArrayList<O> list = new ArrayList<O>();
        for (T value : palette) {
            list.add(mapper.apply(value));
        }
        return list;
    }

    public static int regionToChunk(int xz) {
        return xz << 5;
    }

    public static int chunkToRegion(int xz) {
        return xz >> 5;
    }

    public static int regionRelative(int xz) {
        return xz & 0x1F;
    }

    public static int bitForXZ(int x, int z) {
        return (x << 5) + z;
    }

    public static int bitForChunk(class_1923 pos) {
        return RegionSummary.bitForXZ(RegionSummary.regionRelative(pos.field_9181), RegionSummary.regionRelative(pos.field_9180));
    }

    public static int xForBit(int i) {
        return i >> 5;
    }

    public static int zForBit(int i) {
        return i & 0x1F;
    }

    public static class_1923 chunkForBit(class_1923 rPos, int i) {
        return new class_1923(RegionSummary.regionToChunk(rPos.field_9181) + RegionSummary.xForBit(i), RegionSummary.regionToChunk(rPos.field_9180) + RegionSummary.zForBit(i));
    }

    public static RegionSummary readNbt(class_2487 nbt, class_5455 manager, class_1923 pos) {
        RegionSummary summary = new RegionSummary(manager);
        class_2378 biomeRegistry = manager.method_30530(class_7924.field_41236);
        class_2378 blockRegistry = manager.method_30530(class_7924.field_41254);
        class_2499 biomeList = nbt.method_10554(KEY_BIOMES, 8);
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap(biomeList.size());
        for (int i = 0; i < biomeList.size(); ++i) {
            class_2960 biomeId = new class_2960(biomeList.method_10534(i).method_10714());
            class_1959 biome = (class_1959)biomeRegistry.method_10223(biomeId);
            class_1959 newBiome = biome == null ? (class_1959)biomeRegistry.method_29107(class_1972.field_9473) : biome;
            int newIndex = summary.biomePalette.findOrAdd(newBiome);
            if (biome != null && newIndex == i) continue;
            Surveyor.LOGGER.warn("[Surveyor] Remapping biome palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, biomeId, i, biomeRegistry.method_10221((Object)newBiome), newIndex});
            biomeRemap.put(i, newIndex);
            summary.dirty();
        }
        class_2499 blockList = nbt.method_10554(KEY_BLOCKS, 8);
        Int2IntArrayMap blockRemap = new Int2IntArrayMap(blockList.size());
        for (int i = 0; i < blockList.size(); ++i) {
            class_2960 blockId = new class_2960(blockList.method_10534(i).method_10714());
            class_2248 block = (class_2248)blockRegistry.method_10223(blockId);
            class_2248 newBlock = block == null ? class_2246.field_10124 : block;
            int newIndex = summary.blockPalette.findOrAdd(newBlock);
            if (block != null && newIndex == i) continue;
            Surveyor.LOGGER.warn("[Surveyor] Remapping block palette in region {}: {} (#{}) is now {} (#{})", new Object[]{pos, blockList.method_10534(i).method_10714(), i, blockRegistry.method_10221((Object)newBlock), newIndex});
            blockRemap.put(i, newIndex);
            summary.dirty();
        }
        class_2487 chunksCompound = nbt.method_10562(KEY_CHUNKS);
        for (String posKey : chunksCompound.method_10541()) {
            int x = RegionSummary.regionRelative(Integer.parseInt(posKey.split(",")[0]));
            int z = RegionSummary.regionRelative(Integer.parseInt(posKey.split(",")[1]));
            summary.chunks[x][z] = new ChunkSummary(chunksCompound.method_10562(posKey));
            if (biomeRemap.isEmpty() && blockRemap.isEmpty()) continue;
            summary.chunks[x][z].remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
        }
        return summary;
    }

    public boolean contains(class_1923 pos) {
        return this.chunks[RegionSummary.regionRelative(pos.field_9181)][RegionSummary.regionRelative(pos.field_9180)] != null;
    }

    public ChunkSummary get(class_1923 pos) {
        return this.chunks[RegionSummary.regionRelative(pos.field_9181)][RegionSummary.regionRelative(pos.field_9180)];
    }

    public BitSet bitSet() {
        BitSet bitSet = new BitSet(1024);
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (this.chunks[x][z] == null) continue;
                bitSet.set(RegionSummary.bitForXZ(x, z));
            }
        }
        return bitSet;
    }

    public void putChunk(class_1937 world, class_2818 chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        if (world.method_31605() == 0) {
            return;
        }
        this.chunks[RegionSummary.regionRelative((int)chunk.method_12004().field_9181)][RegionSummary.regionRelative((int)chunk.method_12004().field_9180)] = new ChunkSummary(world, chunk, DimensionSupport.getSummaryLayers(world), this.biomePalette, this.blockPalette, !(world instanceof class_3218));
        this.dirty();
    }

    public class_2487 writeNbt(class_5455 manager, class_2487 nbt, class_1923 regionPos) {
        class_2378 biomeRegistry = manager.method_30530(class_7924.field_41236);
        class_2378 blockRegistry = manager.method_30530(class_7924.field_41254);
        nbt.method_10566(KEY_BIOMES, (class_2520)new class_2499(RegionSummary.mapIterable(this.biomePalette.view(), b -> class_2519.method_23256((String)biomeRegistry.method_10221(b).toString())), 8));
        nbt.method_10566(KEY_BLOCKS, (class_2520)new class_2499(RegionSummary.mapIterable(this.blockPalette.view(), b -> class_2519.method_23256((String)blockRegistry.method_10221(b).toString())), 8));
        nbt.method_10572(KEY_BIOME_WATER, RegionSummary.mapIterable(this.biomePalette.view(), class_1959::method_8687));
        nbt.method_10572(KEY_BIOME_FOLIAGE, RegionSummary.mapIterable(this.biomePalette.view(), class_1959::method_8698));
        nbt.method_10572(KEY_BIOME_GRASS, RegionSummary.mapIterable(this.biomePalette.view(), b -> b.method_8711(0.0, 0.0)));
        nbt.method_10572(KEY_BLOCK_COLORS, RegionSummary.mapIterable(this.blockPalette.view(), b -> b.method_26403().field_16011));
        class_2487 chunksCompound = new class_2487();
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (this.chunks[x][z] == null) continue;
                chunksCompound.method_10566("%s,%s".formatted((regionPos.field_9181 << 5) + x, (regionPos.field_9180 << 5) + z), (class_2520)this.chunks[x][z].writeNbt(new class_2487()));
            }
        }
        nbt.method_10566(KEY_CHUNKS, (class_2520)chunksCompound);
        return nbt;
    }

    public BitSet readUpdatePacket(class_5455 manager, S2CUpdateRegionPacket packet) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return new BitSet();
        }
        Int2IntArrayMap biomeRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.biomePalette().size(); ++i) {
            biomeRemap.put(i, this.biomePalette.findOrAdd(packet.biomePalette().get(i)));
        }
        Int2IntArrayMap blockRemap = new Int2IntArrayMap();
        for (int i = 0; i < packet.blockPalette().size(); ++i) {
            blockRemap.put(i, this.blockPalette.findOrAdd(packet.blockPalette().get(i)));
        }
        int[] indices = packet.set().stream().toArray();
        for (int i = 0; i < packet.chunks().size(); ++i) {
            ChunkSummary summary = packet.chunks().get(i);
            summary.remap((Map<Integer, Integer>)biomeRemap, (Map<Integer, Integer>)blockRemap);
            this.chunks[RegionSummary.xForBit((int)indices[i])][RegionSummary.zForBit((int)indices[i])] = summary;
        }
        this.dirty();
        return packet.set();
    }

    public S2CUpdateRegionPacket createUpdatePacket(boolean shared, class_1923 rPos, BitSet set) {
        return new S2CUpdateRegionPacket(shared, rPos, RegionSummary.mapIterable(this.biomePalette, i -> i), RegionSummary.mapIterable(this.blockPalette, i -> i), set, set.stream().mapToObj(i -> this.chunks[RegionSummary.xForBit(i)][RegionSummary.zForBit(i)]).toList());
    }

    public RegistryPalette.ValueView getBiomePalette() {
        return this.biomePalette.view();
    }

    public RegistryPalette.ValueView getBlockPalette() {
        return this.blockPalette.view();
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.terrain != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }
}

