/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.MapUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class SurveyorClientEvents {
    private static final Map<class_2960, WorldLoad> worldLoad = new HashMap<class_2960, WorldLoad>();
    private static final Map<class_2960, TerrainUpdated> terrainUpdated = new HashMap<class_2960, TerrainUpdated>();
    private static final Map<class_2960, StructuresAdded> structuresAdded = new HashMap<class_2960, StructuresAdded>();
    private static final Map<class_2960, LandmarksAdded> landmarksAdded = new HashMap<class_2960, LandmarksAdded>();
    private static final Map<class_2960, LandmarksRemoved> landmarksRemoved = new HashMap<class_2960, LandmarksRemoved>();
    public static boolean INITIALIZING_WORLD = false;

    public static class Register {
        public static void worldLoad(class_2960 id, WorldLoad handler) {
            worldLoad.put(id, handler);
        }

        public static void terrainUpdated(class_2960 id, TerrainUpdated handler) {
            terrainUpdated.put(id, handler);
        }

        public static void structuresAdded(class_2960 id, StructuresAdded handler) {
            structuresAdded.put(id, handler);
        }

        public static void landmarksAdded(class_2960 id, LandmarksAdded handler) {
            landmarksAdded.put(id, handler);
        }

        public static void landmarksRemoved(class_2960 id, LandmarksRemoved handler) {
            landmarksRemoved.put(id, handler);
        }
    }

    public static class Invoke {
        public static void worldLoad(class_638 world, class_746 player) {
            if (worldLoad.isEmpty()) {
                return;
            }
            SurveyorExploration exploration = SurveyorClient.getExploration();
            WorldSummary summary = WorldSummary.of((class_1937)world);
            Map<Object, Object> terrain = summary.terrain() == null ? new HashMap() : summary.terrain().bitSet(exploration);
            Multimap<class_5321<class_3195>, class_1923> structures = summary.structures() == null ? HashMultimap.create() : summary.structures().keySet(exploration);
            Multimap<LandmarkType<?>, class_2338> landmarks = summary.landmarks() == null ? HashMultimap.create() : summary.landmarks().keySet(exploration);
            worldLoad.forEach((id, handler) -> handler.onWorldLoad(world, summary, player, terrain, structures, landmarks));
        }

        public static void terrainUpdated(class_1937 world, Collection<class_1923> chunks) {
            if (terrainUpdated.isEmpty() || chunks.isEmpty()) {
                return;
            }
            WorldTerrainSummary summary = WorldSummary.of(world).terrain();
            terrainUpdated.forEach((id, handler) -> handler.onTerrainUpdated(world, summary, chunks));
        }

        public static void terrainUpdated(class_1937 world, class_1923 pos) {
            Invoke.terrainUpdated(world, List.of(pos));
        }

        public static void structuresAdded(class_1937 world, Multimap<class_5321<class_3195>, class_1923> structures) {
            if (structuresAdded.isEmpty() || structures.isEmpty()) {
                return;
            }
            WorldStructureSummary summary = WorldSummary.of(world).structures();
            structuresAdded.forEach((id, handler) -> handler.onStructuresAdded(world, summary, structures));
        }

        public static void structuresAdded(class_1937 world, class_5321<class_3195> key, class_1923 pos) {
            Invoke.structuresAdded(world, MapUtil.asMultiMap(Map.of(key, List.of(pos))));
        }

        public static void landmarksAdded(class_1937 world, Multimap<LandmarkType<?>, class_2338> landmarks) {
            if (landmarksAdded.isEmpty() || landmarks.isEmpty()) {
                return;
            }
            WorldLandmarks summary = WorldSummary.of(world).landmarks();
            landmarksAdded.forEach((id, handler) -> handler.onLandmarksAdded(world, summary, landmarks));
        }

        public static void landmarksRemoved(class_1937 world, Multimap<LandmarkType<?>, class_2338> landmarks) {
            if (landmarksRemoved.isEmpty() || landmarks.isEmpty()) {
                return;
            }
            WorldLandmarks summary = WorldSummary.of(world).landmarks();
            landmarksRemoved.forEach((id, handler) -> handler.onLandmarksRemoved(world, summary, landmarks));
        }
    }

    @FunctionalInterface
    public static interface LandmarksRemoved {
        public void onLandmarksRemoved(class_1937 var1, WorldLandmarks var2, Multimap<LandmarkType<?>, class_2338> var3);
    }

    @FunctionalInterface
    public static interface LandmarksAdded {
        public void onLandmarksAdded(class_1937 var1, WorldLandmarks var2, Multimap<LandmarkType<?>, class_2338> var3);
    }

    @FunctionalInterface
    public static interface StructuresAdded {
        public void onStructuresAdded(class_1937 var1, WorldStructureSummary var2, Multimap<class_5321<class_3195>, class_1923> var3);
    }

    @FunctionalInterface
    public static interface TerrainUpdated {
        public void onTerrainUpdated(class_1937 var1, WorldTerrainSummary var2, Collection<class_1923> var3);
    }

    @FunctionalInterface
    public static interface WorldLoad {
        public void onWorldLoad(class_638 var1, WorldSummary var2, class_746 var3, Map<class_1923, BitSet> var4, Multimap<class_5321<class_3195>, class_1923> var5, Multimap<LandmarkType<?>, class_2338> var6);
    }
}

