/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2280;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class SurveyorClientCommands {
    private static void informGroup(Map<UUID, PlayerSummary> group, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)class_2561.method_43470((String)"You're sharing your map with ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(group.size() - 1)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).method_27692(class_124.field_1065)));
        feedback.accept((class_2561)TextUtil.highlightStrings(group.entrySet().stream().filter(e -> !((UUID)e.getKey()).equals(SurveyorClient.getClientUuid())).map(e -> ((PlayerSummary)e.getValue()).username()).toList(), s -> class_124.field_1068).method_27692(class_124.field_1065));
    }

    private static int info(WorldSummary summary, SurveyorExploration exploration, SurveyorExploration groupExploration, Consumer<class_2561> feedback) {
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        Map<UUID, PlayerSummary> group = SurveyorClient.getFriends();
        WorldLandmarks worldLandmarks = summary.landmarks();
        if (worldLandmarks != null) {
            worldLandmarks.asMap(exploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? landmarks : waypoints).add(landmark)));
            worldLandmarks.asMap(groupExploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? groupLandmarks : groupWaypoints).add(landmark)));
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---Map Exploration Summary---").method_27692(class_124.field_1080)));
        feedback.accept((class_2561)class_2561.method_43470((String)"You've explored ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(exploration.chunkCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" total chunks!").method_27692(class_124.field_1075)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupExploration.chunkCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1075)))));
        feedback.accept((class_2561)class_2561.method_43470((String)"You've explored ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(exploration.structureCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" structures!").method_27692(class_124.field_1076)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupExploration.structureCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1076)))));
        feedback.accept((class_2561)class_2561.method_43470((String)"You've explored ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(landmarks.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" landmarks here!").method_27692(class_124.field_1060)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupLandmarks.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1060)))));
        feedback.accept((class_2561)class_2561.method_43470((String)"...and created ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(waypoints.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" waypoints!").method_27692(class_124.field_1060)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupWaypoints.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1060)))));
        if (group.size() > 1) {
            SurveyorClientCommands.informGroup(SurveyorClient.getFriends(), feedback);
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"-------End Summary-------").method_27692(class_124.field_1080)));
        return 1;
    }

    private static int landmarkInfo(WorldSummary summary, SurveyorExploration exploration, SurveyorExploration groupExploration, Consumer<class_2561> feedback) {
        Collection<PlayerSummary> group = SurveyorClient.getFriends().values();
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---World Landmark Types---").method_27692(class_124.field_1080)));
        HashSet<LandmarkType> waypoints = new HashSet<LandmarkType>();
        HashMultimap keys = HashMultimap.create();
        HashMultimap groupKeys = HashMultimap.create();
        HashMultimap personalKeys = HashMultimap.create();
        WorldLandmarks worldLandmarks = summary.landmarks();
        if (worldLandmarks != null) {
            waypoints.addAll(worldLandmarks.asMap(null).values().stream().flatMap(e -> e.values().stream().filter(l -> l.owner() != null)).map(Landmark::type).toList());
            keys.putAll(worldLandmarks.keySet(null));
            groupKeys.putAll(worldLandmarks.keySet(groupExploration));
            personalKeys.putAll(worldLandmarks.keySet(exploration));
        }
        keys.asMap().forEach((arg_0, arg_1) -> SurveyorClientCommands.lambda$landmarkInfo$9(feedback, waypoints, (Multimap)personalKeys, group, (Multimap)groupKeys, (Multimap)keys, arg_0, arg_1));
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"-------End Landmarks-------").method_27692(class_124.field_1080)));
        return 1;
    }

    private static int getLandmarks(WorldSummary summary, Consumer<class_2561> feedback, class_2960 type) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        Map<class_2338, ?> landmarks = summary.landmarks().asMap(Landmarks.getType(type), null);
        if (landmarks.isEmpty()) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"There are no landmarks of that type in this world!").method_27692(class_124.field_1054)));
            return 0;
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---World %s Landmarks---".formatted(type)).method_27692(class_124.field_1080)));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)landmark.pos().method_23854()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(landmark.owner() != null ? class_124.field_1060 : class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"\"").method_27692(class_124.field_1065)).method_10852((class_2561)(landmark.name() == null ? class_2561.method_30163((String)"") : landmark.name().method_27661().method_27694(s -> s.method_36139(landmark.color() != null ? landmark.color().method_7790() : class_124.field_1068.method_532().intValue())))).method_10852((class_2561)class_2561.method_43470((String)"\"").method_27692(class_124.field_1065)));
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---End %s Landmarks---".formatted(type)).method_27692(class_124.field_1080)));
        return landmarks.size();
    }

    private static int removeLandmark(WorldSummary summary, class_638 world, Consumer<class_2561> feedback, class_2960 type, class_2338 pos) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that type and position!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark<?> landmark = summary.landmarks().get(Landmarks.getType(type), pos);
        summary.landmarks().remove((class_1937)world, Landmarks.getType(type), pos);
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"%s removed successfully!".formatted(landmark.owner() == null ? "Landmark" : "Waypoint")).method_27692(class_124.field_1060)));
        return 1;
    }

    private static int addLandmark(WorldSummary summary, class_638 world, Consumer<class_2561> feedback, class_2960 type, class_2338 pos, class_1767 color, String name, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!SimplePointLandmark.TYPE.id().equals((Object)type)) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You can't create a landmark of that type!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"A landmark exists of that type and position!").method_27692(class_124.field_1054)));
            return 0;
        }
        summary.landmarks().put((class_1937)world, new SimplePointLandmark(pos, global ? null : SurveyorClient.getClientUuid(), color, class_2561.method_30163((String)name), new class_2960("")));
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"%s added successfully!".formatted(global ? "Landmark" : "Waypoint")).method_27692(class_124.field_1060)));
        return 1;
    }

    public static int execute(CommandContext<FabricClientCommandSource> context, SurveyorCommandExecutor<Integer> executor) {
        class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        SurveyorExploration exploration = SurveyorClient.getPersonalExploration();
        SurveyorClient.ClientExploration groupExploration = SurveyorClient.getSharedExploration();
        try {
            return executor.execute(WorldSummary.of((class_1937)((FabricClientCommandSource)context.getSource()).getWorld()), player, ((FabricClientCommandSource)context.getSource()).getWorld(), exploration, groupExploration, t -> ((FabricClientCommandSource)context.getSource()).sendFeedback(t));
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Command failed! Check log for details.").method_27692(class_124.field_1061));
            Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            return 0;
        }
    }

    private static class_2168 sourceForPos(FabricClientCommandSource source) {
        return new class_2168(null, source.getPosition(), source.getRotation(), null, 0, null, null, null, source.getEntity());
    }

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"surveyorc").executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.info(s, e, g, f)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.landmarkInfo(s, e, g, f)))).then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(Landmarks.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.getLandmarks(s, f, (class_2960)c.getArgument("type", class_2960.class))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(Landmarks.keySet(), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)class_2262.method_9698()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.removeLandmark(s, w, f, (class_2960)c.getArgument("type", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource()))))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)class_2262.method_9698()).then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1767.values()).map(class_1767::method_7792), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.addLandmark(s, w, f, (class_2960)c.getArgument("type", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), class_1767.method_7793((String)((String)c.getArgument("color", String.class)), (class_1767)class_1767.field_7952), (String)c.getArgument("name", String.class), false))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"global").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).requires(c -> c.getPlayer() == null || c.getPlayer().method_5687(2))).then(ClientCommandManager.argument((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)class_2262.method_9698()).then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1767.values()).map(class_1767::method_7792), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.addLandmark(s, w, f, (class_2960)c.getArgument("type", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), class_1767.method_7793((String)((String)c.getArgument("color", String.class)), (class_1767)class_1767.field_7952), (String)c.getArgument("name", String.class), true))))))))));
    }

    private static /* synthetic */ void lambda$landmarkInfo$9(Consumer feedback, Set waypoints, Multimap personalKeys, Collection group, Multimap groupKeys, Multimap keys, LandmarkType type, Collection list) {
        feedback.accept(class_2561.method_43470((String)"%s".formatted(type.id())).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(waypoints.contains(type) ? ": created " : ": explored ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(personalKeys.get((Object)type).size())).method_27692(class_124.field_1068)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupKeys.get((Object)type).size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" shared)").method_27692(class_124.field_1076)))).method_10852((class_2561)class_2561.method_43470((String)" {of ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(keys.get((Object)type).size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"}").method_27692(class_124.field_1065))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(WorldSummary var1, class_746 var2, class_638 var3, SurveyorExploration var4, SurveyorExploration var5, Consumer<class_2561> var6);
    }
}

