/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.terrain.RegionSummary;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public interface SurveyorExploration {
    public static final String KEY_EXPLORED_TERRAIN = "exploredTerrain";
    public static final String KEY_EXPLORED_STRUCTURES = "exploredStructures";

    public static SurveyorExploration of(class_3222 player) {
        return PlayerSummary.of(player).exploration();
    }

    public static SurveyorExploration of(UUID player, MinecraftServer server) {
        return ServerSummary.of(server).getExploration(player, server);
    }

    public static SurveyorExploration ofShared(class_3222 player) {
        return SurveyorExploration.ofShared(Surveyor.getUuid(player), player.method_5682());
    }

    public static SurveyorExploration ofShared(UUID player, MinecraftServer server) {
        return ServerSummary.of(server).groupExploration(player, server);
    }

    public Map<class_5321<class_1937>, Map<class_1923, BitSet>> terrain();

    public Map<class_5321<class_1937>, Map<class_5321<class_3195>, LongSet>> structures();

    public Set<UUID> sharedPlayers();

    default public void copyFrom(SurveyorExploration oldExploration) {
        this.terrain().putAll(oldExploration.terrain());
        this.structures().putAll(oldExploration.structures());
    }

    public boolean personal();

    default public boolean exploredChunk(class_5321<class_1937> worldKey, class_1923 pos) {
        class_1923 regionPos = new class_1923(pos.method_17885(), pos.method_17886());
        Map<class_1923, BitSet> regions = this.terrain().get(worldKey);
        return !this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER) || regions != null && regions.containsKey(regionPos) && regions.get(regionPos).get(RegionSummary.bitForChunk(pos));
    }

    default public boolean exploredStructure(class_5321<class_1937> worldKey, class_5321<class_3195> structure, class_1923 pos) {
        Map<class_5321<class_3195>, LongSet> structures = this.structures().get(worldKey);
        return !this.personal() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SERVER) || structures != null && structures.containsKey(structure) && structures.get(structure).contains(pos.method_8324());
    }

    default public boolean exploredLandmark(class_5321<class_1937> worldKey, Landmark<?> landmark) {
        return landmark.owner() == null ? this.exploredChunk(worldKey, new class_1923(landmark.pos())) : this.sharedPlayers().contains(landmark.owner());
    }

    default public int chunkCount() {
        return this.terrain().values().stream().flatMap(m -> m.values().stream()).mapToInt(BitSet::cardinality).sum();
    }

    default public int structureCount() {
        return this.structures().values().stream().flatMap(m -> m.values().stream()).mapToInt(Set::size).sum();
    }

    default public BitSet limitTerrainBitset(class_5321<class_1937> worldKey, class_1923 rPos, BitSet bitSet) {
        if (!this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER)) {
            return bitSet;
        }
        if (this.terrain().get(worldKey) == null || !this.terrain().get(worldKey).containsKey(rPos)) {
            bitSet.clear();
        } else {
            bitSet.and(this.terrain().get(worldKey).get(rPos));
        }
        return bitSet;
    }

    default public Map<class_1923, BitSet> limitTerrainBitset(class_5321<class_1937> worldKey, Map<class_1923, BitSet> bitSet) {
        if (!this.personal() && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SERVER)) {
            return bitSet;
        }
        Map<class_1923, BitSet> regions = this.terrain().get(worldKey);
        if (regions == null) {
            bitSet.clear();
        } else {
            bitSet.forEach((rPos, set) -> this.limitTerrainBitset(worldKey, (class_1923)rPos, (BitSet)set));
        }
        return bitSet;
    }

    default public Multimap<class_5321<class_3195>, class_1923> limitStructureKeySet(class_5321<class_1937> worldKey, Multimap<class_5321<class_3195>, class_1923> keySet) {
        if (!this.personal() && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SERVER)) {
            return keySet;
        }
        Map<class_5321<class_3195>, LongSet> structures = this.structures().get(worldKey);
        if (structures == null) {
            keySet.clear();
        } else {
            keySet.keySet().removeIf(key -> !structures.containsKey(key));
            keySet.entries().removeIf(e -> !((LongSet)structures.get(e.getKey())).contains(((class_1923)e.getValue()).method_8324()));
        }
        return keySet;
    }

    default public Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> limitLandmarkMap(class_5321<class_1937> worldKey, Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> asMap) {
        HashMultimap toRemove = HashMultimap.create();
        asMap.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkMap$6(worldKey, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((type, pos) -> {
            ((Map)asMap.get(type)).remove(pos);
            if (((Map)asMap.get(type)).isEmpty()) {
                asMap.remove(type);
            }
        });
        return asMap;
    }

    default public Multimap<LandmarkType<?>, class_2338> limitLandmarkKeySet(class_5321<class_1937> worldKey, WorldLandmarks worldLandmarks, Multimap<LandmarkType<?>, class_2338> keySet) {
        HashMultimap toRemove = HashMultimap.create();
        keySet.forEach((arg_0, arg_1) -> this.lambda$limitLandmarkKeySet$8(worldLandmarks, worldKey, (Multimap)toRemove, arg_0, arg_1));
        toRemove.forEach((arg_0, arg_1) -> keySet.remove(arg_0, arg_1));
        return keySet;
    }

    default public void updateClientForMergeRegion(class_1937 world, class_1923 regionPos, BitSet bitSet) {
        Set<class_1923> terrainKeys = bitSet.stream().mapToObj(i -> RegionSummary.chunkForBit(regionPos, i)).collect(Collectors.toSet());
        SurveyorClientEvents.Invoke.terrainUpdated(world, terrainKeys);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        summary.asMap(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForMergeRegion$11(terrainKeys, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, landmarkKeys);
    }

    default public void updateClientForLandmarks(class_1937 world) {
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        Multimap<LandmarkType<?>, class_2338> unexploredLandmarks = summary.keySet(null);
        Multimap<LandmarkType<?>, class_2338> exploredLandmarks = summary.keySet(this);
        exploredLandmarks.forEach((arg_0, arg_1) -> unexploredLandmarks.remove(arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, exploredLandmarks);
        SurveyorClientEvents.Invoke.landmarksRemoved(world, unexploredLandmarks);
    }

    default public void mergeRegion(class_5321<class_1937> worldKey, class_1923 regionPos, BitSet bitSet) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(regionPos, p -> new BitSet(32)).or(bitSet);
    }

    default public void replaceTerrain(class_5321<class_1937> worldKey, Map<class_1923, BitSet> bitSet) {
        Map<class_1923, BitSet> oldSet = this.terrain().get(worldKey);
        if (oldSet != null) {
            oldSet.clear();
        }
        bitSet.forEach((pos, set) -> this.mergeRegion(worldKey, (class_1923)pos, (BitSet)set));
    }

    default public void updateClientForAddChunk(class_1937 world, class_1923 chunkPos) {
        SurveyorClientEvents.Invoke.terrainUpdated(world, chunkPos);
        HashMultimap landmarkKeys = HashMultimap.create();
        WorldLandmarks summary = WorldSummary.of(world).landmarks();
        if (summary == null) {
            return;
        }
        summary.asMap(this).forEach((arg_0, arg_1) -> SurveyorExploration.lambda$updateClientForAddChunk$16(chunkPos, (Multimap)landmarkKeys, arg_0, arg_1));
        SurveyorClientEvents.Invoke.landmarksAdded(world, landmarkKeys);
    }

    default public void addChunk(class_5321<class_1937> worldKey, class_1923 pos) {
        this.terrain().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(new class_1923(pos.method_17885(), pos.method_17886()), k -> new BitSet(1024)).set(RegionSummary.bitForChunk(pos));
    }

    default public void updateClientForAddStructure(class_1937 world, class_5321<class_3195> structureKey, class_1923 pos) {
        SurveyorClientEvents.Invoke.structuresAdded(world, structureKey, pos);
    }

    default public void addStructure(class_5321<class_1937> worldKey, class_5321<class_3195> structureKey, class_1923 pos) {
        this.structures().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(structureKey, s -> new LongOpenHashSet()).add(pos.method_8324());
    }

    default public void mergeStructures(class_5321<class_1937> worldKey, class_5321<class_3195> structureKey, LongSet starts) {
        this.structures().computeIfAbsent(worldKey, k -> new HashMap()).computeIfAbsent(structureKey, s -> new LongOpenHashSet()).addAll((LongCollection)starts);
    }

    default public void replaceStructures(class_5321<class_1937> worldKey, Map<class_5321<class_3195>, LongSet> structures) {
        LongSet oldSet = structures.get(worldKey);
        if (oldSet != null) {
            oldSet.clear();
        }
        structures.forEach((key, set) -> this.mergeStructures(worldKey, (class_5321<class_3195>)key, (LongSet)set));
    }

    default public class_2487 write(class_2487 nbt) {
        class_2487 terrainCompound = new class_2487();
        this.terrain().forEach((worldKey, map) -> {
            LongArrayList regionLongs = new LongArrayList();
            for (Map.Entry entry : map.entrySet()) {
                regionLongs.add(((class_1923)entry.getKey()).method_8324());
                if (((BitSet)entry.getValue()).cardinality() == 1024) {
                    regionLongs.add(-1L);
                    continue;
                }
                long[] regionBits = ((BitSet)entry.getValue()).toLongArray();
                regionLongs.add((long)regionBits.length);
                regionLongs.addAll(LongList.of((long[])regionBits));
            }
            terrainCompound.method_10564(worldKey.method_29177().toString(), regionLongs.toLongArray());
        });
        nbt.method_10566(KEY_EXPLORED_TERRAIN, (class_2520)terrainCompound);
        class_2487 structuresCompound = new class_2487();
        this.structures().forEach((worldKey, map) -> {
            class_2487 worldStructuresCompound = new class_2487();
            for (class_5321 structure : map.keySet()) {
                worldStructuresCompound.method_10564(structure.method_29177().toString(), ((LongSet)map.get(structure)).toLongArray());
            }
            structuresCompound.method_10566(worldKey.method_29177().toString(), (class_2520)worldStructuresCompound);
        });
        nbt.method_10566(KEY_EXPLORED_STRUCTURES, (class_2520)structuresCompound);
        return nbt;
    }

    default public void read(class_2487 nbt) {
        class_2487 terrainCompound = nbt.method_10562(KEY_EXPLORED_TERRAIN);
        for (String worldKeyString : terrainCompound.method_10541()) {
            long[] regionArray = terrainCompound.method_10565(worldKeyString);
            HashMap<class_1923, BitSet> regionMap = new HashMap<class_1923, BitSet>();
            int i = 0;
            while (i + 1 < regionArray.length) {
                class_1923 rPos = new class_1923(regionArray[i]);
                int bitLength = (int)regionArray[i + 1];
                if (bitLength == -1) {
                    BitSet set = new BitSet(1024);
                    set.set(0, 1024);
                    regionMap.put(rPos, set);
                } else {
                    long[] bitArray = new long[bitLength];
                    System.arraycopy(regionArray, i + 2, bitArray, 0, bitLength);
                    regionMap.put(rPos, BitSet.valueOf(bitArray));
                    i += bitLength;
                }
                i += 2;
            }
            this.terrain().put((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(worldKeyString)), regionMap);
        }
        class_2487 structuresCompound = nbt.method_10562(KEY_EXPLORED_STRUCTURES);
        for (String worldKeyString : structuresCompound.method_10541()) {
            HashMap<class_5321, LongOpenHashSet> structureMap = new HashMap<class_5321, LongOpenHashSet>();
            class_2487 worldStructuresCompound = structuresCompound.method_10562(worldKeyString);
            for (String key : worldStructuresCompound.method_10541()) {
                structureMap.put(class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)new class_2960(key)), new LongOpenHashSet(worldStructuresCompound.method_10565(key)));
            }
            this.structures().put((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(worldKeyString)), structureMap);
        }
    }

    private static /* synthetic */ void lambda$updateClientForAddChunk$16(class_1923 chunkPos, Multimap landmarkKeys, LandmarkType type, Map map) {
        map.forEach((pos, mark) -> {
            if (chunkPos.equals((Object)new class_1923(pos)) && mark.owner() == null) {
                landmarkKeys.put((Object)type, pos);
            }
        });
    }

    private static /* synthetic */ void lambda$updateClientForMergeRegion$11(Set terrainKeys, Multimap landmarkKeys, LandmarkType type, Map map) {
        map.forEach((pos, mark) -> {
            if (terrainKeys.contains(new class_1923(pos)) && mark.owner() == null) {
                landmarkKeys.put((Object)type, pos);
            }
        });
    }

    private /* synthetic */ void lambda$limitLandmarkKeySet$8(WorldLandmarks worldLandmarks, class_5321 worldKey, Multimap toRemove, LandmarkType type, class_2338 pos) {
        if (!worldLandmarks.contains(type, pos) || !this.exploredLandmark((class_5321<class_1937>)worldKey, worldLandmarks.get(type, pos))) {
            toRemove.put((Object)type, (Object)pos);
        }
    }

    private /* synthetic */ void lambda$limitLandmarkMap$6(class_5321 worldKey, Multimap toRemove, LandmarkType type, Map map) {
        map.forEach((pos, landmark) -> {
            if (!this.exploredLandmark((class_5321<class_1937>)worldKey, (Landmark<?>)landmark)) {
                toRemove.put((Object)type, pos);
            }
        });
    }
}

