/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.collect.BiMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.utils.BlockPredicate;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SoapWashableHelper {
    public static boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        if (SoapWashableHelper.tryWashWithInterface(level, pos, state, hitVec) || SoapWashableHelper.tryCleaningSign(level, pos, state) || SoapWashableHelper.tryChangingColor(level, pos, state) || SoapWashableHelper.tryUnoxidise(level, pos, state)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ModNetwork.CHANNEL.sendToAllClientPlayersInParticleRange((Level)serverLevel, pos, (Message)new ClientBoundParticlePacket(pos, ClientBoundParticlePacket.Type.BUBBLE_CLEAN));
            }
            return true;
        }
        return false;
    }

    private static boolean tryCleaningSign(Level level, BlockPos pos, BlockState state) {
        SignBlockEntity te;
        BlockEntity blockEntity;
        if (state.m_60734_() instanceof SignBlock && (blockEntity = level.m_7702_(pos)) instanceof SignBlockEntity && (te = (SignBlockEntity)blockEntity).m_277118_()) {
            te.m_277031_(false);
            if (!level.f_46443_) {
                te.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
            return true;
        }
        return false;
    }

    private static boolean tryUnoxidise(Level level, BlockPos pos, BlockState state) {
        Block b = state.m_60734_();
        BlockState toPlace = null;
        for (Map.Entry<BlockPredicate, ResourceLocation> e : CommonConfigs.Functional.SOAP_SPECIAL.get().entrySet()) {
            if (!e.getKey().test(state)) continue;
            toPlace = BuiltInRegistries.f_256975_.m_6612_(e.getValue()).map(s -> s.m_152465_(state)).orElse(null);
            break;
        }
        if (toPlace == null) {
            toPlace = SuppPlatformStuff.getUnoxidised(level, pos, state);
        }
        if (toPlace == null) {
            Block unWaxed = (Block)((BiMap)HoneycombItem.f_150863_.get()).inverse().get((Object)b);
            if (unWaxed == null) {
                unWaxed = b;
            }
            if ((unWaxed = WeatheringCopper.m_154897_((Block)unWaxed)) != b) {
                toPlace = unWaxed.m_152465_(state);
            }
        }
        if (toPlace == null) {
            toPlace = SoapWashableHelper.tryParse(state);
        }
        if (toPlace != null) {
            level.m_7731_(pos, toPlace, 11);
            return true;
        }
        return false;
    }

    private static BlockState tryParse(BlockState oldState) {
        String[] keywords;
        ResourceLocation r = Utils.getID((Block)oldState.m_60734_());
        String name = r.m_135815_();
        for (String key : keywords = new String[]{"waxed_", "weathered_", "exposed_", "oxidized_", "_waxed", "_weathered", "_exposed", "_oxidized"}) {
            BlockState newState;
            if (!name.contains(key)) continue;
            String newName = name.replace(key, "");
            Optional bb = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(r.m_135827_(), newName));
            if (bb.isEmpty()) {
                bb = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(newName));
            }
            if (!bb.isPresent() || (newState = ((Block)bb.get()).m_152465_(oldState)) == oldState) continue;
            return newState;
        }
        return null;
    }

    private static boolean tryWashWithInterface(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        BlockEntity tile;
        IWashable soapWashable;
        Block b = state.m_60734_();
        IWashable cap = b instanceof IWashable ? (soapWashable = (IWashable)b) : SuppPlatformStuff.getForgeCap(b, IWashable.class);
        if (cap == null && (tile = level.m_7702_(pos)) != null) {
            IWashable soapWashable2;
            cap = tile instanceof IWashable ? (soapWashable2 = (IWashable)tile) : SuppPlatformStuff.getForgeCap(tile, IWashable.class);
        }
        if (cap != null) {
            return cap.tryWash(level, pos, state, hitVec);
        }
        return false;
    }

    private static boolean tryChangingColor(Level level, BlockPos pos, BlockState state) {
        Block newColor = BlocksColorAPI.changeColor((Block)state.m_60734_(), null);
        if (newColor != null) {
            BlockEntity be;
            BlockEntity be2;
            if (CommonConfigs.Functional.SOAP_DYE_CLEAN_BLACKLIST.get().contains(BlocksColorAPI.getKey((Block)state.m_60734_()))) {
                return false;
            }
            if (state.m_60734_() instanceof BedBlock) {
                return false;
            }
            CompoundTag tag = null;
            if (newColor instanceof EntityBlock && (be2 = level.m_7702_(pos)) != null) {
                tag = be2.m_187482_();
            }
            BlockState toPlace = newColor.m_152465_(state);
            level.m_7731_(pos, toPlace, 2);
            if (tag != null && (be = level.m_7702_(pos)) != null) {
                be.m_142466_(tag);
            }
            return true;
        }
        return false;
    }
}

