/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class SusRecipe
extends CustomRecipe {
    private final Ingredient ingredient;
    private final ItemStack result;

    public SusRecipe(ResourceLocation recipeId, CraftingBookCategory craftingBookCategory, Ingredient ingredient, ItemStack itemStack) {
        super(recipeId, craftingBookCategory);
        this.ingredient = ingredient;
        this.result = itemStack;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack gravel = null;
        ItemStack something = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (gravel == null && this.ingredient.test(stack)) {
                gravel = stack;
                continue;
            }
            if (stack.m_41619_()) continue;
            if (something != null) {
                return false;
            }
            something = stack;
        }
        return gravel != null && something != null;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack gravel = null;
        ItemStack something = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (gravel == null && this.ingredient.test(stack)) {
                gravel = stack;
                continue;
            }
            if (stack.m_41619_()) continue;
            something = stack;
        }
        ItemStack result = this.result.m_41777_();
        result.m_41698_("BlockEntityTag").m_128365_("item", (Tag)something.m_41739_(new CompoundTag()));
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.SUS_CRAFTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SusRecipe> {
        public SusRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_288218_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient"), (boolean)false) : Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"), (boolean)false);
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            return new SusRecipe(recipeId, craftingBookCategory, ingredient, itemStack);
        }

        public SusRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemStack = buffer.m_130267_();
            return new SusRecipe(recipeId, craftingBookCategory, ingredient, itemStack);
        }

        public void toNetwork(FriendlyByteBuf buffer, SusRecipe recipe) {
            buffer.m_130068_((Enum)recipe.m_245232_());
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
        }
    }
}

