/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IOnePlayerInteractable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.CannonBallItem;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundControlCannonPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSyncCannonPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CannonBlockTile
extends OpeneableContainerBlockEntity
implements IOnePlayerInteractable {
    @Nullable
    private Set<Block> breakWhitelist = null;
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private int cooldownTimer = 0;
    private int fuseTimer = 0;
    private byte powerLevel = 1;
    private IBallisticBehavior.Data trajectoryData = IBallisticBehavior.LINE;
    private Item trajectoryFor = Items.f_41852_;
    @Nullable
    private UUID playerWhoIgnitedUUID = null;
    @Nullable
    private UUID controllingPlayer = null;

    public CannonBlockTile(BlockPos pos, BlockState blockState) {
        super(ModRegistry.CANNON_TILE.get(), pos, blockState, 2);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("yaw", this.yaw);
        tag.m_128350_("pitch", this.pitch);
        tag.m_128405_("cooldown", this.cooldownTimer);
        tag.m_128405_("fuse_timer", this.fuseTimer);
        tag.m_128344_("fire_power", this.powerLevel);
        if (this.playerWhoIgnitedUUID != null) {
            tag.m_128362_("player_ignited", this.playerWhoIgnitedUUID);
        }
        if (this.breakWhitelist != null) {
            CannonBlockTile.saveBreakWhitelist(this.breakWhitelist, tag);
        }
    }

    public static void saveBreakWhitelist(Set<Block> breakWhitelist, CompoundTag tag) {
        ListTag list = new ListTag();
        for (Block b : breakWhitelist) {
            list.add((Object)StringTag.m_129297_((String)BuiltInRegistries.f_256975_.m_7981_((Object)b).toString()));
        }
        tag.m_128365_("break_whitelist", (Tag)list);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.yaw = tag.m_128457_("yaw");
        this.pitch = tag.m_128457_("pitch");
        this.cooldownTimer = tag.m_128451_("cooldown");
        this.fuseTimer = tag.m_128451_("fuse_timer");
        this.powerLevel = tag.m_128445_("fire_power");
        if (tag.m_128441_("player_ignited")) {
            this.playerWhoIgnitedUUID = tag.m_128342_("player_ignited");
        }
        this.breakWhitelist = CannonBlockTile.readBreakWhitelist(tag);
    }

    @Nullable
    public static Set<Block> readBreakWhitelist(CompoundTag tag) {
        if (tag.m_128441_("break_whitelist")) {
            ListTag list = tag.m_128437_("break_whitelist", 8);
            HashSet<Block> breakWhitelist = new HashSet<Block>();
            for (int i = 0; i < list.size(); ++i) {
                Block b = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(list.m_128778_(i)));
                breakWhitelist.add(b);
            }
            return breakWhitelist;
        }
        return null;
    }

    public void m_6596_() {
        super.m_6596_();
    }

    private void computeTrajectoryData() {
        ItemStack proj = this.getProjectile();
        IFireItemBehavior behavior = CannonBlock.getCannonBehavior((ItemLike)this.getProjectile().m_41720_());
        if (behavior instanceof IBallisticBehavior) {
            IBallisticBehavior b = (IBallisticBehavior)behavior;
            this.trajectoryData = b.calculateData(proj, this.f_58857_);
        } else {
            this.trajectoryData = IBallisticBehavior.LINE;
        }
        if (this.trajectoryData == null) {
            Supplementaries.error();
        }
        this.trajectoryFor = proj.m_41720_();
    }

    public boolean readyToFire() {
        return this.cooldownTimer == 0 && this.fuseTimer == 0 && this.hasFuelAndProjectiles();
    }

    public boolean hasFuelAndProjectiles() {
        return !this.getProjectile().m_41619_() && !this.getFuel().m_41619_() && this.getFuel().m_41613_() >= this.powerLevel;
    }

    public boolean isFiring() {
        return this.fuseTimer > 0;
    }

    public float getFiringAnimation(float partialTicks) {
        if (this.fuseTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.fuseTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_FUSE_TIME.get().intValue();
    }

    public float getCooldownAnimation(float partialTicks) {
        if (this.cooldownTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.cooldownTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_COOLDOWN.get().intValue();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ItemStack getProjectile() {
        return this.m_8020_(1);
    }

    public void setProjectile(ItemStack stack) {
        this.m_6836_(1, stack);
    }

    public ItemStack getFuel() {
        return this.m_8020_(0);
    }

    public void setFuel(ItemStack stack) {
        this.m_6836_(0, stack);
    }

    public IBallisticBehavior.Data getTrajectoryData() {
        if (this.trajectoryFor != this.getProjectile().m_41720_()) {
            this.computeTrajectoryData();
        }
        return this.trajectoryData;
    }

    public byte getPowerLevel() {
        return this.powerLevel;
    }

    public float getFirePower() {
        return (float)Math.pow(this.powerLevel, CommonConfigs.Functional.CANNON_FIRE_POWER.get());
    }

    public float getYaw(float partialTicks) {
        return Mth.m_14189_((float)partialTicks, (float)this.prevYaw, (float)this.yaw);
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch(float partialTicks) {
        return Mth.m_14189_((float)partialTicks, (float)this.prevPitch, (float)this.pitch);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setAttributes(float yaw, float pitch, byte firePower, boolean fire, Player controllingPlayer) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.powerLevel = firePower;
        if (fire) {
            this.ignite((Entity)controllingPlayer);
        }
    }

    public void setRestrainedPitch(float pitch) {
        Restraint r = this.getPitchAndYawRestrains();
        this.pitch = Mth.m_14036_((float)Mth.m_14177_((float)pitch), (float)r.minPitch, (float)r.maxPitch);
    }

    public void setRestrainedYaw(float yaw) {
        Restraint r = this.getPitchAndYawRestrains();
        this.yaw = Mth.m_14036_((float)Mth.m_14177_((float)yaw), (float)r.minYaw, (float)r.maxYaw);
    }

    public void setRenderYaw(float yaw) {
        this.setRestrainedYaw(yaw);
        this.prevYaw = this.yaw;
    }

    public void setRenderPitch(float pitch) {
        this.setRestrainedPitch(pitch);
        this.prevPitch = this.pitch;
    }

    public Restraint getPitchAndYawRestrains() {
        BlockState state = this.m_58900_();
        return switch (((Direction)state.m_61143_((Property)CannonBlock.f_52588_)).m_122424_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new Restraint(70.0f, 290.0f, -360.0f, 360.0f);
            case Direction.SOUTH -> new Restraint(-110.0f, 110.0f, -360.0f, 360.0f);
            case Direction.EAST -> new Restraint(-200.0f, 20.0f, -360.0f, 360.0f);
            case Direction.WEST -> new Restraint(-20.0f, 200.0f, -360.0f, 360.0f);
            case Direction.UP -> new Restraint(-360.0f, 360.0f, -200.0f, 20.0f);
            case Direction.DOWN -> new Restraint(-360.0f, 360.0f, -20.0f, 200.0f);
        };
    }

    public void changeFirePower(int scrollDelta) {
        this.powerLevel = (byte)(1 + Math.floorMod(this.powerLevel - 1 + scrollDelta, 4));
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"gui.supplementaries.cannon");
    }

    @Override
    protected void updateBlockState(BlockState state, boolean b) {
    }

    @Override
    protected void playOpenSound(BlockState state) {
    }

    @Override
    protected void playCloseSound(BlockState state) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return stack.m_150930_(Items.f_42403_);
        }
        return true;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(direction == null || direction.m_122434_().m_122479_() ? 1 : 0, itemStack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{side.m_122434_().m_122479_() ? 1 : 0};
    }

    @Override
    public boolean tryOpeningEditGui(ServerPlayer player, BlockPos pos, ItemStack stack) {
        if (player.m_36341_()) {
            if (Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack) && !this.isOtherPlayerEditing((Player)player)) {
                this.setPlayerWhoMayEdit(player.m_20148_());
                ModNetwork.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundControlCannonPacket(this.f_58858_));
            }
            return true;
        }
        return IOnePlayerInteractable.super.tryOpeningEditGui(player, pos, stack);
    }

    public void ignite(@Nullable Entity entityWhoIgnited) {
        if (this.fuseTimer > 0) {
            return;
        }
        if (this.getProjectile().m_41619_()) {
            return;
        }
        this.fuseTimer = CommonConfigs.Functional.CANNON_FUSE_TIME.get();
        this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 0, 0);
        this.playerWhoIgnitedUUID = entityWhoIgnited != null ? entityWhoIgnited.m_20148_() : null;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CannonBlockTile t) {
        t.prevYaw = t.yaw;
        t.prevPitch = t.pitch;
        if (t.cooldownTimer > 0) {
            --t.cooldownTimer;
        }
        if (t.fuseTimer > 0) {
            --t.fuseTimer;
            if (t.fuseTimer <= 0) {
                t.fire();
            }
        }
    }

    private void fire() {
        if (!this.hasFuelAndProjectiles()) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            Player p;
            ServerLevel sl = (ServerLevel)level;
            if (this.shootProjectile(sl) && ((p = this.getPlayerWhoFired()) == null || !p.m_7500_())) {
                ItemStack fuel = this.getFuel();
                fuel.m_41774_((int)this.powerLevel);
                this.setFuel(fuel);
                ItemStack projectile = this.getProjectile();
                projectile.m_41774_(1);
                this.setProjectile(projectile);
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                this.f_58857_.m_142346_((Entity)p, GameEvent.f_157812_, this.f_58858_);
            }
        } else {
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, 0);
        }
        this.cooldownTimer = CommonConfigs.Functional.CANNON_COOLDOWN.get();
    }

    private boolean shootProjectile(ServerLevel serverLevel) {
        Vec3 facing = Vec3.m_82498_((float)this.pitch, (float)this.yaw).m_82490_(-1.0);
        ItemStack projectile = this.getProjectile().m_41777_();
        if (projectile.m_41720_() instanceof CannonBallItem && this.breakWhitelist != null) {
            CannonBlockTile.saveBreakWhitelist(this.breakWhitelist, projectile.m_41784_());
        }
        IFireItemBehavior behavior = CannonBlock.getCannonBehavior((ItemLike)this.getProjectile().m_41720_());
        return behavior.fire(projectile.m_41777_(), serverLevel, this.f_58858_, 0.5f, facing, this.getFirePower(), 0, this.getPlayerWhoFired());
    }

    @Nullable
    private Player getPlayerWhoFired() {
        UUID uuid = this.controllingPlayer;
        if (uuid == null && this.playerWhoIgnitedUUID != null) {
            uuid = this.playerWhoIgnitedUUID;
        }
        if (uuid == null) {
            return null;
        }
        return this.f_58857_.m_46003_(uuid);
    }

    @Override
    public void setPlayerWhoMayEdit(@Nullable UUID uuid) {
        this.controllingPlayer = uuid;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.controllingPlayer;
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CannonContainerMenu(id, player, this);
    }

    public static void syncToServer(CannonBlockTile cannon, boolean fire, boolean removeOwner) {
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundSyncCannonPacket(cannon.getYaw(), cannon.getPitch(), cannon.getPowerLevel(), fire, cannon.m_58899_(), removeOwner));
    }

    public record Restraint(float minYaw, float maxYaw, float minPitch, float maxPitch) {
    }
}

