/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1428;
import net.minecraft.class_1453;
import net.minecraft.class_1463;
import net.minecraft.class_1559;
import net.minecraft.class_1621;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class BuiltinAnimation<T extends class_1297> {
    protected float jumpY = 0.0f;
    protected float prevJumpY = 0.0f;
    protected float yVel = 0.0f;

    void tick(T mob, class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            ((class_1297)mob).field_5971 = mob.method_23318();
            float dy = this.jumpY - this.prevJumpY;
            if (dy != 0.0f) {
                mob.method_5814(mob.method_23317(), mob.method_23318() + (double)dy, mob.method_23321());
            }
            this.prevJumpY = this.jumpY;
        }
    }

    @Nullable
    public static <E extends class_1297> BuiltinAnimation<E> get(E entity, Type type) {
        if (type == Type.BUILTIN) {
            if (entity instanceof class_1621) {
                class_1621 slime = (class_1621)entity;
                return new SlimeAnim<class_1621>(slime);
            }
            if (entity instanceof class_1428) {
                class_1428 chicken = (class_1428)entity;
                return new ChickenAnim(chicken);
            }
            if (entity instanceof class_1463) {
                class_1463 rabbit = (class_1463)entity;
                return new RabbitAnim(rabbit);
            }
            if (entity instanceof class_1453) {
                class_1453 parrot = (class_1453)entity;
                return new ParrotAnim(parrot);
            }
            if (entity instanceof class_1559) {
                class_1559 endermite = (class_1559)entity;
                return new EndermiteAnim(endermite);
            }
        } else if (type == Type.FLOATING) {
            return new FloatingAnim<E>(entity);
        }
        return null;
    }

    public static enum Type implements class_3542
    {
        NONE,
        LAND,
        AIR,
        FLOATING,
        BUILTIN;

        public static final Codec<Type> CODEC;

        public boolean isFlying() {
            return this == AIR || this == FLOATING;
        }

        public boolean isLand() {
            return this == LAND;
        }

        public boolean isFloating() {
            return this == FLOATING;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }

    private static class SlimeAnim<M extends class_1621>
    extends BuiltinAnimation<M> {
        SlimeAnim(M slime) {
        }

        @Override
        public void tick(M mob, class_1937 world, class_2338 pos) {
            if (world.field_9236) {
                ((class_1621)mob).field_7388 += (((class_1621)mob).field_7389 - ((class_1621)mob).field_7388) * 0.5f;
                ((class_1621)mob).field_7387 = ((class_1621)mob).field_7388;
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.04f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                        ((class_1621)mob).field_7389 = -0.5f;
                    }
                    if ((double)world.method_8409().method_43057() > 0.985) {
                        this.yVel = 0.153f;
                        ((class_1621)mob).field_7389 = 1.0f;
                    }
                }
                ((class_1621)mob).field_7389 *= 0.6f;
                super.tick(mob, world, pos);
            }
        }
    }

    private static class ChickenAnim<M extends class_1428>
    extends BuiltinAnimation<M> {
        public ChickenAnim(class_1428 chicken) {
        }

        @Override
        public void tick(M mob, class_1937 world, class_2338 pos) {
            class_5819 rand = world.method_8409();
            if (!world.field_9236) {
                if (--((class_1428)mob).field_6739 <= 0) {
                    mob.method_5706((class_1935)class_1802.field_8803);
                    ((class_1428)mob).field_6739 = rand.method_43048(6000) + 6000;
                }
            } else {
                mob.method_6007();
                double d = world.field_9229.method_43057();
                double d2 = mob.method_24828() ? 0.99 : 0.88;
                if (d > d2) {
                    mob.method_24830(!mob.method_24828());
                }
            }
        }
    }

    private static class RabbitAnim<M extends class_1463>
    extends BuiltinAnimation<M> {
        public RabbitAnim(class_1463 rabbit) {
        }

        @Override
        public void tick(M mob, class_1937 world, class_2338 pos) {
            if (world.field_9236) {
                if (this.yVel != 0.0f) {
                    this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                }
                if (this.jumpY != 0.0f) {
                    this.yVel -= 0.017f;
                } else {
                    if (this.yVel != 0.0f) {
                        this.yVel = 0.0f;
                    }
                    if ((double)world.field_9229.method_43057() > 0.985) {
                        this.yVel = 0.093f;
                        mob.method_6618();
                    }
                }
                mob.method_6007();
                super.tick(mob, world, pos);
            }
        }
    }

    private static class ParrotAnim<M extends class_1453>
    extends BuiltinAnimation<M> {
        public ParrotAnim(class_1453 parrot) {
        }

        @Override
        public void tick(M mob, class_1937 world, class_2338 pos) {
            if (world.field_9236) {
                mob.method_6007();
                boolean p = mob.method_6582();
                mob.method_24830(p);
                this.jumpY = p ? 0.0f : 0.0625f;
                super.tick(mob, world, pos);
            }
        }
    }

    private static class EndermiteAnim<M extends class_1559>
    extends BuiltinAnimation<M> {
        public EndermiteAnim(class_1559 endermite) {
        }

        @Override
        public void tick(M mob, class_1937 world, class_2338 pos) {
            if (world.field_9236 && world.field_9229.method_43057() > 0.7f) {
                world.method_8406((class_2394)class_2398.field_11214, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.2f), (double)((float)pos.method_10260() + 0.5f), (world.field_9229.method_43058() - 0.5) * 2.0, -world.field_9229.method_43058(), (world.field_9229.method_43058() - 0.5) * 2.0);
            }
        }
    }

    private static class FloatingAnim<M extends class_1297>
    extends BuiltinAnimation<M> {
        FloatingAnim(M entity) {
        }

        @Override
        public void tick(M mob, class_1937 world, class_2338 pos) {
            if (world.field_9236) {
                this.jumpY = 0.04f * class_3532.method_15374((float)((float)((class_1297)mob).field_6012 / 10.0f)) - 0.03f;
            }
        }
    }
}

