/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetItemSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class FaucetBlockTile
extends class_2586
implements IExtraModelDataProvider {
    private static final List<FaucetSource.BlState> BLOCK_INTERACTIONS = new ArrayList<FaucetSource.BlState>();
    private static final List<FaucetSource.Tile> TILE_INTERACTIONS = new ArrayList<FaucetSource.Tile>();
    private static final List<FaucetSource.Fluid> SOURCE_FLUID_INTERACTIONS = new ArrayList<FaucetSource.Fluid>();
    private static final List<FaucetItemSource> ITEM_INTERACTIONS = new ArrayList<FaucetItemSource>();
    private static final List<FaucetTarget.BlState> TARGET_BLOCK_INTERACTIONS = new ArrayList<FaucetTarget.BlState>();
    private static final List<FaucetTarget.Tile> TARGET_TILE_INTERACTIONS = new ArrayList<FaucetTarget.Tile>();
    private static final List<FaucetTarget.Fluid> TARGET_FLUID_INTERACTIONS = new ArrayList<FaucetTarget.Fluid>();
    public static final ModelDataKey<class_5321<SoftFluid>> FLUID = ModBlockProperties.FLUID;
    public static final ModelDataKey<Integer> FLUID_COLOR = ModBlockProperties.FLUID_COLOR;
    public static final int COOLDOWN_PER_BOTTLE = 20;
    private int transferCooldown = 0;
    public final SoftFluidTank tempFluidHolder = SoftFluidTank.create((int)5);
    public static final Predicate<class_1297> NON_PLAYER = e -> e.method_5805() && !(e instanceof class_1657);

    public FaucetBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.FAUCET_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        if (this.field_11863 != null && !this.tempFluidHolder.isEmpty()) {
            int color = this.tempFluidHolder.getCachedFlowingColor((class_1920)this.field_11863, this.field_11867);
            builder.with(FLUID, (Object)this.tempFluidHolder.getFluid().fluidKey());
            builder.with(FLUID_COLOR, (Object)color);
        }
    }

    public void updateLight() {
        if (this.field_11863 == null) {
            return;
        }
        int light = this.tempFluidHolder.getFluidValue().getLuminosity();
        if (light != 0) {
            light = (int)class_3532.method_15363((float)((float)light / 2.0f), (float)1.0f, (float)7.0f);
        }
        if (light != (Integer)this.method_11010().method_11654((class_2769)FaucetBlock.LIGHT_LEVEL)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)FaucetBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.method_11016().method_10069(0, -1, 0), this.method_11016().method_10069(1, 1, 1));
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, FaucetBlockTile tile) {
        if (tile.transferCooldown > 0) {
            --tile.transferCooldown;
        } else if (tile.isOpen()) {
            int cooldown = tile.tryExtract(pLevel, pPos, pState, false);
            tile.transferCooldown += cooldown;
        }
    }

    public boolean updateContainedFluidVisuals(class_1937 level, class_2338 pos, class_2680 state) {
        boolean r = this.tryExtract(level, pos, state, true) != 0;
        this.updateLight();
        this.requestModelReload();
        return r;
    }

    private int tryExtract(class_1937 level, class_2338 pos, class_2680 state, boolean justVisual) {
        class_3610 fluidState;
        class_2350 dir = (class_2350)state.method_11654((class_2769)FaucetBlock.FACING);
        class_2338 behind = pos.method_10093(dir.method_10153());
        class_2680 backState = level.method_8320(behind);
        this.tempFluidHolder.clear();
        if (backState.method_26215()) {
            return 0;
        }
        Integer filledAmount = this.runInteractions(BLOCK_INTERACTIONS, level, dir, behind, backState, justVisual);
        if (filledAmount != null) {
            return filledAmount;
        }
        class_2586 tileBack = level.method_8321(behind);
        if (tileBack != null && (filledAmount = this.runInteractions(TILE_INTERACTIONS, level, dir, behind, tileBack, justVisual)) != null) {
            return filledAmount;
        }
        if (!this.isConnectedBelow() && !justVisual && (CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue() || CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue())) {
            for (FaucetItemSource bi : ITEM_INTERACTIONS) {
                class_1799 removed = bi.tryExtractItem(level, behind, backState, dir, tileBack);
                if (removed.method_7960()) continue;
                if (!(CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue() && this.fillEntityBelow(removed, dir) || !CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue())) {
                    this.drop(removed);
                }
                return 20;
            }
        }
        if ((filledAmount = this.runInteractions(SOURCE_FLUID_INTERACTIONS, level, dir, behind, fluidState = level.method_8316(behind), justVisual)) != null) {
            return filledAmount;
        }
        return 0;
    }

    @Nullable
    private <T, S extends FaucetSource<T>> Integer runInteractions(List<S> interactions, class_1937 level, class_2350 dir, class_2338 pos, T source, boolean justVisual) {
        for (FaucetSource inter : interactions) {
            FluidOffer fluid = inter.getProvidedFluid(level, pos, dir, source);
            if (fluid == null) continue;
            if (justVisual) {
                this.tempFluidHolder.setFluid(fluid.fluid());
                return 20;
            }
            Integer amountFilled = this.tryFillingBlockBelow(fluid);
            if (amountFilled == null) continue;
            if (amountFilled == 0) {
                return 0;
            }
            inter.drain(level, pos, dir, source, amountFilled);
            return amountFilled * 20;
        }
        return null;
    }

    private Integer tryFillingBlockBelow(FluidOffer offer) {
        class_2338 below = this.field_11867.method_10074();
        class_2680 belowState = this.field_11863.method_8320(below);
        for (FaucetTarget.BlState blState : TARGET_BLOCK_INTERACTIONS) {
            Integer res = blState.fill(this.field_11863, below, belowState, offer);
            if (res == null) continue;
            return res;
        }
        class_2586 tileBelow = this.field_11863.method_8321(below);
        if (tileBelow != null) {
            for (FaucetTarget.Tile bi : TARGET_TILE_INTERACTIONS) {
                Integer res = bi.fill(this.field_11863, below, tileBelow, offer);
                if (res == null) continue;
                return res;
            }
        }
        class_3610 class_36102 = belowState.method_26227();
        for (FaucetTarget.Fluid bi : TARGET_FLUID_INTERACTIONS) {
            Integer res = bi.fill(this.field_11863, below, class_36102, offer);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public boolean isOpen() {
        return (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12484) ^ (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12515);
    }

    public boolean hasWater() {
        return (Boolean)this.method_11010().method_11654((class_2769)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.method_11010().method_11654((class_2769)FaucetBlock.CONNECTED);
    }

    private void drop(class_1799 extracted) {
        class_2338 pos = this.field_11867;
        class_1542 drop = new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, extracted);
        drop.method_18799(new class_243(0.0, 0.0, 0.0));
        this.field_11863.method_8649((class_1297)drop);
        float f = (this.field_11863.field_9229.method_43057() - 0.5f) / 4.0f;
        this.field_11863.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 0.3f, 0.5f + f);
    }

    private boolean fillEntityBelow(class_1799 stack, class_2350 direction) {
        List list = this.field_11863.method_8333((class_1297)null, new class_238(this.field_11867).method_989(0.0, -0.75, 0.0), NON_PLAYER);
        Collections.shuffle(list);
        for (class_1297 o : list) {
            if (!(stack = ItemsUtil.tryAddingItem(stack, this.field_11863, direction, o)).method_7960()) continue;
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.transferCooldown = compound.method_10550("TransferCooldown");
        this.tempFluidHolder.load(compound);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("TransferCooldown", this.transferCooldown);
        this.tempFluidHolder.save(tag);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void registerInteraction(Object interaction) {
        FaucetSource<class_2680> bs;
        boolean success = false;
        if (interaction instanceof FaucetSource.BlState) {
            bs = (FaucetSource.BlState)interaction;
            BLOCK_INTERACTIONS.add((FaucetSource.BlState)bs);
            success = true;
        }
        if (interaction instanceof FaucetSource.Tile) {
            FaucetSource.Tile ts = (FaucetSource.Tile)interaction;
            TILE_INTERACTIONS.add(ts);
            success = true;
        }
        if (interaction instanceof FaucetSource.Fluid) {
            bs = (FaucetSource.Fluid)interaction;
            SOURCE_FLUID_INTERACTIONS.add((FaucetSource.Fluid)bs);
            success = true;
        }
        if (interaction instanceof FaucetTarget.BlState) {
            FaucetTarget.BlState tb = (FaucetTarget.BlState)interaction;
            TARGET_BLOCK_INTERACTIONS.add(tb);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Tile) {
            FaucetTarget.Tile tt = (FaucetTarget.Tile)interaction;
            TARGET_TILE_INTERACTIONS.add(tt);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Fluid) {
            FaucetTarget.Fluid tf = (FaucetTarget.Fluid)interaction;
            TARGET_FLUID_INTERACTIONS.add(tf);
            success = true;
        }
        if (interaction instanceof FaucetItemSource) {
            FaucetItemSource is = (FaucetItemSource)interaction;
            ITEM_INTERACTIONS.add(is);
            success = true;
        }
        if (!success) {
            throw new UnsupportedOperationException("Unsupported faucet interaction class: " + interaction.getClass().getSimpleName());
        }
    }

    public static void clearBehaviors() {
        BLOCK_INTERACTIONS.clear();
        TILE_INTERACTIONS.clear();
        SOURCE_FLUID_INTERACTIONS.clear();
        ITEM_INTERACTIONS.clear();
        TARGET_BLOCK_INTERACTIONS.clear();
        TARGET_TILE_INTERACTIONS.clear();
        TARGET_FLUID_INTERACTIONS.clear();
    }

    @FunctionalInterface
    public static interface FillAction {
        public int tryExecute(int var1);
    }
}

