/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.service;

import com.texelsaurus.minecraft.chameleon.config.ConfigSpec;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ChameleonConfig {
    public <T extends ChameleonConfig> T create(ConfigSpec var1);

    public void init(String var1, Type var2);

    public <T> ConfigEntry<T> define(String var1, T var2);

    public <T extends Comparable<? super T>> ConfigEntry<T> defineInRange(String var1, T var2, T var3, T var4, Class<T> var5);

    default public ConfigEntry<Integer> defineInRange(String name, int defaultValue, int min, int max) {
        return this.defineInRange(name, defaultValue, min, max, (Class)Integer.class);
    }

    public <T extends Enum<T>> ConfigEntry<T> defineEnum(String var1, T var2);

    public void pushGroup(String var1);

    public void popGroup();

    public static abstract class ConfigEntry<T>
    implements Supplier<T>,
    Consumer<T> {
        protected String name;
        protected String comment;
        protected T defaultValue;
        protected T rangeMin;
        protected T rangeMax;

        public ConfigEntry<T> name(String name) {
            this.name = name;
            return this;
        }

        public ConfigEntry<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ConfigEntry<T> comment(String ... comment) {
            this.comment = String.join((CharSequence)"\n", comment);
            return this;
        }

        public ConfigEntry<T> range(T min, T max) {
            this.rangeMin = min;
            this.rangeMax = max;
            return this;
        }

        public abstract ConfigEntry<T> build();

        @Override
        public final void accept(T value) {
            this.set(value);
        }

        public abstract void set(T var1);
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER;

    }
}

