/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_785;
import net.minecraft.class_793;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3f;

public class DrawerModelGeometry {
    private static boolean geometryDataLoaded = false;

    public static void loadGeometryData() {
        if (geometryDataLoaded) {
            return;
        }
        geometryDataLoaded = true;
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, true).toArray(BlockDrawers[]::new));
    }

    private static void populateGeometryData(class_2960 locationIcon, class_2960 locationCount, class_2960 locationInd, class_2960 locationIndBase, BlockDrawers ... blocks) {
        class_793 slotInfo = DrawerModelGeometry.getBlockModel(locationIcon);
        class_793 countInfo = DrawerModelGeometry.getBlockModel(locationCount);
        class_793 indInfo = DrawerModelGeometry.getBlockModel(locationInd);
        class_793 indBaseInfo = DrawerModelGeometry.getBlockModel(locationIndBase);
        for (BlockDrawers block : blocks) {
            Vector3f to;
            Vector3f from;
            int i;
            if (block == null) continue;
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((class_785)slotInfo.method_3433().get((int)i)).field_4228;
                to = ((class_785)slotInfo.method_3433().get((int)i)).field_4231;
                block.labelGeometry[i] = new class_238((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((class_785)countInfo.method_3433().get((int)i)).field_4228;
                to = ((class_785)countInfo.method_3433().get((int)i)).field_4231;
                block.countGeometry[i] = new class_238((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((class_785)indInfo.method_3433().get((int)i)).field_4228;
                to = ((class_785)indInfo.method_3433().get((int)i)).field_4231;
                block.indGeometry[i] = new class_238((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
            for (i = 0; i < block.getDrawerCount(); ++i) {
                from = ((class_785)indBaseInfo.method_3433().get((int)i)).field_4228;
                to = ((class_785)indBaseInfo.method_3433().get((int)i)).field_4231;
                block.indBaseGeometry[i] = new class_238((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_793 getBlockModel(class_2960 location) {
        class_3298 iresource = null;
        InputStreamReader reader = null;
        try {
            iresource = class_310.method_1551().method_1478().getResourceOrThrow(location);
            reader = new InputStreamReader(iresource.method_14482(), StandardCharsets.UTF_8);
            class_793 class_7932 = class_793.method_3437((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            return class_7932;
        }
        catch (IOException e) {
            class_793 class_7933 = null;
            return class_7933;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }
}

