/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import java.util.Arrays;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class UpgradeData
extends BlockEntityDataShim {
    protected final class_1799[] upgrades;
    private int storageMultiplier;
    private EnumUpgradeRedstone redstoneType;
    private boolean hasOneStack;
    private boolean hasVoid;
    private boolean hasUnlimited;
    private boolean hasVending;
    private boolean hasConversion;
    private boolean hasIllumination;
    private boolean hasFillLevel;
    private boolean hasBalanceFill;
    private boolean hasRemote;
    private IDrawerAttributesModifiable attrs;

    public UpgradeData(int slotCount) {
        this.upgrades = new class_1799[slotCount];
        Arrays.fill(this.upgrades, class_1799.field_8037);
        this.syncStorageMultiplier();
    }

    public void setDrawerAttributes(IDrawerAttributesModifiable attrs) {
        this.attrs = attrs;
        this.syncUpgrades();
    }

    public int getSlotCount() {
        return this.upgrades.length;
    }

    @NotNull
    public class_1799 getUpgrade(int slot) {
        slot = class_3532.method_15340((int)slot, (int)0, (int)(this.upgrades.length - 1));
        return this.upgrades[slot];
    }

    public boolean hasEmptySlot() {
        return this.getNextUpgradeSlot() != -1;
    }

    public boolean addUpgrade(@NotNull class_1799 upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public boolean setUpgrade(int slot, @NotNull class_1799 upgrade) {
        class_1799 prevUpgrade;
        slot = class_3532.method_15340((int)slot, (int)0, (int)(this.upgrades.length - 1));
        if (!upgrade.method_7960()) {
            upgrade = upgrade.method_7972();
            upgrade.method_7939(1);
        }
        if (!(prevUpgrade = this.upgrades[slot]).method_7960() && !this.canRemoveUpgrade(slot)) {
            if (!(prevUpgrade.method_7909() instanceof ItemUpgradeStorage)) {
                return false;
            }
            if (!(upgrade.method_7909() instanceof ItemUpgradeStorage)) {
                return false;
            }
            ItemUpgradeStorage target = (ItemUpgradeStorage)prevUpgrade.method_7909();
            ItemUpgradeStorage source = (ItemUpgradeStorage)upgrade.method_7909();
            if (source.level.getLevel() <= target.level.getLevel()) {
                return false;
            }
        }
        this.upgrades[slot] = class_1799.field_8037;
        this.syncStorageMultiplier();
        if (!upgrade.method_7960() && !this.canAddUpgrade(upgrade)) {
            this.upgrades[slot] = prevUpgrade;
            this.syncStorageMultiplier();
            return false;
        }
        this.upgrades[slot] = upgrade;
        this.syncUpgrades();
        this.onUpgradeChanged(prevUpgrade, upgrade);
        return true;
    }

    public boolean canAddUpgrade(@NotNull class_1799 upgrade) {
        if (upgrade.method_7960()) {
            return false;
        }
        class_1799[] class_1799Array = upgrade.method_7909();
        if (!(class_1799Array instanceof ItemUpgrade)) {
            return false;
        }
        ItemUpgrade candidate = (ItemUpgrade)class_1799Array;
        if (!candidate.isEnabled()) {
            return false;
        }
        if (candidate.getAllowMultiple()) {
            return true;
        }
        for (class_1799 stack : this.upgrades) {
            class_1792 class_17922;
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof ItemUpgrade)) continue;
            ItemUpgrade reference = (ItemUpgrade)class_17922;
            if (candidate.getUpgradeGroup() != reference.getUpgradeGroup()) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveUpgrade(int slot) {
        return !this.upgrades[slot = class_3532.method_15340((int)slot, (int)0, (int)(this.upgrades.length - 1))].method_7960();
    }

    public boolean canSwapUpgrade(int slot, @NotNull class_1799 add) {
        return this.canAddUpgrade(add) && this.canRemoveUpgrade(slot);
    }

    public int getStorageMultiplier() {
        return this.storageMultiplier;
    }

    public EnumUpgradeRedstone getRedstoneType() {
        return this.redstoneType;
    }

    public boolean hasOneStackUpgrade() {
        return this.hasOneStack;
    }

    public boolean hasUnlimitedUpgrade() {
        return this.hasUnlimited;
    }

    public boolean hasVendingUpgrade() {
        return this.hasVending;
    }

    public boolean hasConversionUpgrade() {
        return this.hasConversion;
    }

    public boolean hasIlluminationUpgrade() {
        return this.hasIllumination;
    }

    public boolean hasbalancedFillUpgrade() {
        return this.hasBalanceFill;
    }

    public boolean hasRemoteUpgrade() {
        return this.hasRemote;
    }

    public boolean hasPortabilityUpgrade() {
        for (class_1799 stack : this.upgrades) {
            if (stack.method_7909() != ModItems.PORTABILITY_UPGRADE.get()) continue;
            return true;
        }
        return false;
    }

    private int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (!this.upgrades[i].method_7960()) continue;
            return i;
        }
        return -1;
    }

    public class_1799 getRemoteUpgrade() {
        if (!this.hasRemote) {
            return null;
        }
        for (class_1799 stack : this.upgrades) {
            if (!(stack.method_7909() instanceof ItemUpgradeRemote)) continue;
            return stack;
        }
        return null;
    }

    public void unbindRemoteUpgrade() {
        if (!this.hasRemote) {
            return;
        }
        for (int i = 0; i < this.upgrades.length; ++i) {
            ItemUpgradeRemote remote;
            class_1799 stack = this.upgrades[i];
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof ItemUpgradeRemote) || !(remote = (ItemUpgradeRemote)class_17922).isBound()) continue;
            this.upgrades[i] = ItemUpgradeRemote.setUnbound(stack);
            this.onUpgradeChanged(stack, this.upgrades[i]);
        }
    }

    public void updateRemoteUpgradeBinding(class_1799 refStack) {
        if (!this.hasRemote || refStack == null) {
            return;
        }
        for (int i = 0; i < this.upgrades.length; ++i) {
            class_1799 stack = this.upgrades[i];
            if (!(stack.method_7909() instanceof ItemUpgradeRemote)) continue;
            this.upgrades[i] = ItemUpgradeRemote.copyControllerBinding(refStack, this.upgrades[i]);
            this.onUpgradeChanged(stack, this.upgrades[i]);
        }
    }

    private void syncUpgrades() {
        if (this.attrs == null) {
            return;
        }
        this.syncStorageMultiplier();
        this.syncRedstoneLevel();
        this.hasOneStack = false;
        this.hasVoid = false;
        this.hasUnlimited = false;
        this.hasVending = false;
        this.hasConversion = false;
        this.hasIllumination = false;
        this.hasFillLevel = false;
        this.hasBalanceFill = false;
        this.hasRemote = false;
        for (class_1799 stack : this.upgrades) {
            class_1792 item = stack.method_7909();
            if (item == ModItems.ONE_STACK_UPGRADE.get()) {
                this.hasOneStack = true;
                continue;
            }
            if (item == ModItems.VOID_UPGRADE.get()) {
                this.hasVoid = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableVoidUpgrade.get();
                continue;
            }
            if (item == ModItems.CREATIVE_STORAGE_UPGRADE.get()) {
                this.hasUnlimited = true;
                continue;
            }
            if (item == ModItems.CREATIVE_VENDING_UPGRADE.get()) {
                this.hasVending = true;
                continue;
            }
            if (item == ModItems.ILLUMINATION_UPGRADE.get()) {
                this.hasIllumination = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableIlluminationUpgrade.get();
                continue;
            }
            if (item == ModItems.FILL_LEVEL_UPGRADE.get()) {
                this.hasFillLevel = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableFillLevelUpgrade.get();
                continue;
            }
            if (item == ModItems.BALANCE_FILL_UPGRADE.get()) {
                this.hasBalanceFill = (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableBalanceUpgrade.get();
                continue;
            }
            if (!(item instanceof ItemUpgradeRemote)) continue;
            ItemUpgradeRemote remote = (ItemUpgradeRemote)item;
            this.hasRemote = remote.isGroupUpgrade() ? (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteGroupUpgrade.get() : (Boolean)ModCommonConfig.INSTANCE.UPGRADES.enableRemoteUpgrade.get();
        }
        this.attrs.setIsVoid(this.hasVoid);
        this.attrs.setHasFillLevel(this.hasFillLevel);
        this.attrs.setIsDictConvertible(this.hasConversion);
        this.attrs.setIsUnlimitedStorage(this.hasUnlimited);
        this.attrs.setIsUnlimitedVending(this.hasVending);
        this.attrs.setIsBalancedFill(this.hasBalanceFill);
    }

    private void syncStorageMultiplier() {
        this.storageMultiplier = 0;
        for (class_1799 stack : this.upgrades) {
            if (!(stack.method_7909() instanceof ItemUpgradeStorage)) continue;
            int level = ((ItemUpgradeStorage)stack.method_7909()).level.getLevel();
            this.storageMultiplier += ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(level);
        }
        if (this.storageMultiplier == 0) {
            this.storageMultiplier = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(0);
        }
    }

    private void syncRedstoneLevel() {
        this.redstoneType = null;
        for (class_1799 stack : this.upgrades) {
            if (!(stack.method_7909() instanceof ItemUpgradeRedstone)) continue;
            this.redstoneType = ((ItemUpgradeRedstone)stack.method_7909()).type;
            break;
        }
    }

    @Override
    public void read(class_2487 tag) {
        Arrays.fill(this.upgrades, class_1799.field_8037);
        if (!tag.method_10545("Upgrades")) {
            return;
        }
        class_2499 tagList = tag.method_10554("Upgrades", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 upgradeTag = tagList.method_10602(i);
            byte slot = upgradeTag.method_10571("Slot");
            this.upgrades[slot] = class_1799.method_7915((class_2487)upgradeTag);
        }
        this.syncUpgrades();
    }

    @Override
    public class_2487 write(class_2487 tag) {
        class_2499 tagList = new class_2499();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i].method_7960()) continue;
            class_2487 upgradeTag = this.upgrades[i].method_7953(new class_2487());
            upgradeTag.method_10567("Slot", (byte)i);
            tagList.add((Object)upgradeTag);
        }
        tag.method_10566("Upgrades", (class_2520)tagList);
        return tag;
    }

    protected void onUpgradeChanged(class_1799 oldUpgrade, class_1799 newUpgrade) {
    }
}

