/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.mixin.client.render.ModelPredicateProviderRegistryAccessor;

public class ModelPredicateHelper {
    public static void injectBowSkillUsePredicate(class_1792 item) {
        Map<class_1792, Map<class_2960, class_1800>> itemSpecificPredicates = ModelPredicateProviderRegistryAccessor.itemSpecificPredicates_SpellEngine();
        if (itemSpecificPredicates == null || itemSpecificPredicates.isEmpty()) {
            System.err.println("Spell Engine: Failed to inject vanilla model predicates.");
            return;
        }
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, new class_2960("pull"), (stack, world, entity, seed) -> {
            SpellCast.Progress progress = ModelPredicateHelper.getItemStackRangedSkillProgress(stack, entity);
            if (progress != null) {
                return progress.ratio();
            }
            return -1.0f;
        });
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, new class_2960("pulling"), (stack, world, entity, seed) -> {
            if (ModelPredicateHelper.isItemStackUsedForRangedSkill(stack, entity)) {
                return 1.0f;
            }
            return -1.0f;
        });
    }

    public static void injectCrossBowSkillUsePredicate(class_1792 item) {
        Map<class_1792, Map<class_2960, class_1800>> itemSpecificPredicates = ModelPredicateProviderRegistryAccessor.itemSpecificPredicates_SpellEngine();
        if (itemSpecificPredicates == null || itemSpecificPredicates.isEmpty()) {
            System.err.println("Spell Engine: Failed to inject vanilla model predicates.");
            return;
        }
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, new class_2960("pull"), (stack, world, entity, seed) -> {
            SpellCast.Progress progress = ModelPredicateHelper.getItemStackRangedSkillProgress(stack, entity);
            if (progress != null) {
                return progress.ratio();
            }
            return -1.0f;
        });
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, new class_2960("pulling"), (stack, world, entity, seed) -> {
            if (ModelPredicateHelper.isItemStackUsedForRangedSkill(stack, entity)) {
                return 1.0f;
            }
            return -1.0f;
        });
        ModelPredicateHelper.injectModelPredicate(itemSpecificPredicates, item, new class_2960("charged"), (stack, world, entity, seed) -> {
            SpellCast.Progress progress = ModelPredicateHelper.getItemStackRangedSkillProgress(stack, entity);
            if (progress != null && progress.ratio() > 0.94f) {
                return 1.0f;
            }
            return -1.0f;
        });
    }

    private static void injectModelPredicate(Map<class_1792, Map<class_2960, class_1800>> all, class_1792 item, class_2960 id, class_1800 customPredicate) {
        Map<class_2960, class_1800> itemSpecific = all.get(item);
        if (itemSpecific == null) {
            return;
        }
        class_1800 existingPredicate = itemSpecific.get(id);
        class_5272.method_27879((class_1792)item, (class_2960)id, (stack, world, entity, seed) -> {
            float result;
            if (customPredicate != null && (result = customPredicate.call(stack, world, entity, seed)) >= 0.0f) {
                return result;
            }
            return existingPredicate.call(stack, world, entity, seed);
        });
    }

    private static SpellCast.Progress getItemStackRangedSkillProgress(class_1799 itemStack, class_1309 entity) {
        if (entity instanceof SpellCasterEntity) {
            SpellCast.Process process;
            SpellCasterEntity caster = (SpellCasterEntity)entity;
            if (entity.method_6047() == itemStack && (process = caster.getSpellCastProcess()) != null && process.spell().cast.animates_ranged_weapon) {
                return process.progress(entity.method_37908().method_8510());
            }
        }
        return null;
    }

    private static boolean isItemStackUsedForRangedSkill(class_1799 itemStack, class_1309 entity) {
        if (entity instanceof SpellCasterEntity) {
            SpellCast.Process process;
            SpellCasterEntity caster = (SpellCasterEntity)entity;
            if (entity.method_6047() == itemStack && (process = caster.getSpellCastProcess()) != null && process.spell().cast.animates_ranged_weapon) {
                return true;
            }
        }
        return false;
    }
}

