/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.feeding;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4174;
import net.minecraft.class_5575;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FeedingUpgradeWrapper
extends UpgradeWrapperBase<FeedingUpgradeWrapper, FeedingUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final int COOLDOWN = 100;
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    private static final int FEEDING_RANGE = 3;
    private final FilterLogic filterLogic;

    public FeedingUpgradeWrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((FeedingUpgradeItem)this.upgradeItem).getFilterSlotCount(), class_1799::method_19267);
    }

    @Override
    public void tick(@Nullable class_1309 entity, class_1937 level, class_2338 pos) {
        if (this.isInCooldown(level) || entity != null && !(entity instanceof class_1657)) {
            return;
        }
        boolean hungryPlayer = false;
        if (entity == null) {
            AtomicBoolean stillHungryPlayer = new AtomicBoolean(false);
            level.method_18023((class_5575)class_1299.field_6097, new class_238(pos).method_1014(3.0), p -> true).forEach(p -> stillHungryPlayer.set(stillHungryPlayer.get() || this.feedPlayerAndGetHungry((class_1657)p, level)));
            hungryPlayer = stillHungryPlayer.get();
        } else if (this.feedPlayerAndGetHungry((class_1657)entity, level)) {
            hungryPlayer = true;
        }
        if (hungryPlayer) {
            this.setCooldown(level, 10);
            return;
        }
        this.setCooldown(level, 100);
    }

    private boolean feedPlayerAndGetHungry(class_1657 player, class_1937 level) {
        int hungerLevel = 20 - player.method_7344().method_7586();
        if (hungerLevel == 0) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.method_7344().method_7586() < 20;
    }

    private boolean tryFeedingFoodFromStorage(class_1937 level, int hungerLevel, class_1657 player) {
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        return InventoryHelper.iterate(inventory, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (class_1799)stack, inventory), () -> false, ret -> ret);
    }

    private boolean tryFeedingStack(class_1937 level, int hungerLevel, class_1657 player, Integer slot, class_1799 stack, ITrackedContentsItemHandler inventory) {
        boolean isHurt;
        boolean bl = isHurt = player.method_6032() < player.method_6063() - 0.1f;
        if (FeedingUpgradeWrapper.isEdible(stack) && this.filterLogic.matchesFilter(stack) && (this.isHungryEnoughForFood(hungerLevel, stack) || this.shouldFeedImmediatelyWhenHurt() && hungerLevel > 0 && isHurt)) {
            class_1799 mainHandItem = player.method_6047();
            player.method_6122(class_1268.field_5808, stack);
            class_1799 singleItemCopy = stack.method_7972();
            singleItemCopy.method_7939(1);
            if (singleItemCopy.method_7913(level, player, class_1268.field_5808).method_5467() == class_1269.field_21466) {
                player.method_6122(class_1268.field_5808, mainHandItem);
                stack.method_7934(1);
                inventory.setStackInSlot(slot, stack);
                class_1271 result = ((UseItemCallback)UseItemCallback.EVENT.invoker()).interact(player, level, class_1268.field_5808);
                class_1799 resultItem = (class_1799)result.method_5466();
                if (result.method_5467() == class_1269.field_5811) {
                    resultItem = singleItemCopy.method_7909().method_7861(singleItemCopy, level, (class_1309)player);
                }
                if (!resultItem.method_7960()) {
                    long inserted;
                    try (Transaction ctx = Transaction.openOuter();){
                        inserted = inventory.insert(ItemVariant.of((class_1799)resultItem), resultItem.method_7947(), (TransactionContext)ctx);
                        ctx.commit();
                    }
                    class_1799 insertResult = resultItem.method_46651(resultItem.method_7947() - (int)inserted);
                    if (!insertResult.method_7960()) {
                        InventoryHelper.insertOrDropItem(player, insertResult, new Storage[]{inventory, PlayerInventoryStorage.of((class_1657)player)});
                    }
                }
                return true;
            }
            player.method_6122(class_1268.field_5808, mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(class_1799 stack) {
        if (!stack.method_19267()) {
            return false;
        }
        class_4174 foodProperties = stack.method_7909().method_19264();
        return foodProperties != null && foodProperties.method_19230() >= 1;
    }

    private boolean isHungryEnoughForFood(int hungerLevel, class_1799 stack) {
        class_4174 foodProperties = stack.method_7909().method_19264();
        if (foodProperties == null) {
            return false;
        }
        HungerLevel feedAtHungerLevel = this.getFeedAtHungerLevel();
        if (feedAtHungerLevel == HungerLevel.ANY) {
            return true;
        }
        int nutrition = foodProperties.method_19230();
        return (feedAtHungerLevel == HungerLevel.HALF ? nutrition / 2 : nutrition) <= hungerLevel;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public HungerLevel getFeedAtHungerLevel() {
        return NBTHelper.getEnumConstant(this.upgrade, "feedAtHungerLevel", HungerLevel::fromName).orElse(HungerLevel.HALF);
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        NBTHelper.setEnumConstant(this.upgrade, "feedAtHungerLevel", hungerLevel);
        this.save();
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return NBTHelper.getBoolean(this.upgrade, "feedImmediatelyWhenHurt").orElse(true);
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        NBTHelper.setBoolean(this.upgrade, "feedImmediatelyWhenHurt", feedImmediatelyWhenHurt);
        this.save();
    }
}

