/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.p3pp3rf1y.sophisticatedcore.crafting.ItemEnabledCondition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public class ShapelessBasedRecipeBuilder
implements class_5797 {
    private final class_1792 result;
    @Nullable
    private final class_2487 nbt;
    private final int count;
    private final List<class_1856> ingredients = Lists.newArrayList();
    private final class_161.class_162 advancement = class_161.class_162.method_707();
    private final List<ConditionJsonProvider> conditions = new ArrayList<ConditionJsonProvider>();
    @Nullable
    private String group;
    private final class_1865<?> serializer;

    public ShapelessBasedRecipeBuilder(class_1935 result, int count, @Nullable class_2487 nbt, class_1865<?> serializer) {
        this.result = result.method_8389();
        this.count = count;
        this.nbt = nbt;
        this.serializer = serializer;
    }

    public static ShapelessBasedRecipeBuilder shapeless(class_1935 result) {
        return ShapelessBasedRecipeBuilder.shapeless(result, 1, class_1865.field_9031);
    }

    public static ShapelessBasedRecipeBuilder shapeless(class_1935 result, class_1865<?> serializer) {
        return ShapelessBasedRecipeBuilder.shapeless(result, 1, serializer);
    }

    public static ShapelessBasedRecipeBuilder shapeless(class_1935 result, int count) {
        return new ShapelessBasedRecipeBuilder(result, count, null, class_1865.field_9031);
    }

    public static ShapelessBasedRecipeBuilder shapeless(class_1935 result, int count, class_1865<?> serializer) {
        return new ShapelessBasedRecipeBuilder(result, count, null, serializer);
    }

    public static ShapelessBasedRecipeBuilder shapeless(class_1799 stack) {
        return new ShapelessBasedRecipeBuilder((class_1935)stack.method_7909(), 1, stack.method_7969(), class_1865.field_9031);
    }

    public ShapelessBasedRecipeBuilder condition(ConditionJsonProvider condition) {
        this.conditions.add(condition);
        return this;
    }

    public ShapelessBasedRecipeBuilder requires(class_6862<class_1792> tag) {
        return this.requires(class_1856.method_8106(tag));
    }

    public ShapelessBasedRecipeBuilder requires(class_1935 item) {
        return this.requires(item, 1);
    }

    public ShapelessBasedRecipeBuilder requires(class_1935 item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }
        return this;
    }

    public ShapelessBasedRecipeBuilder requires(class_1856 ingredient) {
        return this.requires(ingredient, 1);
    }

    public ShapelessBasedRecipeBuilder requires(class_1856 ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ShapelessBasedRecipeBuilder unlockedBy(String criterionName, class_184 criterionTrigger) {
        this.advancement.method_709(criterionName, criterionTrigger);
        return this;
    }

    public ShapelessBasedRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(Consumer<class_2444> finishedRecipeConsumer, class_2960 recipeId) {
        this.advancement.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_193.field_1257);
        finishedRecipeConsumer.accept(new Result(recipeId, this.result, this.conditions, this.nbt, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancement, new class_2960(recipeId.method_12836(), "recipes/" + class_7800.field_40642.method_46203() + "/" + recipeId.method_12832()), this.serializer));
    }

    public static class Result
    implements class_2444 {
        private final List<ConditionJsonProvider> conditions;
        private final class_2960 id;
        private final class_1792 itemResult;
        @Nullable
        private final class_2487 nbt;
        private final int count;
        private final String group;
        private final List<class_1856> ingredients;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private class_1865<?> serializer;

        public Result(class_2960 id, class_1792 itemResult, List<ConditionJsonProvider> conditions, @Nullable class_2487 nbt, int count, String group, List<class_1856> ingredients, class_161.class_162 advancement, class_2960 advancementId, class_1865<?> serializer) {
            this.id = id;
            this.itemResult = itemResult;
            this.conditions = conditions;
            this.nbt = nbt;
            this.count = count;
            this.group = group;
            this.ingredients = ingredients;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.serializer = serializer;
            conditions.add(new ItemEnabledCondition(this.itemResult));
        }

        public void method_10416(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray conditionsArray = new JsonArray();
            this.conditions.forEach(c -> conditionsArray.add((JsonElement)c.toJson()));
            json.add("conditions", (JsonElement)conditionsArray);
            JsonArray jsonarray = new JsonArray();
            for (class_1856 ingredient : this.ingredients) {
                jsonarray.add(ingredient.method_8089());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", RegistryHelper.getItemKey(this.itemResult).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            if (this.nbt != null) {
                jsonobject.addProperty("nbt", this.nbt.toString());
            }
            json.add("result", (JsonElement)jsonobject);
        }

        public class_1865<?> method_17800() {
            return this.serializer;
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

