/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AtomicDouble;
import io.github.fabricators_of_create.porting_lib.extensions.extensions.IShearable;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4481;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEntityToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.mixin.common.accessor.ItemAccessor;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.SwordRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ToolSwapperUpgradeWrapper
extends UpgradeWrapperBase<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeItem>
implements IBlockClickResponseUpgrade,
IAttackEntityResponseUpgrade,
IBlockToolSwapUpgrade,
IEntityToolSwapUpgrade {
    private static final LoadingCache<class_1799, Boolean> isToolCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<class_1799, Boolean>(){

        public Boolean load(class_1799 key) {
            return ToolSwapperUpgradeWrapper.canPerformToolAction(key);
        }
    });
    private final FilterLogic filterLogic;
    @Nullable
    private class_2960 toolCacheFor = null;
    private final Queue<class_1799> toolCache = new LinkedList<class_1799>();
    private class_2248 lastMinedBlock = class_2246.field_10124;
    private static final Set<ToolAction> BLOCK_MODIFICATION_ACTIONS = Set.of(ToolActions.AXE_STRIP, ToolActions.AXE_SCRAPE, ToolActions.AXE_WAX_OFF, ToolActions.SHOVEL_FLATTEN, ToolActions.SHEARS_CARVE, ToolActions.SHEARS_HARVEST);

    protected ToolSwapperUpgradeWrapper(IStorageWrapper backpackWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((Integer)Config.SERVER.toolSwapperUpgrade.filterSlots.get()).intValue());
    }

    @Override
    public boolean onBlockClick(class_1657 player, class_2338 pos) {
        ToolSwapMode toolSwapMode = this.getToolSwapMode();
        if (player.method_7337() || player.method_7325() || toolSwapMode == ToolSwapMode.NO_SWAP) {
            return false;
        }
        class_1799 mainHandItem = player.method_6047();
        if (mainHandItem.method_7909() instanceof BackpackItem || toolSwapMode == ToolSwapMode.ONLY_TOOLS && this.isSword(mainHandItem, player) || !this.isSword(mainHandItem, player) && this.isNotTool(mainHandItem) || !this.filterLogic.matchesFilter(mainHandItem)) {
            return false;
        }
        class_2680 state = player.method_37908().method_8320(pos);
        class_2248 block = state.method_26204();
        double mainToolSpeed = 0.0;
        if (this.isGoodAtBreakingBlock(state, mainHandItem)) {
            if (this.lastMinedBlock == block) {
                return true;
            }
            mainToolSpeed = mainHandItem.method_7924(state);
        }
        this.lastMinedBlock = block;
        return this.tryToSwapTool(player, state, mainToolSpeed, mainHandItem);
    }

    private boolean tryToSwapTool(class_1657 player, class_2680 state, double mainHandItemSpeed, class_1799 mainHandItem) {
        AtomicReference<class_1799> selectedTool = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicInteger selectedSlot = new AtomicInteger(-1);
        AtomicDouble bestSpeed = new AtomicDouble(mainHandItemSpeed);
        InventoryHandler backpackInventory = this.storageWrapper.getInventoryHandler();
        InventoryHelper.iterate((SlottedStorage)backpackInventory, (slot, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            if (this.isAllowedAndGoodAtBreakingBlock(state, (class_1799)stack)) {
                float destroySpeed = stack.method_7924(state);
                if (bestSpeed.get() < (double)destroySpeed) {
                    bestSpeed.set((double)destroySpeed);
                    selectedSlot.set((int)slot);
                    selectedTool.set((class_1799)stack);
                }
            }
        });
        ItemVariant mainHandItemResource = ItemVariant.of((class_1799)mainHandItem);
        class_1799 tool = selectedTool.get();
        if (!tool.method_7960() && this.hasSpaceInBackpackOrCanPlaceInTheSlotOfSwappedTool((IItemHandlerSimpleInserter)backpackInventory, mainHandItemResource, mainHandItem.method_7947(), tool, selectedSlot.get())) {
            try (Transaction ctx = Transaction.openOuter();){
                ItemVariant resource = ItemVariant.of((class_1799)tool);
                player.method_6122(class_1268.field_5808, resource.toStack((int)backpackInventory.extractSlot(selectedSlot.get(), resource, 1L, (TransactionContext)ctx)));
                ctx.commit();
            }
            ctx = Transaction.openOuter();
            try {
                backpackInventory.insert((Object)ItemVariant.of((class_1799)mainHandItem), (long)mainHandItem.method_7947(), (TransactionContext)ctx);
                ctx.commit();
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
            return true;
        }
        return false;
    }

    private boolean hasSpaceInBackpackOrCanPlaceInTheSlotOfSwappedTool(IItemHandlerSimpleInserter backpackInventory, ItemVariant mainHandItem, int mainHandItemCount, class_1799 tool, int selectedSlot) {
        return StorageUtil.simulateInsert((Storage)backpackInventory, (Object)mainHandItem, (long)mainHandItemCount, null) == (long)mainHandItemCount || tool.method_7947() == 1 && backpackInventory.isItemValid(selectedSlot, mainHandItem, mainHandItemCount);
    }

    private boolean isAllowedAndGoodAtBreakingBlock(class_2680 state, class_1799 stack) {
        return this.filterLogic.matchesFilter(stack) && this.isGoodAtBreakingBlock(state, stack);
    }

    private boolean isGoodAtBreakingBlock(class_2680 state, class_1799 stack) {
        return stack.method_7951(state) && (double)stack.method_7924(state) > 1.5;
    }

    @Override
    public boolean onAttackEntity(class_1657 player) {
        if (!this.shouldSwapWeapon()) {
            return false;
        }
        class_1799 mainHandItem = player.method_6047();
        if (this.isSword(mainHandItem, player)) {
            return true;
        }
        if (mainHandItem.method_7909() instanceof BackpackItem || this.isNotTool(mainHandItem) || !this.filterLogic.matchesFilter(mainHandItem)) {
            return false;
        }
        return this.tryToSwapInWeapon(player, mainHandItem);
    }

    private boolean isNotTool(class_1799 stack) {
        return (Boolean)isToolCache.getUnchecked((Object)stack) == false;
    }

    private static boolean canPerformToolAction(class_1799 stack) {
        return ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_AXE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_HOE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_PICKAXE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_SHOVEL_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ToolActions.DEFAULT_SHEARS_ACTIONS);
    }

    private static boolean canPerformAnyAction(class_1799 stack, Set<ToolAction> toolActions) {
        for (ToolAction toolAction : toolActions) {
            if (!stack.canPerformAction(toolAction)) continue;
            return true;
        }
        return false;
    }

    private boolean isSword(class_1799 stack, class_1657 player) {
        if (SwordRegistry.isSword(stack)) {
            return true;
        }
        class_1324 attackDamage = player.method_5996(class_5134.field_23721);
        if (!stack.method_7960() && stack.canPerformAction(ToolActions.SWORD_SWEEP)) {
            return attackDamage != null && attackDamage.method_6199(ItemAccessor.getBaseAttackDamageUUID()) != null;
        }
        return false;
    }

    private boolean tryToSwapInWeapon(class_1657 player, class_1799 mainHandItem) {
        AtomicReference<class_1799> bestAxe = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicDouble bestAxeDamage = new AtomicDouble(0.0);
        AtomicReference<class_1799> bestSword = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicDouble bestSwordDamage = new AtomicDouble(0.0);
        this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, mainHandItem);
        ITrackedContentsItemHandler backpackInventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        InventoryHelper.iterate((SlottedStorage)backpackInventory, (slot, stack) -> {
            if (this.filterLogic.matchesFilter(stack)) {
                this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, (class_1799)stack);
            }
        });
        if (!bestSword.get().method_7960()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerSimpleInserter)backpackInventory, bestSword.get());
        }
        if (!bestAxe.get().method_7960()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerSimpleInserter)backpackInventory, bestAxe.get());
        }
        return false;
    }

    private void updateBestWeapons(AtomicReference<class_1799> bestAxe, AtomicDouble bestAxeDamage, AtomicReference<class_1799> bestSword, AtomicDouble bestSwordDamage, class_1799 stack) {
        class_1324 attribute = new class_1324(class_5134.field_23721, a -> {});
        Multimap attributeModifiers = stack.method_7926(class_1304.field_6173);
        if (!attributeModifiers.containsKey((Object)class_5134.field_23721)) {
            return;
        }
        attributeModifiers.get((Object)class_5134.field_23721).forEach(m -> {
            attribute.method_6202(m);
            attribute.method_26835(m);
        });
        double damageValue = attribute.method_6194();
        if (stack.canPerformAction(ToolActions.AXE_DIG)) {
            if (damageValue > bestAxeDamage.get()) {
                bestAxe.set(stack);
                bestAxeDamage.set(damageValue);
            }
        } else if ((SwordRegistry.isSword(stack) || stack.canPerformAction(ToolActions.SWORD_SWEEP)) && damageValue > bestSwordDamage.get()) {
            bestSword.set(stack);
            bestSwordDamage.set(damageValue);
        }
    }

    private boolean swapWeapon(class_1657 player, class_1799 mainHandItem, IItemHandlerSimpleInserter backpackInventory, class_1799 sword) {
        if (sword == mainHandItem) {
            return true;
        }
        class_1799 swordCopy = sword.method_7972();
        swordCopy.method_7939(1);
        InventoryHelper.extractFromInventory((class_1799)swordCopy, (SlottedStackStorage)backpackInventory, null);
        if (StorageUtil.simulateInsert((Storage)backpackInventory, (Object)ItemVariant.of((class_1799)mainHandItem), (long)mainHandItem.method_7947(), null) == (long)mainHandItem.method_7947()) {
            player.method_6122(class_1268.field_5808, swordCopy);
            try (Transaction ctx = Transaction.openOuter();){
                backpackInventory.insert((Object)ItemVariant.of((class_1799)mainHandItem), (long)mainHandItem.method_7947(), (TransactionContext)ctx);
                ctx.commit();
            }
            return true;
        }
        try (Transaction ctx = Transaction.openOuter();){
            backpackInventory.insert((Object)ItemVariant.of((class_1799)swordCopy), (long)swordCopy.method_7947(), (TransactionContext)ctx);
            ctx.commit();
        }
        return false;
    }

    public boolean hideSettingsTab() {
        return !((ToolSwapperUpgradeItem)this.upgradeItem).hasSettingsTab();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldSwapWeapon() {
        return NBTHelper.getBoolean((class_1799)this.upgrade, (String)"shouldSwapWeapon").orElse(true);
    }

    public void setSwapWeapon(boolean shouldSwapWeapon) {
        NBTHelper.setBoolean((class_1799)this.upgrade, (String)"shouldSwapWeapon", (boolean)shouldSwapWeapon);
        this.save();
    }

    public ToolSwapMode getToolSwapMode() {
        return NBTHelper.getEnumConstant((class_1799)this.upgrade, (String)"toolSwapMode", ToolSwapMode::fromName).orElse(ToolSwapMode.ANY);
    }

    public void setToolSwapMode(ToolSwapMode toolSwapMode) {
        NBTHelper.setEnumConstant((class_1799)this.upgrade, (String)"toolSwapMode", (Enum)toolSwapMode);
        this.save();
    }

    @Override
    public boolean onEntityInteract(class_1937 world, class_1297 entity, class_1657 player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnEntity((class_1799)stack, entity), class_7923.field_41177.method_10221((Object)entity.method_5864()));
    }

    private boolean itemWorksOnEntity(class_1799 stack, class_1297 entity) {
        if (this.isShearableEntity(entity, stack) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForEntity(stack, entity);
    }

    @Override
    public boolean onBlockInteract(class_1937 world, class_2338 pos, class_2680 blockState, class_1657 player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnBlock(world, pos, blockState, player, (class_1799)stack), class_7923.field_41175.method_10221((Object)blockState.method_26204()));
    }

    private boolean tryToSwapTool(class_1657 player, Predicate<class_1799> isToolValid, @Nullable class_2960 targetRegistryName) {
        class_1799 tool;
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_7909() instanceof BackpackItem) {
            return false;
        }
        if (this.toolCacheFor == null || !this.toolCacheFor.equals((Object)targetRegistryName)) {
            this.toolCache.clear();
            this.toolCacheFor = targetRegistryName;
        }
        boolean itemInHandIsValid = isToolValid.test(mainHandStack);
        ITrackedContentsItemHandler backpackInventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        if (itemInHandIsValid && this.toolCache.stream().noneMatch(st -> class_1799.method_7984((class_1799)st, (class_1799)mainHandStack))) {
            this.toolCache.offer(mainHandStack);
        }
        if ((tool = this.findToolToSwap((IItemHandlerSimpleInserter)backpackInventory, isToolValid)).method_7960()) {
            return false;
        }
        tool = tool.method_7972().method_7971(1);
        try (Transaction ctx = Transaction.openOuter();){
            long inserted = backpackInventory.insert((Object)ItemVariant.of((class_1799)mainHandStack), (long)mainHandStack.method_7947(), (TransactionContext)ctx);
            if (tool.method_7947() == 1 || inserted == 0L) {
                ItemVariant resource = ItemVariant.of((class_1799)tool);
                long extracted = backpackInventory.extract((Object)resource, (long)tool.method_7947(), (TransactionContext)ctx);
                player.method_6122(class_1268.field_5808, resource.toStack((int)extracted));
                this.toolCache.offer(tool);
                ctx.commit();
            }
        }
        return true;
    }

    private class_1799 findToolToSwap(IItemHandlerSimpleInserter backpackInventory, Predicate<class_1799> isValidTool) {
        HashSet<class_1799> alreadyGivenBefore = new HashSet<class_1799>();
        AtomicReference<class_1799> toolFound = new AtomicReference<class_1799>(class_1799.field_8037);
        InventoryHelper.iterate((SlottedStorage)backpackInventory, (slot, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            if (!this.hasEquivalentItem((Collection<class_1799>)this.toolCache, (class_1799)stack)) {
                if (isValidTool.test((class_1799)stack)) {
                    toolFound.set((class_1799)stack);
                }
            } else {
                alreadyGivenBefore.add((class_1799)stack);
            }
        }, () -> !((class_1799)toolFound.get()).method_7960());
        if (toolFound.get().method_7960() && !alreadyGivenBefore.isEmpty()) {
            while (this.toolCache.peek() != null) {
                class_1799 itemStack = this.toolCache.poll();
                if (!this.hasEquivalentItem(alreadyGivenBefore, itemStack)) continue;
                toolFound.set(itemStack);
                break;
            }
        }
        return toolFound.get();
    }

    private boolean hasEquivalentItem(Collection<class_1799> alreadyGivenBefore, class_1799 stack) {
        for (class_1799 givenTool : alreadyGivenBefore) {
            if (!class_1799.method_7984((class_1799)givenTool, (class_1799)stack)) continue;
            return true;
        }
        return false;
    }

    private boolean itemWorksOnBlock(class_1937 level, class_2338 pos, class_2680 blockState, class_1657 player, class_1799 stack) {
        for (ToolAction action : BLOCK_MODIFICATION_ACTIONS) {
            if (!stack.canPerformAction(action) || blockState.getToolModifiedState(new class_1838(level, player, class_1268.field_5808, stack, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11036, pos, true)), action, true) == null) continue;
            return true;
        }
        class_2248 block = blockState.method_26204();
        if (this.isShearInteractionBlock(level, pos, stack, block) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForBlock(stack, block, level, blockState, pos);
    }

    private boolean isShearsItem(class_1799 stack) {
        return stack.method_7909() instanceof class_1820 || stack.method_31573(ConventionalItemTags.SHEARS);
    }

    private boolean isShearInteractionBlock(class_1937 world, class_2338 pos, class_1799 stack, class_2248 block) {
        IShearable shearable;
        return block instanceof IShearable && (shearable = (IShearable)block).isShearable(stack, world, pos) || block instanceof class_4481;
    }

    private boolean isShearableEntity(class_1297 entity, class_1799 stack) {
        IShearable shearable;
        return entity instanceof IShearable && (shearable = (IShearable)entity).isShearable(stack, entity.method_37908(), entity.method_24515());
    }

    @Override
    public boolean canProcessBlockInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }

    @Override
    public boolean canProcessEntityInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }
}

