/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;

public class SoundHelper {
    private static final Map<ResourceLocation, ScheduledExecutorService> soundSchedulers = new ConcurrentHashMap<ResourceLocation, ScheduledExecutorService>();

    public static void loopSound(LivingEntity entity, ResourceLocation soundId, int soundDurationSeconds) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)entity.m_9236_();
        SoundEvent soundEvent = (SoundEvent)SoundRegistry.SOUND.getRegistrar().get(soundId);
        if (soundSchedulers.containsKey(soundId)) {
            return;
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        soundSchedulers.put(soundId, scheduler);
        scheduler.scheduleAtFixedRate(() -> {
            if (entity.m_6084_() && entity.m_21023_((MobEffect)EffectRegistry.ELEMENTAL_VORTEX.get())) {
                SoundHelper.playSound(serverWorld, entity, soundEvent);
            } else {
                SoundHelper.stopLoopingSound(entity, soundId);
            }
        }, 0L, soundDurationSeconds, TimeUnit.SECONDS);
    }

    private static void playSound(ServerLevel serverWorld, LivingEntity entity, SoundEvent soundEvent) {
        serverWorld.m_5594_(null, entity.m_20183_(), soundEvent, entity.m_5720_(), 1.0f, 1.0f);
    }

    public static void stopLoopingSound(LivingEntity entity, ResourceLocation soundId) {
        ScheduledExecutorService scheduler = soundSchedulers.remove(soundId);
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
    }
}

