/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FlameSeedEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public FlameSeedEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.f_123783_);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        int duration = 0;
        if (!livingEntity.m_9236_().m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.m_9236_();
            float abilityDamage = Config.getFloat("emberstormDamage", "UniqueEffects", ConfigDefaultValues.emberstormDamage);
            float volume = 0.3f;
            float pitch = 1.3f;
            int frequency = 20;
            SoundEvent soundEvent = SoundEvents.f_11909_;
            MobEffectInstance mobEffectInstance = livingEntity.m_21124_((MobEffect)EffectRegistry.FLAMESEED.get());
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
                duration = statusEffect.m_19557_();
            }
            if (livingEntity.f_19797_ % frequency == 0 && this.additionalData != 0) {
                Object object;
                DamageSource damageSource = livingEntity.m_269291_().m_269425_();
                livingEntity.f_19802_ = 0;
                if (duration < 20 && this.sourceEntity != null) {
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123756_, 1.0, 8);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123778_, 2.0, 6);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123759_, 1.0, 10);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123813_, 0.5, 2);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123785_, 1.0, 10);
                    abilityDamage = Config.getFloat("emberstormDetonationDamage", "UniqueEffects", ConfigDefaultValues.emberstormDetonationDamage);
                    volume = 0.6f;
                    pitch = 1.0f;
                    soundEvent = (SoundEvent)SoundRegistry.SPELL_FIRE.get();
                    if (livingEntity.m_20270_((Entity)this.sourceEntity) < 30.0f) {
                        int maxHaste = (int)Config.getFloat("emberstormMaxHaste", "UniqueEffects", ConfigDefaultValues.emberstormMaxHaste);
                        HelperMethods.incrementStatusEffect(this.sourceEntity, MobEffects.f_19598_, 120, 1, maxHaste);
                    }
                    AABB box = HelperMethods.createBox((Entity)livingEntity, 3);
                    object = serverWorld.m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_).iterator();
                    while (object.hasNext()) {
                        LivingEntity le;
                        Entity entity = (Entity)object.next();
                        if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, this.sourceEntity)) continue;
                        le.m_6469_(damageSource, abilityDamage);
                        if (le.m_21023_((MobEffect)EffectRegistry.FLAMESEED.get()) || this.additionalData <= 0) continue;
                        --this.additionalData;
                        SimplySwordsStatusEffectInstance flamSeedEffect = new SimplySwordsStatusEffectInstance((MobEffect)EffectRegistry.FLAMESEED.get(), 101, 0, false, false, true);
                        flamSeedEffect.setSourceEntity(this.sourceEntity);
                        flamSeedEffect.setAdditionalData(this.additionalData);
                        le.m_7292_((MobEffectInstance)flamSeedEffect);
                        le.m_20334_(le.m_20185_() - livingEntity.m_20185_(), 0.5, le.m_20189_() - livingEntity.m_20189_());
                    }
                }
                if (this.sourceEntity != null) {
                    damageSource = livingEntity.m_269291_().m_269104_((Entity)livingEntity, (Entity)this.sourceEntity);
                    float spellScalingModifier = Config.getFloat("emberstormSpellScaling", "UniqueEffects", ConfigDefaultValues.emberstormSpellScaling);
                    if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "fire") > abilityDamage) {
                        abilityDamage = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "fire");
                    }
                }
                if (livingEntity instanceof Player && this.sourceEntity != null && (object = this.sourceEntity) instanceof Player) {
                    Player playerSourceEntity = (Player)object;
                    damageSource = livingEntity.m_269291_().m_269075_(playerSourceEntity);
                }
                livingEntity.m_6469_(damageSource, (float)this.additionalData + (float)amplifier / 4.0f + abilityDamage);
                serverWorld.m_5594_(null, livingEntity.m_20183_(), soundEvent, livingEntity.m_5720_(), volume, pitch);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123756_, 1.0, 4);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123783_, 1.0, 6);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123762_, 1.0, 6);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    @Override
    public boolean m_6584_(int pDuration, int pAmplifier) {
        return super.m_6584_(pDuration, pAmplifier);
    }
}

