/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.items.TransceiverItem;
import com.codinglitch.simpleradio.radio.RadioChannel;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioSource;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.Vector3f;

public class RadioManager {
    private static RadioManager INSTANCE;

    public static RadioManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RadioManager();
        }
        return INSTANCE;
    }

    public static void serverTick(int tickCount) {
        if (tickCount % 20 == 0) {
            RadioManager.garbageCollect();
        }
        List<Frequency> frequencies = Frequency.getFrequencies();
        for (Frequency frequency : frequencies) {
            frequency.serverTick(tickCount);
            for (RadioListener radioListener : frequency.transmitters) {
            }
            for (RadioChannel receiver : frequency.receivers) {
                receiver.serverTick(tickCount);
            }
        }
        List<RadioListener> listeners = RadioListener.getListeners();
        for (RadioListener listener : listeners) {
            listener.serverTick(tickCount);
        }
    }

    public static void garbageCollect() {
        Frequency.garbageCollect();
        RadioListener.garbageCollect();
    }

    public void onMicPacket(MicrophonePacketEvent event) {
        class_1799 class_17992;
        VoicechatConnection senderConnection = event.getSenderConnection();
        if (senderConnection == null) {
            return;
        }
        class_3222 sender = (class_3222)senderConnection.getPlayer().getPlayer();
        class_3218 level = sender.method_51469();
        TreeMap<Float, RadioListener> qualified = new TreeMap<Float, RadioListener>();
        for (RadioListener radioListener : RadioListener.getListeners()) {
            Vector3f position;
            if (radioListener.owner != null) {
                position = radioListener.owner.method_19538().method_46409();
            } else {
                if (radioListener.location == null) continue;
                position = radioListener.location.position();
            }
            float distance = position.distanceSquared((float)sender.method_23317(), (float)sender.method_23318(), (float)sender.method_23321());
            if (distance > radioListener.range) continue;
            qualified.put(Float.valueOf(distance), radioListener);
        }
        int listenedTo = 0;
        Iterator iterator = qualified.keySet().iterator();
        while (iterator.hasNext()) {
            float distance = ((Float)iterator.next()).floatValue();
            RadioListener listener3 = (RadioListener)qualified.get(Float.valueOf(distance));
            float scale = 1.0f - distance / listener3.range;
            listener3.onData(new RadioSource(sender.method_5667(), WorldlyPosition.of(sender.method_19538().method_46409(), (class_1937)level), ((MicrophonePacket)event.getPacket()).getOpusEncodedData(), scale));
            if (++listenedTo < SimpleRadioLibrary.SERVER_CONFIG.frequency.listenerBuffer) continue;
            break;
        }
        if ((class_17992 = sender.method_6030()).method_7909() instanceof TransceiverItem) {
            class_2487 tag = class_17992.method_7948();
            Frequency frequency = Frequency.getOrCreateFrequency(tag.method_10558("frequency"), Frequency.modulationOf(tag.method_10558("modulation")));
        }
    }

    public static void transmit(RadioSource source, Frequency frequency) {
        for (RadioChannel channel : frequency.receivers) {
            if (source.owner.equals(channel.owner)) continue;
            channel.transmit(source, frequency);
        }
    }
}

