/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.radio.RadioManager;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.VolumeCategory;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class CommonRadioPlugin {
    public static String RADIOS_CATEGORY = "radios";
    public static String TRANSCEIVERS_CATEGORY = "transceivers";
    @Nullable
    public static VoicechatServerApi serverApi;
    @Nullable
    public static VolumeCategory transceivers;
    @Nullable
    public static VolumeCategory radios;
    private ExecutorService executor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("RadioMicrophoneProcessThread");
        thread.setUncaughtExceptionHandler((t, e) -> CommonSimpleRadio.error("Error in radio process thread: {}", e));
        thread.setDaemon(true);
        return thread;
    });

    public static short[] combineAudio(List<short[]> audioParts) {
        short[] result = new short[960];
        for (int i = 0; i < result.length; ++i) {
            int sample = 0;
            for (short[] audio : audioParts) {
                if (audio == null) {
                    sample += 0;
                    continue;
                }
                sample += audio[i];
            }
            result[i] = sample > Short.MAX_VALUE ? Short.MAX_VALUE : (sample < Short.MIN_VALUE ? Short.MIN_VALUE : (short)sample);
        }
        return result;
    }

    public String getPluginId() {
        return "simpleradio";
    }

    public void serverTick(int tickCount) {
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
        registration.registerEvent(MicrophonePacketEvent.class, microphonePacketEvent -> this.executor.submit(() -> RadioManager.getInstance().onMicPacket((MicrophonePacketEvent)microphonePacketEvent)));
    }

    public void onServerStarted(VoicechatServerStartedEvent event) {
        serverApi = event.getVoicechat();
        radios = serverApi.volumeCategoryBuilder().setId(RADIOS_CATEGORY).setName("Radios").setDescription("The volume of radios").setIcon(this.getIcon("radio_icon.png")).build();
        transceivers = serverApi.volumeCategoryBuilder().setId(TRANSCEIVERS_CATEGORY).setName("Transceivers").setDescription("The volume of transceivers").setIcon(this.getIcon("transceiver_icon.png")).build();
        serverApi.registerVolumeCategory(radios);
        serverApi.registerVolumeCategory(transceivers);
    }

    private int[][] getIcon(String path) {
        try {
            Enumeration<URL> resources = CommonRadioPlugin.class.getClassLoader().getResources(path);
            while (resources.hasMoreElements()) {
                BufferedImage bufferedImage = ImageIO.read(resources.nextElement().openStream());
                if (bufferedImage.getWidth() != 16 || bufferedImage.getHeight() != 16) continue;
                int[][] image = new int[16][16];
                for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                    for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                        image[x][y] = bufferedImage.getRGB(x, y);
                    }
                }
                return image;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

