/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.radio.RadioChannel;
import com.codinglitch.simpleradio.radio.RadioListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class FrequencerBlockEntity
extends class_2586 {
    public Frequency frequency;
    public List<String> listeners = new ArrayList<String>();
    public List<String> receivers = new ArrayList<String>();
    public List<String> frequencies = new ArrayList<String>();

    public FrequencerBlockEntity(class_2338 pos, class_2680 state) {
        super(SimpleRadioBlockEntities.FREQUENCER, pos, state);
    }

    private static String parse(@Nullable class_1297 owner, WorldlyPosition location) {
        if (owner == null) {
            class_2338 blockPos = location.blockPos();
            class_2586 listenerBlock = location.level.method_8321(blockPos);
            if (listenerBlock != null) {
                return listenerBlock.method_11010().method_26204().method_9518().getString() + " at " + blockPos.method_23854();
            }
        } else {
            return owner.method_5476().getString();
        }
        return null;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 blockState, FrequencerBlockEntity blockEntity) {
        if (Math.round(level.method_8510()) % 20 == 0 && !level.field_9236) {
            Object frequency;
            blockEntity.frequencies.clear();
            blockEntity.listeners.clear();
            blockEntity.receivers.clear();
            if (blockEntity.frequency != null && (frequency = Frequency.getFrequency(blockEntity.frequency.frequency, blockEntity.frequency.modulation)) != blockEntity.frequency && frequency != null) {
                blockEntity.frequency = frequency;
            }
            if (blockEntity.frequency != null) {
                for (RadioChannel receiver : blockEntity.frequency.receivers) {
                    class_1657 player = level.method_18470(receiver.owner);
                    String name = FrequencerBlockEntity.parse((class_1297)player, receiver.location);
                    if (name == null) continue;
                    blockEntity.receivers.add(name);
                }
                level.method_8413(pos, blockState, blockState, 2);
            } else {
                if (level.method_8320(blockEntity.method_11016().method_10074()).method_27852(class_2246.field_10201)) {
                    List<RadioListener> listeners = RadioListener.getListeners();
                    for (RadioListener listener : listeners) {
                        String name = FrequencerBlockEntity.parse(listener.owner, listener.location);
                        if (name == null) continue;
                        blockEntity.listeners.add(name);
                    }
                } else {
                    List<Frequency> frequencies = Frequency.getFrequencies();
                    for (Frequency frequency2 : frequencies) {
                        blockEntity.frequencies.add(frequency2.frequency + frequency2.modulation.shorthand);
                    }
                }
                level.method_8413(pos, blockState, blockState, 2);
            }
        }
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.saveTag(tag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        class_2487 tag = new class_2487();
        this.saveTag(tag);
        return class_2622.method_39026((class_2586)this, blockEntity -> tag);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.loadTag(tag);
    }

    public void method_11007(class_2487 tag) {
        this.saveTag(tag);
        super.method_11007(tag);
    }

    public void method_38240(class_1799 stack) {
        this.saveTag(stack.method_7948());
        super.method_38240(stack);
    }

    public void loadTag(class_2487 tag) {
        if (tag.method_10545("frequency")) {
            String frequencyName = tag.method_10558("frequency");
            Frequency.Modulation modulation = Frequency.modulationOf(tag.method_10558("modulation"));
            this.frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
        } else {
            this.frequency = null;
        }
        class_2487 receivers = tag.method_10562("receivers");
        this.receivers.clear();
        for (Object key : receivers.method_10541()) {
            this.receivers.add(receivers.method_10558((String)key));
        }
        class_2487 listeners = tag.method_10562("listeners");
        this.listeners.clear();
        for (String key : listeners.method_10541()) {
            this.listeners.add(listeners.method_10558(key));
        }
        class_2487 frequencies = tag.method_10562("frequencies");
        this.frequencies.clear();
        for (String key : frequencies.method_10541()) {
            this.frequencies.add(frequencies.method_10558(key));
        }
    }

    public void saveTag(class_2487 tag) {
        if (this.frequency != null) {
            tag.method_10582("frequency", this.frequency.frequency);
            tag.method_10582("modulation", this.frequency.modulation.shorthand);
        }
        class_2487 receivers = new class_2487();
        for (int i = 0; i < this.receivers.size(); ++i) {
            receivers.method_10582(String.valueOf(i), this.receivers.get(i));
        }
        tag.method_10566("receivers", (class_2520)receivers);
        class_2487 listeners = new class_2487();
        for (int i = 0; i < this.listeners.size(); ++i) {
            listeners.method_10582(String.valueOf(i), this.listeners.get(i));
        }
        tag.method_10566("listeners", (class_2520)listeners);
        class_2487 frequencies = new class_2487();
        for (int i = 0; i < this.frequencies.size(); ++i) {
            frequencies.method_10582(String.valueOf(i), this.frequencies.get(i));
        }
        tag.method_10566("frequencies", (class_2520)frequencies);
    }
}

