/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.central;

import com.codinglitch.simpleradio.core.central.Frequencing;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioChannel;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public interface Receiving
extends Frequencing {
    public static boolean validateReceiver(WorldlyPosition position, @Nullable Frequency frequency) {
        class_2338 pos = position.realLocation();
        if (!position.level.method_8477(pos)) {
            return false;
        }
        class_2680 state = position.level.method_8320(pos);
        if (state.method_26215()) {
            return false;
        }
        class_2586 blockEntity = position.level.method_8321(pos);
        class_1792 class_17922 = state.method_26204().method_8389();
        if (class_17922 instanceof Receiving) {
            Receiving receiving = (Receiving)class_17922;
            return frequency == null || receiving.getFrequency(blockEntity) == frequency;
        }
        return false;
    }

    public static boolean validateReceiver(UUID uuid, @Nullable Frequency frequency) {
        VoicechatConnection connection = CommonRadioPlugin.serverApi.getConnectionOf(uuid);
        if (connection != null) {
            return Receiving.validateReceiver(connection, frequency);
        }
        return false;
    }

    public static boolean validateReceiver(VoicechatConnection connection, @Nullable Frequency frequency) {
        class_3222 player = (class_3222)connection.getPlayer().getPlayer();
        if (player == null) {
            return false;
        }
        return Receiving.validateReceiver(player, frequency);
    }

    public static boolean validateReceiver(class_3222 player, @Nullable Frequency frequency) {
        return player.method_31548().method_43256(stack -> {
            class_1792 patt1850$temp = stack.method_7909();
            if (patt1850$temp instanceof Receiving) {
                Receiving receiving = (Receiving)patt1850$temp;
                return frequency == null || receiving.getFrequency((class_1799)stack) == frequency;
            }
            return false;
        });
    }

    default public RadioChannel startReceiving(String frequencyName, Frequency.Modulation modulation, UUID owner) {
        Frequency frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
        return frequency.tryAddReceiver(owner);
    }

    default public void stopReceiving(String frequencyName, Frequency.Modulation modulation, UUID owner) {
        Frequency frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
        frequency.removeReceiver(owner);
    }
}

