/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.central;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.radio.RadioChannel;
import com.codinglitch.simpleradio.radio.RadioListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class Frequency {
    private static final List<Frequency> frequencies = new ArrayList<Frequency>();
    public static String DEFAULT_FREQUENCY;
    public static Modulation DEFAULT_MODULATION;
    public static int FREQUENCY_DIGITS;
    public static int MAX_FREQUENCY;
    public static String FREQUENCY_PATTERN;
    public boolean isValid = true;
    public final Modulation modulation;
    public final String frequency;
    public final List<RadioChannel> receivers;
    public final List<RadioListener> transmitters;

    public Frequency(String frequency, Modulation modulation) {
        if (!Frequency.check(frequency)) {
            CommonSimpleRadio.warn("{} does not follow frequency pattern! Replacing with default pattern {}", frequency, DEFAULT_FREQUENCY);
            frequency = DEFAULT_FREQUENCY;
        }
        this.frequency = frequency;
        this.modulation = modulation;
        this.receivers = new ArrayList<RadioChannel>();
        this.transmitters = new ArrayList<RadioListener>();
        frequencies.add(this);
    }

    public static Frequency tryParse(String string) {
        Modulation modulation = Frequency.modulationOf(string.substring(string.length() - 2));
        return Frequency.getOrCreateFrequency(string.substring(0, string.length() - 2), modulation);
    }

    public static void onLexiconRevision() {
        FREQUENCY_DIGITS = SimpleRadioLibrary.SERVER_CONFIG.frequency.wholePlaces + SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces;
        MAX_FREQUENCY = (int)Math.pow(10.0, FREQUENCY_DIGITS);
        FREQUENCY_PATTERN = "^\\d{" + SimpleRadioLibrary.SERVER_CONFIG.frequency.wholePlaces + "}.\\d{" + SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces + "}$";
        DEFAULT_FREQUENCY = SimpleRadioLibrary.SERVER_CONFIG.frequency.defaultFrequency.equals("auto-generate") ? "0".repeat(SimpleRadioLibrary.SERVER_CONFIG.frequency.wholePlaces) + "." + "0".repeat(SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces) : SimpleRadioLibrary.SERVER_CONFIG.frequency.defaultFrequency;
    }

    public static void garbageCollect() {
        for (int i = 0; i < frequencies.size(); ++i) {
            Frequency frequency = frequencies.get(i);
            frequency.receivers.removeIf(Predicate.not(RadioChannel::validate));
            frequency.transmitters.removeIf(Predicate.not(RadioListener::validate));
        }
        frequencies.removeIf(Predicate.not(Frequency::validate));
    }

    @Nullable
    public static Modulation modulationOf(String shorthand) {
        for (Modulation modulation : Modulation.values()) {
            if (!modulation.shorthand.equals(shorthand)) continue;
            return modulation;
        }
        return null;
    }

    public static boolean check(String frequency) {
        return frequency.matches(FREQUENCY_PATTERN);
    }

    public static String incrementFrequency(String frequency, int amount) {
        int rawFrequency = Integer.parseInt(frequency.replaceAll("[.]", ""));
        String str = String.format("%0" + FREQUENCY_DIGITS + "d", org.joml.Math.clamp((int)0, (int)(MAX_FREQUENCY - 1), (int)(rawFrequency + amount)));
        return new StringBuilder(str).insert(str.length() - SimpleRadioLibrary.SERVER_CONFIG.frequency.decimalPlaces, ".").toString();
    }

    public static List<Frequency> getFrequencies() {
        return frequencies;
    }

    public static int getFrequencyIndex(String string, Modulation modulation) {
        for (int i = 0; i < frequencies.size(); ++i) {
            Frequency frequency = frequencies.get(i);
            if (!frequency.frequency.equals(string) || !frequency.modulation.equals((Object)modulation)) continue;
            return i;
        }
        return -1;
    }

    public static Frequency getFrequency(String string, Modulation modulation) {
        for (int i = 0; i < frequencies.size(); ++i) {
            Frequency frequency = frequencies.get(i);
            if (!frequency.frequency.equals(string) || !frequency.modulation.equals((Object)modulation)) continue;
            return frequency;
        }
        return null;
    }

    public RadioChannel getChannel(class_1657 player) {
        return this.getChannel(player.method_5667());
    }

    public RadioChannel getChannel(UUID player) {
        for (RadioChannel listener : this.receivers) {
            if (!listener.owner.equals(player)) continue;
            return listener;
        }
        return null;
    }

    @Nullable
    public RadioChannel tryAddReceiver(UUID owner) {
        if (this.getChannel(owner) == null) {
            return this.addReceiver(owner);
        }
        CommonSimpleRadio.info("Failed to add receiver {} to frequency {} as they already exist", owner, this.frequency);
        return null;
    }

    public RadioChannel addReceiver(UUID owner) {
        RadioChannel channel = new RadioChannel(owner, this);
        this.receivers.add(channel);
        CommonSimpleRadio.info("Added receiver {} to frequency {}", owner, this.frequency);
        return channel;
    }

    public void removeReceiver(class_1657 player) {
        this.removeReceiver(player.method_5667());
    }

    public void removeReceiver(UUID player) {
        this.receivers.removeIf(channel -> channel.owner.equals(player));
        if (!this.validate()) {
            frequencies.remove(this);
        }
    }

    @Nullable
    public RadioListener tryAddTransmitter(RadioListener transmitter) {
        return this.addTransmitter(transmitter);
    }

    public RadioListener addTransmitter(RadioListener transmitter) {
        this.transmitters.add(transmitter);
        return transmitter;
    }

    public void removeTransmitter(RadioListener transmitter) {
        this.transmitters.removeIf(otherTransmitter -> otherTransmitter.owner == null ? otherTransmitter.location.equals(transmitter.location) : otherTransmitter.owner.equals((Object)transmitter.owner));
        if (!this.validate()) {
            frequencies.remove(this);
        }
    }

    public void serverTick(int tickCount) {
    }

    public boolean validate() {
        if (this.receivers.isEmpty() && this.transmitters.isEmpty()) {
            this.invalidate();
            return false;
        }
        return true;
    }

    public void invalidate() {
        this.isValid = false;
    }

    public Frequency revalidate() {
        return Frequency.getFrequency(this.frequency, this.modulation);
    }

    public static Frequency getOrCreateFrequency(String frequency, Modulation modulation) {
        int index;
        if (frequency.isEmpty()) {
            frequency = DEFAULT_FREQUENCY;
        }
        if (modulation == null) {
            modulation = DEFAULT_MODULATION;
        }
        if ((index = Frequency.getFrequencyIndex(frequency, modulation)) != -1) {
            return frequencies.get(index);
        }
        return new Frequency(frequency, modulation);
    }

    @Nullable
    public static Frequency fromTag(class_2487 tag) {
        if (!tag.method_10545("frequency") || !tag.method_10545("modulation")) {
            return null;
        }
        Modulation modulation = Frequency.modulationOf(tag.method_10558("modulation"));
        if (modulation == null) {
            return null;
        }
        return Frequency.getOrCreateFrequency(tag.method_10558("frequency"), modulation);
    }

    static {
        DEFAULT_MODULATION = Modulation.FREQUENCY;
    }

    public static enum Modulation {
        FREQUENCY("FM"),
        AMPLITUDE("AM");

        public final String shorthand;

        private Modulation(String shorthand) {
            this.shorthand = shorthand;
        }
    }
}

