/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.central;

import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.central.FrequencyBlockEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_437;

public interface Frequencing {
    default public class_2487 setFrequency(class_1799 stack, String frequencyName, Frequency.Modulation modulation) {
        class_2487 tag = stack.method_7948();
        tag.method_10582("frequency", frequencyName);
        tag.method_10582("modulation", modulation.shorthand);
        return tag;
    }

    default public void setFrequency(class_2586 blockEntity, String frequencyName, Frequency.Modulation modulation) {
        this.setFrequency(blockEntity, Frequency.getOrCreateFrequency(frequencyName, modulation));
    }

    default public void setFrequency(class_2586 blockEntity, Frequency frequency) {
        if (blockEntity instanceof FrequencyBlockEntity) {
            FrequencyBlockEntity frequencyBlockEntity = (FrequencyBlockEntity)blockEntity;
            frequencyBlockEntity.frequency = frequency;
        }
    }

    default public Frequency getFrequency(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (!tag.method_10545("frequency") || !tag.method_10545("modulation")) {
            return null;
        }
        String frequencyName = tag.method_10558("frequency");
        Frequency.Modulation modulation = Frequency.modulationOf(tag.method_10558("modulation"));
        return Frequency.getOrCreateFrequency(frequencyName, modulation);
    }

    default public Frequency getFrequency(class_2586 blockEntity) {
        if (blockEntity instanceof FrequencyBlockEntity) {
            FrequencyBlockEntity frequencyBlockEntity = (FrequencyBlockEntity)blockEntity;
            return frequencyBlockEntity.frequency;
        }
        return null;
    }

    default public String getDefaultFrequency() {
        return Frequency.DEFAULT_FREQUENCY;
    }

    default public Frequency.Modulation getDefaultModulation() {
        return Frequency.DEFAULT_MODULATION;
    }

    default public boolean validate(String frequency, Frequency.Modulation modulation, UUID owner) {
        if (frequency == null) {
            return false;
        }
        if (modulation == null) {
            return false;
        }
        return this.validate(Frequency.getOrCreateFrequency(frequency, modulation), owner);
    }

    default public boolean validate(Frequency frequency, UUID owner) {
        return frequency.getChannel(owner) != null;
    }

    default public void tick(class_1799 stack, class_1937 level) {
        if (level.field_9236) {
            return;
        }
        class_2487 tag = stack.method_7948();
        if (!tag.method_10545("frequency") || tag.method_10558("frequency").isEmpty()) {
            this.setFrequency(stack, this.getDefaultFrequency(), this.getDefaultModulation());
        }
    }

    default public void appendTooltip(class_1799 stack, List<class_2561> components) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545("frequency")) {
            components.add((class_2561)class_2561.method_43470((String)(tag.method_10558("frequency") + tag.method_10558("modulation"))).method_27692(class_124.field_1063));
        }
        if (class_437.method_25442() && tag.method_10545("user")) {
            components.add((class_2561)class_2561.method_43469((String)"tooltip.simpleradio.receiver_user", (Object[])new Object[]{tag.method_25926("user")}).method_27692(class_124.field_1063));
        }
    }
}

