/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.screens;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.client.central.BaseButton;
import com.codinglitch.simpleradio.core.central.Frequencing;
import com.codinglitch.simpleradio.core.central.Frequency;
import com.codinglitch.simpleradio.core.networking.packets.ServerboundRadioUpdatePacket;
import com.codinglitch.simpleradio.core.registry.menus.RadiosmitherMenu;
import com.codinglitch.simpleradio.platform.ClientServices;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class RadiosmitherScreen
extends class_465<RadiosmitherMenu>
implements class_1712 {
    private static final class_2960 TEXTURE = CommonSimpleRadio.id("textures/gui/container/radiosmither.png");
    private static final class_2561 AM = class_2561.method_43471((String)"screen.simpleradio.radiosmither.am");
    private static final class_2561 FM = class_2561.method_43471((String)"screen.simpleradio.radiosmither.fm");
    private static final class_2561 AM_DESCRIPTION = class_2561.method_43471((String)"screen.simpleradio.radiosmither.am_description");
    private static final class_2561 FM_DESCRIPTION = class_2561.method_43471((String)"screen.simpleradio.radiosmither.fm_description");
    private static final int INCREMENT_THRESHOLD = 5;
    public ModulationButton FM_BUTTON;
    public ModulationButton AM_BUTTON;
    public KnobButton KNOB;
    public BaseButton APPLY_BUTTON;
    public class_342 FREQUENCY;
    protected String lastValidFrequency = Frequency.DEFAULT_FREQUENCY;
    public Frequency.Modulation modulation;
    protected int holdingFor = 0;
    protected int increment = 0;
    protected float time = 0.0f;

    public RadiosmitherScreen(RadiosmitherMenu menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
        this.field_2779 = 183;
        this.field_25268 = 6;
        this.field_25270 = this.field_2779 - 94;
    }

    private void updateFrequency(String input) {
        if (Frequency.check(input)) {
            this.lastValidFrequency = input;
        }
    }

    private void setModulation(Frequency.Modulation modulation) {
        this.modulation = modulation;
        if (modulation != null) {
            if (modulation == Frequency.Modulation.FREQUENCY) {
                this.FM_BUTTON.selected(true);
                this.AM_BUTTON.selected(false);
            } else if (modulation == Frequency.Modulation.AMPLITUDE) {
                this.AM_BUTTON.selected(true);
                this.FM_BUTTON.selected(false);
            }
        } else {
            this.FM_BUTTON.selected(false);
            this.AM_BUTTON.selected(false);
        }
    }

    protected void incrementFrequency() {
        this.incrementFrequency(1);
    }

    protected void incrementFrequency(int increment) {
        String freq = this.FREQUENCY.method_1882();
        if (!freq.isEmpty()) {
            this.FREQUENCY.method_1852(Frequency.incrementFrequency(freq, increment));
        }
    }

    protected void method_37432() {
        super.method_37432();
        class_1799 tinkering = ((RadiosmitherMenu)this.field_2797).getTinkering();
        if (tinkering != null && tinkering.method_7909() instanceof Frequencing) {
            if (!this.FREQUENCY.method_25370() && !Frequency.check(this.FREQUENCY.method_1882())) {
                if (!Frequency.check(this.lastValidFrequency)) {
                    this.lastValidFrequency = Frequency.DEFAULT_FREQUENCY;
                }
                this.FREQUENCY.method_1852(this.lastValidFrequency);
            }
        } else {
            this.FREQUENCY.method_1852("");
        }
        if (this.field_22787 != null) {
            int y = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507());
            if (this.KNOB.selected) {
                int centerY = this.KNOB.method_46427() + this.KNOB.method_25364() / 2;
                this.increment = (centerY - y) / 5;
            } else {
                this.increment = 0;
            }
            if (this.increment != 0) {
                ++this.holdingFor;
            }
            if (this.holdingFor > 5) {
                this.incrementFrequency(this.increment * (1 + Math.round((float)this.holdingFor / 5.0f)));
            }
        }
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mousey) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        graphics.method_25302(TEXTURE, x, y, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
        if (this.modulation != null) {
            this.time = (this.time + delta * 0.1f) % 5.0f;
            int x = (int)(this.time / 5.0f * 142.0f);
            int iconX = 70;
            switch (this.modulation) {
                case AMPLITUDE: {
                    int iconY = 218;
                    graphics.method_25290(TEXTURE, this.field_2776 + 9, this.field_2800 + 46, (float)(iconX + x), (float)iconY, 142 - x, 31, 256, 256);
                    graphics.method_25290(TEXTURE, this.field_2776 + 151 - x, this.field_2800 + 46, (float)iconX, (float)iconY, x, 31, 256, 256);
                    break;
                }
                case FREQUENCY: {
                    int iconY = 184;
                    graphics.method_25290(TEXTURE, this.field_2776 + 9, this.field_2800 + 45, (float)(iconX + x), (float)iconY, 142 - x, 34, 256, 256);
                    graphics.method_25290(TEXTURE, this.field_2776 + 151 - x, this.field_2800 + 45, (float)iconX, (float)iconY, x, 34, 256, 256);
                }
            }
        }
        this.FREQUENCY.method_25394(graphics, mouseX, mouseY, delta);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
    }

    public boolean method_25406(double $$0, double $$1, int $$2) {
        if (this.KNOB.method_25367()) {
            this.KNOB.onReleased();
        }
        if (this.APPLY_BUTTON.method_25367()) {
            this.APPLY_BUTTON.selected = false;
            this.APPLY_BUTTON.method_25365(false);
        }
        return super.method_25406($$0, $$1, $$2);
    }

    protected void method_25426() {
        super.method_25426();
        this.FREQUENCY = new class_342(this.field_22793, this.field_2776 + 90, this.field_2800 + 28, 50, 12, (class_2561)class_2561.method_43471((String)"screen.simpleradio.radiosmither.frequency"));
        this.FREQUENCY.method_1868(-1);
        this.FREQUENCY.method_1860(-1);
        this.FREQUENCY.method_1856(true);
        this.FREQUENCY.method_1858(false);
        this.FREQUENCY.method_1880(Frequency.FREQUENCY_DIGITS + 1);
        this.FREQUENCY.method_1863(this::updateFrequency);
        this.FREQUENCY.method_1852("");
        this.FREQUENCY.method_1890(s -> s.isEmpty() || s.matches("^\\d[.\\d]*$"));
        this.lastValidFrequency = Frequency.DEFAULT_FREQUENCY;
        this.method_25429((class_364)this.FREQUENCY);
        this.FREQUENCY.method_1888(((RadiosmitherMenu)this.field_2797).method_7611(0).method_7681());
        this.AM_BUTTON = new ModulationButton(this.field_2776 + 8, this.field_2800 + 23, false, () -> {
            this.AM_BUTTON.selected(true);
            this.FM_BUTTON.selected(false);
            this.modulation = Frequency.Modulation.AMPLITUDE;
        });
        this.FM_BUTTON = new ModulationButton(this.field_2776 + 46, this.field_2800 + 23, true, () -> {
            this.FM_BUTTON.selected(true);
            this.AM_BUTTON.selected(false);
            this.modulation = Frequency.Modulation.FREQUENCY;
        });
        this.KNOB = new KnobButton(this.field_2776 + 154, this.field_2800 + 44);
        this.APPLY_BUTTON = new BaseButton(this.field_2776 + 153, this.field_2800 + 24, 16, 16, 176, 0, TEXTURE, class_5244.field_39003, () -> {
            this.APPLY_BUTTON.selected = true;
            if (this.FREQUENCY.method_1882().isEmpty() || this.modulation == null) {
                return;
            }
            ClientServices.NETWORKING.sendToServer(new ServerboundRadioUpdatePacket(this.FREQUENCY.method_1882(), this.modulation));
        });
        this.APPLY_BUTTON.hoverIconX = 208;
        this.APPLY_BUTTON.hoverIconY = 0;
        this.APPLY_BUTTON.selectedIconX = 192;
        this.APPLY_BUTTON.selectedIconY = 0;
        this.method_37063((class_364)this.AM_BUTTON);
        this.method_37063((class_364)this.FM_BUTTON);
        this.method_37063((class_364)this.KNOB);
        this.method_37063((class_364)this.APPLY_BUTTON);
        ((RadiosmitherMenu)this.field_2797).method_7596(this);
    }

    public void method_25432() {
        super.method_25432();
        ((RadiosmitherMenu)this.field_2797).method_7603(this);
    }

    public void method_7635(class_1703 abstractContainerMenu, int slot, class_1799 stack) {
        if (slot == 0) {
            class_1792 class_17922;
            if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof Frequencing) {
                String numbers;
                Frequencing frequencing = (Frequencing)class_17922;
                Frequency frequency = frequencing.getFrequency(stack);
                this.lastValidFrequency = numbers = frequency.frequency;
                this.FREQUENCY.method_1852(numbers);
                this.FREQUENCY.method_1888(true);
                this.method_25395((class_364)this.FREQUENCY);
                this.setModulation(frequency.modulation);
            } else {
                this.FREQUENCY.method_1852("");
                this.FREQUENCY.method_1888(false);
                this.setModulation(null);
            }
        }
    }

    public void method_7633(class_1703 abstractContainerMenu, int i, int i1) {
    }

    public static class ModulationButton
    extends BaseButton {
        public ModulationButton(int x, int y, boolean isFM, Runnable onPress) {
            super(x, y, 35, 18, isFM ? 0 : 35, 184, TEXTURE, class_5244.field_39003, onPress);
            this.selectedIconX = this.iconX;
            this.selectedIconY = 202;
            this.hoverIconX = this.iconX;
            this.hoverIconY = 220;
            this.method_47400(class_7919.method_47408((class_2561)(isFM ? FM_DESCRIPTION : AM_DESCRIPTION), null));
        }

        public void selected(boolean selected) {
            this.selected = selected;
        }
    }

    public class KnobButton
    extends BaseButton {
        public KnobButton(int x, int y) {
            super(x, y, 16, 37, 176, 16, TEXTURE);
            this.hoverIconX = 208;
            this.hoverIconY = 16;
            this.selectedIconX = 192;
            this.selectedIconY = 16;
        }

        @Override
        public void blit(class_332 graphics, int iconX, int iconY) {
            if (this.selected) {
                if (RadiosmitherScreen.this.increment != 0) {
                    if (RadiosmitherScreen.this.holdingFor % 2 == 0) {
                        super.blit(graphics, this.iconX, this.iconY);
                    } else {
                        super.blit(graphics, this.selectedIconX, this.selectedIconY);
                    }
                    return;
                }
                super.blit(graphics, this.iconX, this.iconY);
                return;
            }
            super.blit(graphics, iconX, iconY);
        }

        @Override
        public void method_25306() {
            this.selected = true;
            RadiosmitherScreen.this.holdingFor = 0;
            if (RadiosmitherScreen.this.field_22787 != null) {
                int y = (int)(((RadiosmitherScreen)RadiosmitherScreen.this).field_22787.field_1729.method_1604() * (double)RadiosmitherScreen.this.field_22787.method_22683().method_4502() / (double)RadiosmitherScreen.this.field_22787.method_22683().method_4507());
                if ((double)y < (double)this.method_46427() + (double)this.field_22759 * 0.25) {
                    RadiosmitherScreen.this.incrementFrequency(1);
                } else if ((double)y > (double)this.method_46427() + (double)this.field_22759 * 0.75) {
                    RadiosmitherScreen.this.incrementFrequency(-1);
                }
            }
        }

        public void onReleased() {
            this.selected = false;
            this.method_25365(false);
            RadiosmitherScreen.this.increment = 0;
            RadiosmitherScreen.this.holdingFor = 0;
        }
    }
}

