/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.events.PlayerEvents;
import de.maxhenkel.voicechat.events.ServerVoiceChatEvents;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.QuiltNetManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.permission.QuiltPermissionManager;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.quiltmc.loader.api.ModContainer;
import org.quiltmc.loader.api.QuiltLoader;
import org.quiltmc.loader.api.entrypoint.EntrypointContainer;
import org.quiltmc.loader.api.minecraft.MinecraftQuiltLoader;
import org.quiltmc.qsl.command.api.CommandRegistrationCallback;
import org.quiltmc.qsl.lifecycle.api.event.ServerLifecycleEvents;

public class QuiltCommonCompatibilityManager
extends CommonCompatibilityManager {
    private QuiltNetManager netManager;

    @Override
    public String getModVersion() {
        ModContainer modContainer = QuiltLoader.getModContainer((String)"voicechat").orElse(null);
        if (modContainer == null) {
            return "N/A";
        }
        return modContainer.metadata().version().raw();
    }

    @Override
    public String getModName() {
        ModContainer modContainer = QuiltLoader.getModContainer((String)"voicechat").orElse(null);
        if (modContainer == null) {
            return "voicechat";
        }
        return modContainer.metadata().name();
    }

    @Override
    public Path getGameDirectory() {
        return QuiltLoader.getGameDir();
    }

    @Override
    public void emitServerVoiceChatConnectedEvent(class_3222 player) {
        ((Consumer)ServerVoiceChatEvents.VOICECHAT_CONNECTED.invoker()).accept(player);
    }

    @Override
    public void emitServerVoiceChatDisconnectedEvent(UUID clientID) {
        ((Consumer)ServerVoiceChatEvents.VOICECHAT_DISCONNECTED.invoker()).accept(clientID);
    }

    @Override
    public void emitPlayerCompatibilityCheckSucceeded(class_3222 player) {
        ((Consumer)ServerVoiceChatEvents.VOICECHAT_COMPATIBILITY_CHECK_SUCCEEDED.invoker()).accept(player);
    }

    @Override
    public void onServerVoiceChatConnected(Consumer<class_3222> onVoiceChatConnected) {
        ServerVoiceChatEvents.VOICECHAT_CONNECTED.register(onVoiceChatConnected);
    }

    @Override
    public void onServerVoiceChatDisconnected(Consumer<UUID> onVoiceChatDisconnected) {
        ServerVoiceChatEvents.VOICECHAT_DISCONNECTED.register(onVoiceChatDisconnected);
    }

    @Override
    public void onServerStarting(Consumer<MinecraftServer> onServerStarting) {
        ServerLifecycleEvents.READY.register(onServerStarting::accept);
    }

    @Override
    public void onServerStopping(Consumer<MinecraftServer> onServerStopping) {
        ServerLifecycleEvents.STOPPING.register(onServerStopping::accept);
    }

    @Override
    public void onPlayerLoggedIn(Consumer<class_3222> onPlayerLoggedIn) {
        PlayerEvents.PLAYER_LOGGED_IN.register(onPlayerLoggedIn);
    }

    @Override
    public void onPlayerLoggedOut(Consumer<class_3222> onPlayerLoggedOut) {
        PlayerEvents.PLAYER_LOGGED_OUT.register(onPlayerLoggedOut);
    }

    @Override
    public void onPlayerCompatibilityCheckSucceeded(Consumer<class_3222> onPlayerCompatibilityCheckSucceeded) {
        ServerVoiceChatEvents.VOICECHAT_COMPATIBILITY_CHECK_SUCCEEDED.register(onPlayerCompatibilityCheckSucceeded);
    }

    @Override
    public void onRegisterServerCommands(Consumer<CommandDispatcher<class_2168>> onRegisterServerCommands) {
        CommandRegistrationCallback.EVENT.register((dispatcher, integrated, dedicated) -> onRegisterServerCommands.accept(dispatcher));
    }

    @Override
    public NetManager getNetManager() {
        if (this.netManager == null) {
            this.netManager = new QuiltNetManager();
        }
        return this.netManager;
    }

    @Override
    public boolean isDevEnvironment() {
        return QuiltLoader.isDevelopmentEnvironment();
    }

    @Override
    public boolean isDedicatedServer() {
        return MinecraftQuiltLoader.getEnvironmentType().equals((Object)EnvType.SERVER);
    }

    @Override
    public boolean isModLoaded(String modId) {
        return QuiltLoader.isModLoaded((String)modId);
    }

    @Override
    public List<VoicechatPlugin> loadPlugins() {
        return QuiltLoader.getEntrypointContainers((String)"voicechat", VoicechatPlugin.class).stream().map(EntrypointContainer::getEntrypoint).collect(Collectors.toList());
    }

    @Override
    public PermissionManager createPermissionManager() {
        return new QuiltPermissionManager();
    }
}

