/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.scanning.ScanResultProviders;
import li.cil.scannable.client.scanning.filter.BlockCacheScanFilter;
import li.cil.scannable.client.scanning.filter.BlockScanFilter;
import li.cil.scannable.client.scanning.filter.BlockTagScanFilter;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.scanning.CommonOresBlockScannerModule;
import li.cil.scannable.common.scanning.fabric.RareOresBlockScannerModuleImpl;
import li.cil.scannable.common.scanning.filter.IgnoredBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;

public enum RareOresBlockScannerModule implements BlockScannerModule
{
    INSTANCE;

    private Predicate<class_2680> filter;

    public static void clearCache() {
        RareOresBlockScannerModule.INSTANCE.filter = null;
    }

    @Override
    public int getEnergyCost(class_1799 module) {
        return CommonConfig.energyCostModuleOreRare;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)ScanResultProviders.BLOCKS.get();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float adjustLocalRange(float range) {
        return range * CommonConfig.rangeModifierModuleOreRare;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Predicate<class_2680> getFilter(class_1799 module) {
        this.validateFilter();
        return this.filter;
    }

    @Environment(value=EnvType.CLIENT)
    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        ArrayList<Predicate<class_2680>> filters = new ArrayList<Predicate<class_2680>>();
        for (class_2960 location : CommonConfig.rareOreBlocks) {
            class_7923.field_41175.method_17966(location).ifPresent(block -> filters.add(new BlockScanFilter((class_2248)block)));
        }
        class_7923.field_41175.method_40273().forEach(tag -> {
            if (CommonConfig.rareOreBlockTags.contains(tag.comp_327())) {
                filters.add(new BlockTagScanFilter((class_6862<class_2248>)tag));
            }
        });
        class_6862<class_2248> topLevelOreTag = RareOresBlockScannerModule.getTopLevelOreTag();
        filters.add(state -> !IgnoredBlocks.contains(state) && state.method_26164(topLevelOreTag) && !CommonOresBlockScannerModule.INSTANCE.getFilter(class_1799.field_8037).test((class_2680)state));
        this.filter = new BlockCacheScanFilter((Collection<Predicate<class_2680>>)filters);
    }

    @ExpectPlatform
    @Contract(value="_ -> !null")
    @ExpectPlatform.Transformed
    private static class_6862<class_2248> getTopLevelOreTag() {
        return RareOresBlockScannerModuleImpl.getTopLevelOreTag();
    }
}

