/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.Function;
import li.cil.scannable.common.network.message.AbstractMessage;
import li.cil.scannable.common.network.message.RemoveConfiguredModuleItemAtMessage;
import li.cil.scannable.common.network.message.SetConfiguredModuleItemAtMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public final class Network {
    private static final HashMap<Class<? extends AbstractMessage>, class_2960> PACKET_MAP = new HashMap();
    private static final class_2960 SET_CONFIGURED_MODULE_ITEM = new class_2960("scannable", "set_module_item");
    private static final class_2960 REMOVE_CONFIGURED_MODULE_ITEM = new class_2960("scannable", "remove_module_item");

    public static void initialize() {
        Network.registerMessageToServer(REMOVE_CONFIGURED_MODULE_ITEM, RemoveConfiguredModuleItemAtMessage.class, RemoveConfiguredModuleItemAtMessage::new);
        Network.registerMessageToServer(SET_CONFIGURED_MODULE_ITEM, SetConfiguredModuleItemAtMessage.class, SetConfiguredModuleItemAtMessage::new);
    }

    private static <T extends AbstractMessage> void registerMessageToServer(class_2960 location, Class<T> type, Function<class_2540, T> decoder) {
        PACKET_MAP.put(type, location);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)location, (buffer, context) -> {
            AbstractMessage message = (AbstractMessage)decoder.apply(buffer);
            context.queue(() -> message.handleMessage(context));
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(AbstractMessage message) {
        class_2960 loc = PACKET_MAP.get(message.getClass());
        if (loc == null) {
            throw new IllegalArgumentException("Invalid message type");
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        message.toBytes(buf);
        NetworkManager.sendToServer((class_2960)loc, (class_2540)buf);
    }
}

