/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.audio.SoundManager;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.ScannerContainerMenu;
import li.cil.scannable.common.energy.ItemEnergyStorage;
import li.cil.scannable.common.inventory.ContainerSlice;
import li.cil.scannable.common.inventory.ScannerContainer;
import li.cil.scannable.common.item.Items;
import li.cil.scannable.common.item.ModItem;
import li.cil.scannable.common.item.ScannerModuleItem;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;

public final class ScannerItem
extends ModItem {
    public static boolean isScanner(class_1799 stack) {
        return stack.method_7909() == Items.SCANNER.get();
    }

    public ScannerItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, level, tooltip, flag);
        if (CommonConfig.useEnergy) {
            ItemEnergyStorage.of(stack).ifPresent(energy -> tooltip.add(Strings.energyStorage(energy.getEnergyStored(), energy.getMaxEnergyStored())));
        }
    }

    public boolean method_31567(class_1799 stack) {
        return CommonConfig.useEnergy;
    }

    public int method_31569(class_1799 stack) {
        return (int)(ScannerItem.getRelativeEnergy(stack) * 13.0f);
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)(ScannerItem.getRelativeEnergy(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, final class_1268 hand) {
        final class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (!level.method_8608() && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (class_3908)new class_3908(){

                    public class_2561 method_5476() {
                        return stack.method_7964();
                    }

                    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                        return new ScannerContainerMenu(id, inventory, hand, ScannerContainer.of(stack));
                    }
                }, buffer -> buffer.method_10817((Enum)hand));
            }
        } else {
            ArrayList<class_1799> modules = new ArrayList<class_1799>();
            if (!ScannerItem.collectModules(stack, modules)) {
                if (!level.method_8608()) {
                    player.method_7353(Strings.MESSAGE_NO_SCAN_MODULES, true);
                }
                player.method_7357().method_7906((class_1792)this, 10);
                return class_1271.method_22431((Object)stack);
            }
            if (!ScannerItem.tryConsumeEnergy(player, stack, modules, true)) {
                if (!level.method_8608()) {
                    player.method_7353(Strings.MESSAGE_NOT_ENOUGH_ENERGY, true);
                }
                player.method_7357().method_7906((class_1792)this, 10);
                return class_1271.method_22431((Object)stack);
            }
            player.method_6019(hand);
            if (level.method_8608()) {
                ScanManager.beginScan(player, modules);
                SoundManager.playChargingSound();
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    public int method_7881(class_1799 stack) {
        return 40;
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int count) {
        super.method_7852(level, entity, stack, count);
        if (entity.method_37908().method_8608()) {
            ScanManager.updateScan((class_1297)entity, false);
        }
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeLeft) {
        if (level.method_8608()) {
            ScanManager.cancelScan();
            SoundManager.stopChargingSound();
        }
        super.method_7840(stack, level, entity, timeLeft);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 entity) {
        if (!(entity instanceof class_1657)) {
            return stack;
        }
        class_1657 player = (class_1657)entity;
        ArrayList<class_1799> modules = new ArrayList<class_1799>();
        if (!ScannerItem.collectModules(stack, modules)) {
            return stack;
        }
        boolean hasEnergy = ScannerItem.tryConsumeEnergy((class_1657)entity, stack, modules, false);
        if (level.method_8608()) {
            SoundManager.stopChargingSound();
            if (hasEnergy) {
                ScanManager.updateScan((class_1297)entity, true);
                SoundManager.playActivateSound();
            } else {
                ScanManager.cancelScan();
            }
        }
        player.method_7357().method_7906((class_1792)this, 40);
        return stack;
    }

    private static float getRelativeEnergy(class_1799 stack) {
        if (!CommonConfig.useEnergy) {
            return 0.0f;
        }
        return ItemEnergyStorage.of(stack).map(storage -> Float.valueOf((float)storage.getEnergyStored() / (float)storage.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static boolean tryConsumeEnergy(class_1657 player, class_1799 scanner, List<class_1799> modules, boolean simulate) {
        if (!CommonConfig.useEnergy) {
            return true;
        }
        if (player.method_7337()) {
            return true;
        }
        Optional<ItemEnergyStorage> energyStorage = ItemEnergyStorage.of(scanner);
        if (energyStorage.isEmpty()) {
            return false;
        }
        long totalCostAccumulator = 0L;
        for (class_1799 module : modules) {
            totalCostAccumulator += (long)ScannerModuleItem.getModuleEnergyCost(module);
        }
        long totalCost = totalCostAccumulator;
        long extracted = energyStorage.map(storage -> storage.extractEnergy(totalCost, simulate)).orElse(0L);
        return extracted >= totalCost;
    }

    private static boolean collectModules(class_1799 scanner, List<class_1799> modules) {
        ScannerContainer container = ScannerContainer.of(scanner);
        ContainerSlice activeModules = container.getActiveModules();
        boolean hasScannerModules = false;
        for (int slot = 0; slot < activeModules.method_5439(); ++slot) {
            class_1799 module = activeModules.method_5438(slot);
            if (module.method_7960()) continue;
            modules.add(module);
            hasScannerModules |= ScannerModuleItem.getModule(module).map(ScannerModule::hasResultProvider).orElse(false).booleanValue();
        }
        return hasScannerModules;
    }
}

