/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.EntityModuleContainerMenu;
import li.cil.scannable.common.item.ScannerModuleItem;
import li.cil.scannable.common.scanning.ConfigurableEntityScannerModule;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public final class ConfigurableEntityScannerModuleItem
extends ScannerModuleItem {
    private static final String TAG_ENTITY_DEPRECATED = "entity";
    private static final String TAG_ENTITIES = "entities";
    private static final String TAG_IS_LOCKED = "isLocked";

    public static boolean isLocked(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10577(TAG_IS_LOCKED);
    }

    public static List<class_1299<?>> getEntityTypes(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10573(TAG_ENTITY_DEPRECATED, 8) && !tag.method_10573(TAG_ENTITIES, 9)) {
            return Collections.emptyList();
        }
        ConfigurableEntityScannerModuleItem.upgradeData(tag);
        class_2499 list = tag.method_10554(TAG_ENTITIES, 8);
        ArrayList result = new ArrayList();
        list.forEach(item -> {
            Optional entityType = class_1299.method_5898((String)item.method_10714());
            entityType.ifPresent(result::add);
        });
        return result;
    }

    private static boolean addEntityType(class_1799 stack, class_1299<?> entityType) {
        Optional registryName = class_7923.field_41177.method_29113(entityType);
        if (registryName.isEmpty()) {
            return false;
        }
        class_2487 tag = stack.method_7948();
        if (tag.method_10577(TAG_IS_LOCKED)) {
            return false;
        }
        class_2519 itemNbt = class_2519.method_23256((String)((class_5321)registryName.get()).method_29177().toString());
        class_2499 list = tag.method_10554(TAG_ENTITIES, 8);
        if (list.contains((Object)itemNbt)) {
            return true;
        }
        if (list.size() >= 5) {
            return false;
        }
        tag.method_10566(TAG_ENTITIES, (class_2520)list);
        list.add((Object)itemNbt);
        return true;
    }

    public static void setEntityTypeAt(class_1799 stack, int index, class_1299<?> entityType) {
        if (index < 0 || index >= 5) {
            return;
        }
        Optional registryName = class_7923.field_41177.method_29113(entityType);
        if (registryName.isEmpty()) {
            return;
        }
        class_2487 tag = stack.method_7948();
        if (tag.method_10577(TAG_IS_LOCKED)) {
            return;
        }
        class_2519 itemNbt = class_2519.method_23256((String)((class_5321)registryName.get()).method_29177().toString());
        class_2499 list = tag.method_10554(TAG_ENTITIES, 8);
        int oldIndex = list.indexOf((Object)itemNbt);
        if (oldIndex == index) {
            return;
        }
        if (index >= list.size()) {
            list.add((Object)itemNbt);
        } else {
            list.method_10606(index, (class_2520)itemNbt);
        }
        if (oldIndex >= 0) {
            list.method_10536(oldIndex);
        }
        tag.method_10566(TAG_ENTITIES, (class_2520)list);
    }

    public static void removeEntityTypeAt(class_1799 stack, int index) {
        if (index < 0 || index >= 5) {
            return;
        }
        class_2487 tag = stack.method_7948();
        if (tag.method_10577(TAG_IS_LOCKED)) {
            return;
        }
        class_2499 list = tag.method_10554(TAG_ENTITIES, 8);
        if (index < list.size()) {
            list.method_10536(index);
        }
    }

    private static void upgradeData(class_2487 tag) {
        if (tag.method_10573(TAG_ENTITY_DEPRECATED, 8)) {
            class_2499 list = new class_2499();
            list.add((Object)tag.method_10580(TAG_ENTITY_DEPRECATED));
            tag.method_10566(TAG_ENTITIES, (class_2520)list);
            tag.method_10551(TAG_ENTITY_DEPRECATED);
        }
    }

    public ConfigurableEntityScannerModuleItem() {
        super(ConfigurableEntityScannerModule.INSTANCE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, level, tooltip, flag);
        List<class_1299<?>> entities = ConfigurableEntityScannerModuleItem.getEntityTypes(stack);
        if (!entities.isEmpty()) {
            tooltip.add(Strings.TOOLTIP_ENTITIES_LIST_CAPTION);
            entities.forEach(e -> tooltip.add(Strings.listItem(e.method_5897())));
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, final class_1268 hand) {
        final class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            return class_1271.method_22430((Object)stack);
        }
        if (!level.method_8608() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (class_3908)new class_3908(){

                public class_2561 method_5476() {
                    return stack.method_7964();
                }

                public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                    return new EntityModuleContainerMenu(id, inventory, hand);
                }
            }, buffer -> buffer.method_10817((Enum)hand));
        }
        return class_1271.method_22427((Object)stack);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        if (ConfigurableEntityScannerModuleItem.addEntityType(player.method_5998(hand), target.method_5864())) {
            player.method_6104(hand);
            player.method_31548().method_5431();
        } else if (!player.method_37908().method_8608() && !ConfigurableEntityScannerModuleItem.isLocked(stack)) {
            player.method_7353(Strings.MESSAGE_NO_FREE_SLOTS, true);
        }
        return class_1269.method_29236((boolean)player.method_37908().method_8608());
    }
}

