/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.BlockModuleContainerMenu;
import li.cil.scannable.common.item.ScannerModuleItem;
import li.cil.scannable.common.scanning.ConfigurableBlockScannerModule;
import li.cil.scannable.common.scanning.filter.IgnoredBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigurableBlockScannerModuleItem
extends ScannerModuleItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TAG_BLOCKS = "blocks";
    private static final String TAG_IS_LOCKED = "isLocked";

    public static boolean isLocked(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10577(TAG_IS_LOCKED);
    }

    public static List<class_2248> getBlocks(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10573(TAG_BLOCKS, 9)) {
            return Collections.emptyList();
        }
        class_2499 list = tag.method_10554(TAG_BLOCKS, 8);
        ArrayList<class_2248> result = new ArrayList<class_2248>();
        list.forEach(item -> {
            try {
                class_2960 registryName = new class_2960(item.method_10714());
                class_7923.field_41175.method_17966(registryName).ifPresent(result::add);
            }
            catch (class_151 e) {
                LOGGER.error((Object)e);
            }
        });
        return result;
    }

    public static boolean addBlock(class_1799 stack, class_2248 block) {
        Optional registryName = class_7923.field_41175.method_29113((Object)block);
        if (registryName.isEmpty()) {
            return false;
        }
        class_2487 tag = stack.method_7948();
        if (tag.method_10577(TAG_IS_LOCKED)) {
            return false;
        }
        class_2519 itemNbt = class_2519.method_23256((String)((class_5321)registryName.get()).method_29177().toString());
        class_2499 list = tag.method_10554(TAG_BLOCKS, 8);
        if (list.contains((Object)itemNbt)) {
            return true;
        }
        if (list.size() >= 5) {
            return false;
        }
        tag.method_10566(TAG_BLOCKS, (class_2520)list);
        list.add((Object)itemNbt);
        return true;
    }

    public static void setBlockAt(class_1799 stack, int index, class_2248 block) {
        if (index < 0 || index >= 5) {
            return;
        }
        Optional registryName = class_7923.field_41175.method_29113((Object)block);
        if (registryName.isEmpty()) {
            return;
        }
        class_2487 tag = stack.method_7948();
        if (tag.method_10577(TAG_IS_LOCKED)) {
            return;
        }
        class_2519 itemNbt = class_2519.method_23256((String)((class_5321)registryName.get()).method_29177().toString());
        class_2499 list = tag.method_10554(TAG_BLOCKS, 8);
        int oldIndex = list.indexOf((Object)itemNbt);
        if (oldIndex == index) {
            return;
        }
        if (index >= list.size()) {
            list.add((Object)itemNbt);
        } else {
            list.method_10606(index, (class_2520)itemNbt);
        }
        if (oldIndex >= 0) {
            list.method_10536(oldIndex);
        }
        tag.method_10566(TAG_BLOCKS, (class_2520)list);
    }

    public static void removeBlockAt(class_1799 stack, int index) {
        if (index < 0 || index >= 5) {
            return;
        }
        class_2487 tag = stack.method_7948();
        if (tag.method_10577(TAG_IS_LOCKED)) {
            return;
        }
        class_2499 list = tag.method_10554(TAG_BLOCKS, 8);
        if (index < list.size()) {
            list.method_10536(index);
        }
    }

    public ConfigurableBlockScannerModuleItem() {
        super(ConfigurableBlockScannerModule.INSTANCE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, level, tooltip, flag);
        List<class_2248> blocks = ConfigurableBlockScannerModuleItem.getBlocks(stack);
        if (!blocks.isEmpty()) {
            tooltip.add(Strings.TOOLTIP_BLOCKS_LIST_CAPTION);
            blocks.forEach(b -> tooltip.add(Strings.listItem((class_2561)b.method_9518())));
        }
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, final class_1268 hand) {
        final class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            return class_1271.method_22430((Object)stack);
        }
        if (!level.method_8608() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (class_3908)new class_3908(){

                public class_2561 method_5476() {
                    return stack.method_7964();
                }

                public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                    return new BlockModuleContainerMenu(id, inventory, hand);
                }
            }, buffer -> buffer.method_10817((Enum)hand));
        }
        return class_1271.method_22427((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        if (level.method_22347(context.method_8037())) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5811;
        }
        class_1799 stack = context.method_8041();
        class_2680 state = level.method_8320(context.method_8037());
        if (IgnoredBlocks.contains(state)) {
            if (!level.method_8608()) {
                player.method_7353(Strings.MESSAGE_BLOCK_IGNORED, true);
            }
            player.method_7357().method_7906((class_1792)this, 10);
            return class_1269.method_29236((boolean)context.method_8045().method_8608());
        }
        if (!(ConfigurableBlockScannerModuleItem.addBlock(stack, state.method_26204()) || level.method_8608() || ConfigurableBlockScannerModuleItem.isLocked(stack))) {
            player.method_7353(Strings.MESSAGE_NO_FREE_SLOTS, true);
        }
        return class_1269.method_29236((boolean)context.method_8045().method_8608());
    }
}

