/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Menu
extends WidgetWithBounds
implements LateRenderable {
    public final Point menuStartPoint;
    public final boolean facingRight;
    public final boolean facingDownwards;
    public final ValueAnimator<FloatingRectangle> bounds = ValueAnimator.ofFloatingRectangle();
    private final List<FavoriteMenuEntry> entries = Lists.newArrayList();
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            int i = 0;
            for (FavoriteMenuEntry entry : Menu.this.method_25396()) {
                i += entry.getEntryHeight();
            }
            return i;
        }

        public Rectangle getBounds() {
            return Menu.this.getInnerBounds();
        }

        public boolean hasScrollBar() {
            return Menu.this.hasScrollBar();
        }
    };

    public Menu(Rectangle menuStart, Collection<FavoriteMenuEntry> entries, boolean sort) {
        this.buildEntries(entries, sort);
        int fullWidth = class_310.method_1551().field_1755.field_22789;
        int fullHeight = class_310.method_1551().field_1755.field_22790;
        boolean facingRight = true;
        this.facingDownwards = fullHeight - menuStart.getMaxY() > menuStart.y;
        int y = this.facingDownwards ? menuStart.getMaxY() : menuStart.y - (this.scrolling.getMaxScrollHeight() + 2);
        boolean hasScrollBar = this.scrolling.getMaxScrollHeight() > this.getInnerHeight(y);
        int menuWidth = this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0);
        if (facingRight && fullWidth - menuStart.getMaxX() < menuWidth + 10) {
            facingRight = false;
        } else if (!facingRight && menuStart.x < menuWidth + 10) {
            facingRight = true;
        }
        this.facingRight = facingRight;
        int x = facingRight ? menuStart.x : menuStart.getMaxX() - (this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0));
        this.menuStartPoint = new Point(x, y);
        Rectangle createBounds = this.createBounds();
        this.bounds.setAs((Object)new FloatingRectangle(facingRight ? (double)createBounds.x : (double)createBounds.getMaxX(), this.facingDownwards ? (double)createBounds.y : (double)createBounds.getMaxY(), 0.1, 0.1));
    }

    private void buildEntries(Collection<FavoriteMenuEntry> entries, boolean sort) {
        this.entries.clear();
        this.entries.addAll(entries);
        if (sort) {
            this.entries.sort(Comparator.comparing(entry -> entry instanceof SubMenuEntry ? 0 : 1).thenComparing(entry -> {
                String string;
                if (entry instanceof SubMenuEntry) {
                    SubMenuEntry menuEntry = (SubMenuEntry)entry;
                    string = menuEntry.text.getString();
                } else {
                    string = "";
                }
                return string;
            }));
        }
        for (FavoriteMenuEntry entry2 : this.entries) {
            entry2.closeMenu = ScreenOverlayImpl.getInstance().menuAccess()::close;
            if (!(entry2 instanceof SubMenuEntry)) continue;
            SubMenuEntry menuEntry = (SubMenuEntry)entry2;
            menuEntry.setParent(this);
        }
    }

    @Override
    public Rectangle getBounds() {
        return ((FloatingRectangle)this.bounds.value()).getBounds();
    }

    public Rectangle createBounds() {
        return new Rectangle(this.menuStartPoint.x, this.menuStartPoint.y, this.getMaxEntryWidth() + 2 + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight(this.menuStartPoint.y) + 2);
    }

    public Rectangle getInnerBounds() {
        Rectangle rectangle = ((FloatingRectangle)this.bounds.value()).getBounds();
        return new Rectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
    }

    public boolean hasScrollBar() {
        return this.scrolling.getMaxScrollHeight() > this.getInnerHeight(this.menuStartPoint.y);
    }

    public int getInnerHeight(int y) {
        return Math.min(this.scrolling.getMaxScrollHeight(), this.minecraft.field_1755.field_22790 - 20 - y);
    }

    public int getMaxEntryWidth() {
        int i = 0;
        for (FavoriteMenuEntry entry : this.method_25396()) {
            if (entry.getEntryWidth() <= i) continue;
            i = entry.getEntryWidth();
        }
        return Math.max(10, i);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        FavoriteMenuEntry menuEntry;
        this.bounds.setTo((Object)this.createBounds().getFloatingBounds(), ConfigObject.getInstance().isReducedMotion() ? 0L : 300L);
        this.bounds.update((double)delta);
        Rectangle bounds = this.getBounds();
        Rectangle innerBounds = this.getInnerBounds();
        graphics.method_25294(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), this.containsMouse(mouseX, mouseY) ? (REIRuntime.getInstance().isDarkThemeEnabled() ? -17587 : -1) : -6250336);
        graphics.method_25294(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), -16777216);
        boolean contains = innerBounds.contains(mouseX, mouseY);
        class_364 class_3642 = this.method_25399();
        FavoriteMenuEntry focused = class_3642 instanceof FavoriteMenuEntry ? (menuEntry = (FavoriteMenuEntry)class_3642) : null;
        int currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        for (FavoriteMenuEntry child : this.method_25396()) {
            boolean containsMouse;
            boolean bl = containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            if (containsMouse) {
                focused = child;
            }
            currentY += child.getEntryHeight();
        }
        currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getScissorBounds());
        for (FavoriteMenuEntry child : this.method_25396()) {
            boolean rendering = currentY + child.getEntryHeight() >= innerBounds.y && currentY <= innerBounds.getMaxY();
            boolean containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            child.updateInformation(innerBounds.x, currentY, focused == child || containsMouse, containsMouse, rendering, this.getMaxEntryWidth());
            if (rendering) {
                child.method_25394(graphics, mouseX, mouseY, delta);
            }
            currentY += child.getEntryHeight();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.method_25395((class_364)focused);
        this.scrolling.renderScrollBar(graphics, 0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        this.scrolling.updatePosition(delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button) || this.getInnerBounds().contains(mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.getInnerBounds().contains(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        for (FavoriteMenuEntry child : this.method_25396()) {
            if (!(child instanceof SubMenuEntry) || !child.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        for (FavoriteMenuEntry child : this.method_25396()) {
            if (!child.containsMouse(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public List<FavoriteMenuEntry> method_25396() {
        return this.entries;
    }
}

