/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;

public interface CraftingRecipeFiller<T extends CraftingRecipe>
extends Function<T, Collection<Display>> {
    default public void registerCategories(CategoryRegistry registry) {
    }

    default public void registerExtension(CategoryRegistry registry, final ExtensionCallback callback) {
        registry.get(BuiltinPlugin.CRAFTING).registerExtension((display, category, lastView) -> {
            if (this.getRecipeClass().isInstance(display.getOptionalRecipe().orElse(null))) {
                return new DisplayCategoryView<DefaultCraftingDisplay<?>>(){

                    @Override
                    public DisplayRenderer getDisplayRenderer(DefaultCraftingDisplay<?> display) {
                        return lastView.getDisplayRenderer(display);
                    }

                    @Override
                    public List<Widget> setupDisplay(DefaultCraftingDisplay<?> display, Rectangle bounds) {
                        List<Widget> widgets = lastView.setupDisplay(display, bounds);
                        callback.accept(bounds, widgets, display);
                        return widgets;
                    }
                };
            }
            return lastView;
        });
    }

    default public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipesFiller(this.getRecipeClass(), RecipeType.f_44107_, this::apply);
    }

    default public Widget createInfoWidget(Rectangle rectangle, DefaultCraftingDisplay<?> display, Component ... texts) {
        Point point = new Point(rectangle.getMaxX() - 4, rectangle.y + 4);
        Rectangle bounds = new Rectangle(point.getX() - 9, point.getY() + 1, 8, 8);
        if (display.isShapeless()) {
            bounds.x -= 10;
        }
        Widget widget = Widgets.createTexturedWidget(new ResourceLocation("roughlyenoughitems:textures/gui/info.png"), bounds.getX(), bounds.getY(), 0.0f, 0.0f, bounds.getWidth(), bounds.getHeight(), 1, 1, 1, 1);
        return Widgets.withTooltip(Widgets.withBounds(widget, bounds), texts);
    }

    public Class<T> getRecipeClass();

    @FunctionalInterface
    public static interface ExtensionCallback {
        public void accept(Rectangle var1, List<Widget> var2, DefaultCraftingDisplay<?> var3);
    }
}

