/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.chest;

import com.greymerk.roguelike.config.Config;
import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.treasure.Inventory;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.chest.ChestPlacementException;
import com.greymerk.roguelike.treasure.chest.ChestType;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.treasure.loot.Loot;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2383;
import net.minecraft.class_2621;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public class TreasureChest
implements ITreasureChest {
    private Inventory inventory;
    private Treasure type;
    private class_2621 chest;
    private Difficulty diff;

    public TreasureChest(Treasure type) {
        this.type = type;
        this.diff = Difficulty.EASIEST;
    }

    @Override
    public ITreasureChest generate(IWorldEditor editor, class_5819 rand, Coord pos, ChestType block) throws ChestPlacementException {
        for (Cardinal dir : Cardinal.directions) {
            Coord p = pos.copy();
            p.add(dir);
            if (!editor.isAir(pos)) continue;
            return this.generate(editor, rand, pos, dir, block);
        }
        Cardinal dir = Cardinal.randDirs(rand).get(0);
        return this.generate(editor, rand, pos, dir, block);
    }

    @Override
    public ITreasureChest generate(IWorldEditor editor, class_5819 rand, Coord pos, Cardinal dir, ChestType type) throws ChestPlacementException {
        this.diff = Difficulty.fromY(pos.getY());
        MetaBlock block = ChestType.get(type);
        this.setOrientation(block, dir);
        boolean success = block.set(editor, pos);
        if (!success) {
            throw new ChestPlacementException("Failed to place chest in world");
        }
        this.chest = (class_2621)editor.getBlockEntity(pos);
        this.inventory = new Inventory(rand, this.chest);
        Optional<class_2960> table = Treasure.getTableIdentifier(this.type, this.diff);
        if (table.isPresent()) {
            this.setLootTable(table.get(), editor.getSeed(pos));
        }
        if (Config.ofBoolean(Config.ROGUELIKE_LOOT).booleanValue()) {
            Loot.fillChest(editor, this, rand);
        }
        return this;
    }

    private void setOrientation(MetaBlock block, Cardinal dir) {
        class_2248 b = block.getBlock();
        if ((b == class_2246.field_10034 || b == class_2246.field_10380) && Cardinal.directions.contains((Object)dir)) {
            block.withProperty(class_2383.field_11177, Cardinal.facing(dir).method_10153());
        }
        if (b == class_2246.field_16328) {
            block.withProperty(class_2741.field_12525, Cardinal.facing(Cardinal.UP));
        }
        if (b == class_2246.field_10603) {
            block.withProperty(class_2318.field_10927, Cardinal.facing(dir));
        }
    }

    @Override
    public boolean setSlot(int slot, class_1799 item) {
        return this.inventory.setInventorySlot(slot, item);
    }

    @Override
    public boolean setRandomEmptySlot(class_1799 item) {
        return this.inventory.setRandomEmptySlot(item);
    }

    @Override
    public boolean isEmptySlot(int slot) {
        return this.inventory.isEmptySlot(slot);
    }

    @Override
    public Treasure getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.inventory.getInventorySize();
    }

    @Override
    public Difficulty getLevel() {
        return this.diff;
    }

    public void setLootTable(class_2960 table, long seed) {
        this.chest.method_11285(table, seed);
    }
}

