/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.util.IWeighted;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_5819;

public class TreasureManager {
    List<ITreasureChest> chests = new ArrayList<ITreasureChest>();

    public void add(ITreasureChest toAdd) {
        this.chests.add(toAdd);
    }

    public void addItemToAll(class_5819 rand, Treasure type, Difficulty diff, IWeighted<class_1799> item, int amount) {
        this.addItemToAll(rand, this.getChests(type, diff), item, amount);
    }

    public void addItemToAll(class_5819 rand, Difficulty diff, IWeighted<class_1799> item, int amount) {
        this.addItemToAll(rand, this.getChests(diff), item, amount);
    }

    public void addItemToAll(class_5819 rand, Treasure type, IWeighted<class_1799> item, int amount) {
        this.addItemToAll(rand, this.getChests(type), item, amount);
    }

    private void addItemToAll(class_5819 rand, List<ITreasureChest> chests, IWeighted<class_1799> item, int amount) {
        for (ITreasureChest chest : chests) {
            for (int i = 0; i < amount; ++i) {
                chest.setRandomEmptySlot(item.get(rand));
            }
        }
    }

    public void addItem(class_5819 rand, Difficulty diff, IWeighted<class_1799> item, int amount) {
        this.addItem(rand, this.getChests(diff), item, amount);
    }

    public void addItem(class_5819 rand, Treasure type, IWeighted<class_1799> item, int amount) {
        this.addItem(rand, this.getChests(type), item, amount);
    }

    public void addItem(class_5819 rand, Treasure type, Difficulty diff, IWeighted<class_1799> item, int amount) {
        this.addItem(rand, this.getChests(type, diff), item, amount);
    }

    private void addItem(class_5819 rand, List<ITreasureChest> chests, IWeighted<class_1799> item, int amount) {
        if (chests.isEmpty()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ITreasureChest chest = chests.get(rand.method_43048(chests.size()));
            chest.setRandomEmptySlot(item.get(rand));
        }
    }

    public List<ITreasureChest> getChests(Treasure type, Difficulty diff) {
        ArrayList<ITreasureChest> c = new ArrayList<ITreasureChest>();
        for (ITreasureChest chest : this.chests) {
            if (chest.getType() != type || chest.getLevel() != diff) continue;
            c.add(chest);
        }
        return c;
    }

    public List<ITreasureChest> getChests(Treasure type) {
        ArrayList<ITreasureChest> c = new ArrayList<ITreasureChest>();
        for (ITreasureChest chest : this.chests) {
            if (chest.getType() != type) continue;
            c.add(chest);
        }
        return c;
    }

    public List<ITreasureChest> getChests(Difficulty diff) {
        ArrayList<ITreasureChest> c = new ArrayList<ITreasureChest>();
        for (ITreasureChest chest : this.chests) {
            if (chest.getType() == Treasure.EMPTY || chest.getLevel() != diff) continue;
            c.add(chest);
        }
        return c;
    }

    public List<ITreasureChest> getChests() {
        ArrayList<ITreasureChest> c = new ArrayList<ITreasureChest>();
        for (ITreasureChest chest : this.chests) {
            if (chest.getType() == Treasure.EMPTY) continue;
            c.add(chest);
        }
        return c;
    }
}

