/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.state;

import com.greymerk.roguelike.dungeon.Dungeon;
import com.greymerk.roguelike.dungeon.room.IRoom;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class RoguelikeState
extends class_18 {
    public static boolean flagForGenerationCheck = true;
    private List<Dungeon> dungeons = new CopyOnWriteArrayList<Dungeon>();

    private RoguelikeState() {
    }

    public void addDungeon(Dungeon toAdd) {
        this.dungeons.add(toAdd);
        this.method_80();
    }

    public void update() {
        this.method_80();
    }

    public List<IRoom> getFromLoaded(IWorldEditor editor) {
        ArrayList<IRoom> loadedRooms = new ArrayList<IRoom>();
        for (Dungeon d : this.dungeons) {
            for (IRoom r : d) {
                Coord pos;
                if (r.isGenerated() || !editor.surroundingChunksLoaded(pos = r.getWorldPos())) continue;
                loadedRooms.add(r);
            }
        }
        return loadedRooms;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 dungeonData = new class_2499();
        for (Dungeon d : this.dungeons) {
            class_2487 data = d.getNbt();
            dungeonData.add((Object)data);
        }
        nbt.method_10566("dungeons", (class_2520)dungeonData);
        return nbt;
    }

    public static RoguelikeState createFromNbt(class_2487 tag) {
        RoguelikeState roguelikeState = new RoguelikeState();
        class_2499 dungeonList = tag.method_10554("dungeons", 10);
        roguelikeState.dungeons = RoguelikeState.load(dungeonList);
        return roguelikeState;
    }

    public static List<Dungeon> load(class_2499 dungeonList) {
        CopyOnWriteArrayList<Dungeon> dungeons = new CopyOnWriteArrayList<Dungeon>();
        for (int i = 0; i < dungeonList.size(); ++i) {
            class_2487 data = dungeonList.method_10602(i);
            Dungeon toAdd = new Dungeon(data);
            dungeons.add(toAdd);
        }
        return dungeons;
    }

    public static RoguelikeState getServerState(class_5321<class_1937> key, MinecraftServer server) {
        class_26 persistentStateManager = server.method_3847(key).method_17983();
        RoguelikeState serverState = (RoguelikeState)persistentStateManager.method_17924(RoguelikeState::createFromNbt, RoguelikeState::new, "roguelike");
        return serverState;
    }
}

