/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.settings;

import com.greymerk.roguelike.dungeon.fragment.Fragment;
import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.dungeon.room.RoomProvider;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.filter.IFilter;
import com.greymerk.roguelike.settings.ILevelSettings;
import com.greymerk.roguelike.theme.ITheme;
import com.greymerk.roguelike.theme.Theme;
import com.greymerk.roguelike.util.WeightedRandomizer;
import java.util.List;
import net.minecraft.class_5819;

public abstract class LevelSettingsBase
implements ILevelSettings {
    protected ITheme theme;
    protected WeightedRandomizer<Fragment> walls = new WeightedRandomizer(10);
    protected WeightedRandomizer<Fragment> alcoves = new WeightedRandomizer(10);
    protected RoomProvider rooms = new RoomProvider();
    protected List<IFilter> filters;

    @Override
    public IFragment getWallFragment(class_5819 rand) {
        if (this.walls.isEmpty()) {
            return Fragment.fromType(Fragment.WALL_EMPTY);
        }
        Fragment type = this.walls.get(rand);
        return Fragment.fromType(type);
    }

    @Override
    public IFragment getAlcove(class_5819 rand) {
        if (this.alcoves.isEmpty()) {
            return this.getWallFragment(rand);
        }
        Fragment type = this.alcoves.get(rand);
        return Fragment.fromType(type);
    }

    @Override
    public ITheme getTheme() {
        if (this.theme == null) {
            return Theme.getTheme(Theme.STONE);
        }
        return this.theme;
    }

    @Override
    public RoomProvider getRooms() {
        return this.rooms;
    }

    @Override
    public void applyFilters(IWorldEditor editor, class_5819 rand, IBounded box) {
        if (this.filters == null) {
            return;
        }
        for (IFilter filter : this.filters) {
            filter.apply(editor, rand, this.getTheme(), box);
        }
    }
}

